/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.es.client.editors.requestlist;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.common.client.list.AbstractMultiGridView;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.ConditionalAction;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.es.client.editors.requestlist.RequestListPresenter;
import org.jbpm.workbench.es.client.i18n.Constants;
import org.jbpm.workbench.es.client.util.JobStatusConverter;
import org.jbpm.workbench.es.model.RequestSummary;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@Dependent
@Templated(value="/org/jbpm/workbench/common/client/list/AbstractMultiGridView.html", stylesheet="/org/jbpm/workbench/common/client/resources/css/kie-manage.less")
public class RequestListViewImpl
extends AbstractMultiGridView<RequestSummary, RequestListPresenter>
implements RequestListPresenter.RequestListView {
    private final Constants constants = Constants.INSTANCE;
    @Inject
    private JobStatusConverter jobStatusConverter;

    public List<String> getInitColumns() {
        return Arrays.asList("id", "businessKey", "commandName", "Actions");
    }

    public List<String> getBannedColumns() {
        return Arrays.asList("id", "commandName", "Actions");
    }

    public void initColumns(ListTable extendedPagedTable) {
        ColumnMeta actionsColumnMeta = this.initActionsColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumnMeta.getColumn());
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        columnMetas.add(new ColumnMeta(this.createNumberColumn("id", req -> req.getJobId()), this.constants.Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("businessKey", req -> req.getKey()), this.constants.BusinessKey()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("commandName", req -> req.getCommandName()), this.constants.Type()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("status", req -> this.jobStatusConverter.toWidgetValue(req.getStatus())), this.constants.Status()));
        Column timestampColumn = this.createTextColumn("timestamp", req -> DateUtils.getDateTimeStr((Date)req.getTime()));
        timestampColumn.setDefaultSortAscending(false);
        columnMetas.add(new ColumnMeta(timestampColumn, this.constants.Due_On()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processName", req -> req.getProcessName()), this.constants.Process_Name()));
        columnMetas.add(new ColumnMeta(this.createNumberColumn("processInstanceId", req -> req.getProcessInstanceId()), this.constants.Process_Instance_Id()));
        columnMetas.add(new ColumnMeta(this.createTextColumn("processInstanceDescription", req -> req.getProcessInstanceDescription()), this.constants.Process_Instance_Description()));
        columnMetas.add(actionsColumnMeta);
        extendedPagedTable.setColumnWidth(actionsColumnMeta.getColumn(), 120.0, Style.Unit.PX);
        extendedPagedTable.addColumns(columnMetas);
        extendedPagedTable.getColumnSortList().push(timestampColumn);
    }

    public void initSelectionModel(ListTable<RequestSummary> extendedPagedTable) {
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Jobs_Found());
        extendedPagedTable.setSelectionCallback(job -> ((RequestListPresenter)this.presenter).selectJob((RequestSummary)job));
    }

    protected List<ConditionalAction<RequestSummary>> getConditionalActions() {
        return Arrays.asList(new ConditionalAction(this.constants.Cancel(), job -> {
            if (Window.confirm((String)this.constants.CancelJob())) {
                ((RequestListPresenter)this.presenter).cancelRequest(job.getDeploymentId(), job.getJobId());
            }
        }, ((RequestListPresenter)this.presenter).getCancelActionCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.Requeue(), job -> {
            if (Window.confirm((String)this.constants.RequeueJob())) {
                ((RequestListPresenter)this.presenter).requeueRequest(job.getDeploymentId(), job.getJobId());
            }
        }, ((RequestListPresenter)this.presenter).getRequeueActionCondition(), Boolean.valueOf(false)), new ConditionalAction(this.constants.ViewProcessInstance(), job -> ((RequestListPresenter)this.presenter).openProcessInstanceView(Long.toString(job.getProcessInstanceId())), ((RequestListPresenter)this.presenter).getViewProcessActionCondition(), Boolean.valueOf(true)));
    }
}

