/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend.provider.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.jbpm.workbench.forms.display.api.KieWorkbenchFormRenderingSettings;
import org.jbpm.workbench.forms.display.backend.provider.AbstractFormProvidingEngineTest;
import org.jbpm.workbench.forms.display.backend.provider.AbstractKieWorkbenchFormsProvider;
import org.jbpm.workbench.forms.display.backend.provider.TaskFormValuesProcessor;
import org.jbpm.workbench.forms.display.backend.provider.model.Client;
import org.jbpm.workbench.forms.display.backend.provider.model.Invoice;
import org.jbpm.workbench.forms.display.backend.provider.model.InvoiceLine;
import org.jbpm.workbench.forms.display.backend.provider.util.FormContentReader;
import org.jbpm.workbench.forms.service.providing.TaskRenderingSettings;
import org.jbpm.workbench.forms.service.providing.model.TaskDefinition;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.jbpm.service.bpmn.DynamicBPMNFormGenerator;
import org.kie.workbench.common.forms.serialization.FormDefinitionSerializer;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractTaskFormProvidingTest<PROVIDER extends AbstractKieWorkbenchFormsProvider>
extends AbstractFormProvidingEngineTest<TaskRenderingSettings, TaskFormValuesProcessor, PROVIDER> {
    @Mock
    protected TaskDefinition task;

    @Test
    public void testFormProvider() {
        KieWorkbenchFormRenderingSettings result = this.workbenchFormsProvider.render(this.generateSettings());
        this.checkRenderingSettings(result);
    }

    @Override
    protected TaskRenderingSettings generateSettings() {
        Mockito.when((Object)this.task.getFormName()).thenReturn((Object)"modify");
        Invoice invoice = new Invoice();
        invoice.setClient(new Client(new Long(1234L), "John Snow", "Winterfell"));
        invoice.setDate(new Date());
        invoice.setComments("Everything was perfect");
        invoice.setTotal(150.5);
        ArrayList<InvoiceLine> lines = new ArrayList<InvoiceLine>();
        lines.add(new InvoiceLine("Really Dangerous Sword", 1, 100.5, 100.5));
        lines.add(new InvoiceLine("A comfortable black jacket", 1, 50.0, 50.0));
        invoice.setLines(lines);
        HashMap<String, Invoice> inputs = new HashMap<String, Invoice>();
        inputs.put("invoice", invoice);
        return new TaskRenderingSettings(this.task, inputs, new HashMap(), FormContentReader.getTaskForms(), this.marshallerContext);
    }

    @Override
    protected TaskFormValuesProcessor getProcessorInstance(FormDefinitionSerializer formSerializer, BackendFormRenderingContextManager contextManager, DynamicBPMNFormGenerator dynamicBPMNFormGenerator) {
        return new TaskFormValuesProcessor(formSerializer, contextManager, dynamicBPMNFormGenerator);
    }

    @Override
    protected Map<String, Object> getFormValues() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> client = new HashMap<String, Object>();
        client.put("id", new Long(12345L));
        client.put("name", "Ned Stark");
        client.put("address", "Winterfell");
        ArrayList lines = new ArrayList();
        HashMap<String, Object> line = new HashMap<String, Object>();
        line.put("product", "Really Dangerous & Expensive Sword");
        line.put("quantity", 1);
        line.put("price", 1000.5);
        line.put("total", 1000.5);
        lines.add(line);
        HashMap<String, Object> invoice = new HashMap<String, Object>();
        invoice.put("client", client);
        invoice.put("lines", lines);
        invoice.put("total", 1000.5);
        invoice.put("comments", "Better than expected");
        invoice.put("date", new Date());
        result.put("invoice", invoice);
        return result;
    }

    @Override
    protected void checkRuntimeValues(Map<String, Object> result) {
        TestCase.assertNotNull((String)"There should be an invoice on the result Map", (Object)result.get("invoice"));
        Assert.assertTrue((String)"There should be an invoice on the result Map", (boolean)(result.get("invoice") instanceof Invoice));
        Invoice invoice = (Invoice)result.get("invoice");
        TestCase.assertNotNull((String)"Invoice should have a client", (Object)invoice.getClient());
        Assert.assertEquals((Object)invoice.getClient().getId(), (Object)new Long(12345L));
        Assert.assertEquals((Object)"Ned Stark", (Object)invoice.getClient().getName());
        Assert.assertEquals((Object)"Winterfell", (Object)invoice.getClient().getAddress());
        TestCase.assertNotNull((Object)invoice.getDate());
        TestCase.assertNotNull((Object)invoice.getComments());
        Assert.assertEquals((Object)new Double(1000.5), (Object)invoice.getTotal());
        TestCase.assertNotNull(invoice.getLines());
        Assert.assertTrue((invoice.getLines().size() == 1 ? 1 : 0) != 0);
        InvoiceLine line = invoice.getLines().get(0);
        Assert.assertEquals((Object)"Really Dangerous & Expensive Sword", (Object)line.getProduct());
        Assert.assertEquals((Object)new Integer(1), (Object)line.getQuantity());
        Assert.assertEquals((Object)new Double(1000.5), (Object)line.getPrice());
        Assert.assertEquals((Object)new Double(1000.5), (Object)line.getTotal());
    }
}

