/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend.provider;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.handler.WorkItemHandlerRuntimeException;
import org.jbpm.workbench.forms.display.api.KieWorkbenchFormRenderingSettings;
import org.jbpm.workbench.forms.display.backend.provider.KieWorkbenchFormsValuesProcessor;
import org.jbpm.workbench.forms.service.providing.RenderingSettings;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.kie.soup.project.datamodel.commons.util.MVELEvaluator;
import org.kie.soup.project.datamodel.commons.util.RawMVELEvaluator;
import org.kie.workbench.common.forms.data.modeller.service.ext.ModelReaderService;
import org.kie.workbench.common.forms.data.modeller.service.impl.ext.dmo.runtime.RuntimeDMOModelReader;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.BackendFormRenderingContextManagerImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshallerRegistry;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.FieldValueMarshallerRegistryImpl;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.TextAreaFormFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.models.MultipleSubFormFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.models.SubFormFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.time.DateMultipleInputFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.time.DateMultipleSelectorFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.impl.marshalling.time.LocalDateFieldValueMarshaller;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.validation.ContextModelConstraintsExtractor;
import org.kie.workbench.common.forms.dynamic.backend.server.context.generation.dynamic.validation.impl.ContextModelConstraintsExtractorImpl;
import org.kie.workbench.common.forms.dynamic.service.context.generation.dynamic.BackendFormRenderingContextManager;
import org.kie.workbench.common.forms.dynamic.service.shared.impl.MapModelRenderingContext;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.integerBox.definition.IntegerBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.lists.input.impl.StringMultipleInputFieldDefinition;
import org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.textBox.definition.TextBoxFieldDefinition;
import org.kie.workbench.common.forms.fields.test.TestFieldManager;
import org.kie.workbench.common.forms.fields.test.TestMetaDataEntryManager;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.BPMNFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.formGeneration.impl.runtime.BPMNRuntimeFormGeneratorService;
import org.kie.workbench.common.forms.jbpm.server.service.impl.DynamicBPMNFormGeneratorImpl;
import org.kie.workbench.common.forms.jbpm.service.bpmn.DynamicBPMNFormGenerator;
import org.kie.workbench.common.forms.model.FormDefinition;
import org.kie.workbench.common.forms.service.shared.FieldManager;
import org.kie.workbench.common.forms.service.shared.meta.processing.MetaDataEntryManager;
import org.kie.workbench.common.forms.services.backend.serialization.FormDefinitionSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FieldSerializer;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormDefinitionSerializerImpl;
import org.kie.workbench.common.forms.services.backend.serialization.impl.FormModelSerializer;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

public abstract class AbstractFormsValuesProcessorWithWrongTypesTest<PROCESSOR extends KieWorkbenchFormsValuesProcessor<SETTINGS>, SETTINGS extends RenderingSettings> {
    protected static final String SERVER_TEMPLATE_ID = "serverTemplateId";
    protected static final String ID = "id";
    protected static final String NAME = "name";
    protected static final String ERROR = "error";
    protected static final String LIST = "list";
    protected static final String WRONG_TYPE = "wrong";
    protected Map<String, String> variables = new HashMap<String, String>();
    @Mock
    protected ContentMarshallerContext marshallerContext;
    @Mock
    private ModelReaderService<ClassLoader> modelReaderService;
    private FieldValueMarshallerRegistry registry;
    private DynamicBPMNFormGenerator dynamicBPMNFormGenerator;
    private BackendFormRenderingContextManagerImpl backendFormRenderingContextManager;
    private BPMNRuntimeFormGeneratorService runtimeFormGeneratorService;
    private KieWorkbenchFormRenderingSettings kieWorkbenchFormRenderingSettings;
    private SETTINGS renderingSettings;
    private PROCESSOR processor;

    @Before
    public void init() {
        this.variables.put(ID, Long.class.getName());
        this.variables.put(NAME, String.class.getName());
        this.variables.put(LIST, List.class.getName());
        this.variables.put(ERROR, WorkItemHandlerRuntimeException.class.getName());
        this.variables.put(WRONG_TYPE, "an unexpected and obviously wrong java type");
        SubFormFieldValueMarshaller subFormFieldValueMarshaller = new SubFormFieldValueMarshaller();
        MultipleSubFormFieldValueMarshaller multipleSubFormFieldValueMarshaller = new MultipleSubFormFieldValueMarshaller();
        List<FieldValueMarshaller> marshallers = Arrays.asList(subFormFieldValueMarshaller, multipleSubFormFieldValueMarshaller, new DateMultipleInputFieldValueMarshaller(), new DateMultipleSelectorFieldValueMarshaller(), new LocalDateFieldValueMarshaller(), new TextAreaFormFieldValueMarshaller());
        Instance marshallersInstance = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)marshallersInstance.iterator()).then(proc -> marshallers.iterator());
        this.registry = new FieldValueMarshallerRegistryImpl(marshallersInstance);
        subFormFieldValueMarshaller.setRegistry(this.registry);
        multipleSubFormFieldValueMarshaller.setRegistry(this.registry);
        this.backendFormRenderingContextManager = new BackendFormRenderingContextManagerImpl(this.registry, (ContextModelConstraintsExtractor)new ContextModelConstraintsExtractorImpl());
        this.runtimeFormGeneratorService = new BPMNRuntimeFormGeneratorService(this.modelReaderService, (FieldManager)new TestFieldManager());
        this.dynamicBPMNFormGenerator = new DynamicBPMNFormGeneratorImpl((BPMNFormGeneratorService)this.runtimeFormGeneratorService);
        this.processor = this.getProcessorInstance((FormDefinitionSerializer)new FormDefinitionSerializerImpl(new FieldSerializer(), new FormModelSerializer(), (MetaDataEntryManager)new TestMetaDataEntryManager()), (BackendFormRenderingContextManager)this.backendFormRenderingContextManager, this.dynamicBPMNFormGenerator);
        Mockito.when((Object)this.marshallerContext.getClassloader()).thenReturn((Object)this.getClass().getClassLoader());
        Mockito.when((Object)this.modelReaderService.getModelReader(Matchers.any())).thenReturn((Object)new RuntimeDMOModelReader(this.getClass().getClassLoader(), (MVELEvaluator)new RawMVELEvaluator()));
    }

    @Test
    public void testGenerateRenderingContextWithoutForms() {
        this.renderingSettings = this.getRenderingSettingsWithoutForms();
        this.kieWorkbenchFormRenderingSettings = this.processor.generateRenderingContext(this.renderingSettings, true);
        this.checkGeneratedContext();
    }

    protected void checkGeneratedContext() {
        Assert.assertNotNull((Object)this.kieWorkbenchFormRenderingSettings);
        Assert.assertTrue((boolean)this.kieWorkbenchFormRenderingSettings.isDefaultForms());
        MapModelRenderingContext formRenderingContext = this.kieWorkbenchFormRenderingSettings.getRenderingContext();
        Assert.assertNotNull((Object)formRenderingContext);
        FormDefinition formDefinition = formRenderingContext.getRootForm();
        Assert.assertNotNull((Object)formDefinition);
        Assert.assertEquals((long)3L, (long)formDefinition.getFields().size());
        ((AbstractObjectAssert)Assertions.assertThat((Object)formDefinition.getFieldByBinding(ID)).isNotNull()).hasFieldOrPropertyWithValue(NAME, (Object)ID).hasFieldOrPropertyWithValue("binding", (Object)ID).hasFieldOrPropertyWithValue("standaloneClassName", (Object)Long.class.getName()).isInstanceOf(IntegerBoxFieldDefinition.class);
        ((AbstractObjectAssert)Assertions.assertThat((Object)formDefinition.getFieldByBinding(NAME)).isNotNull()).hasFieldOrPropertyWithValue(NAME, (Object)NAME).hasFieldOrPropertyWithValue("binding", (Object)NAME).hasFieldOrPropertyWithValue("standaloneClassName", (Object)String.class.getName()).isInstanceOf(TextBoxFieldDefinition.class);
        ((AbstractObjectAssert)Assertions.assertThat((Object)formDefinition.getFieldByBinding(LIST)).isNotNull()).hasFieldOrPropertyWithValue(NAME, (Object)LIST).hasFieldOrPropertyWithValue("binding", (Object)LIST).hasFieldOrPropertyWithValue("standaloneClassName", (Object)Object.class.getName()).isInstanceOf(StringMultipleInputFieldDefinition.class);
        Assertions.assertThat((Object)formDefinition.getFieldByBinding(ERROR)).isNull();
        Assertions.assertThat((Object)formDefinition.getFieldByBinding(WRONG_TYPE)).isNull();
    }

    abstract SETTINGS getRenderingSettingsWithoutForms();

    abstract PROCESSOR getProcessorInstance(FormDefinitionSerializer var1, BackendFormRenderingContextManager var2, DynamicBPMNFormGenerator var3);
}

