/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.display.backend;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.workbench.ks.integration.KieServerIntegration;
import org.kie.server.api.marshalling.json.StringContentCaseFile;
import org.kie.server.api.marshalling.json.StringContentMap;
import org.kie.server.api.model.cases.CaseFile;
import org.kie.server.client.CaseServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.UIServicesClient;
import org.kie.server.client.UserTaskServicesClient;

@WebServlet(name="FormRendererProxyServlet", urlPatterns={"/jbpm/forms/*"})
public class FormRendererProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 4517893706538216846L;
    private static final String RENDERER = System.getProperty("org.jbpm.wb.forms.renderer.name", "workbench");
    private Pattern containerPattern = Pattern.compile(".*/containers/([^/]+).*");
    private Pattern caseIdPattern = Pattern.compile(".*/cases/([^/]+).*");
    private Pattern processIdPattern = Pattern.compile(".*/processes/([^/]+).*");
    private Pattern taskIdPattern = Pattern.compile(".*/tasks/([^/]+).*");
    private Pattern taskStatePattern = Pattern.compile(".*/states/([^/]+).*");
    @Inject
    protected KieServerIntegration kieServerIntegration;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serverTemplateId = req.getParameter("serverTemplateId");
        String containerId = req.getParameter("containerId");
        UIServicesClient uiServicesClient = this.getClient(serverTemplateId, UIServicesClient.class);
        String caseDefId = req.getParameter("caseDefId");
        String processId = req.getParameter("processId");
        String taskId = req.getParameter("taskId");
        String formContent = null;
        if (caseDefId != null) {
            formContent = uiServicesClient.renderCaseForm(containerId, caseDefId, RENDERER);
        } else if (processId != null) {
            formContent = uiServicesClient.renderProcessForm(containerId, processId, RENDERER);
        } else if (taskId != null) {
            formContent = uiServicesClient.renderTaskForm(containerId, Long.valueOf(taskId), RENDERER);
        }
        resp.getOutputStream().write(formContent.getBytes("UTF-8"));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serverTemplateId = req.getParameter("templateid");
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            throw new IllegalArgumentException("Missing path information");
        }
        String body = req.getReader().lines().collect(Collectors.joining());
        String containerId = this.extractValue(this.containerPattern, pathInfo);
        if (pathInfo.contains("cases")) {
            String caseDefId = this.extractValue(this.caseIdPattern, pathInfo);
            CaseServicesClient caseServicesClient = this.getClient(serverTemplateId, CaseServicesClient.class);
            String responseBody = caseServicesClient.startCase(containerId, caseDefId, (CaseFile)new StringContentCaseFile(body));
            resp.getOutputStream().write(responseBody.getBytes("UTF-8"));
        } else {
            String processId = this.extractValue(this.processIdPattern, pathInfo);
            ProcessServicesClient processServicesClient = this.getClient(serverTemplateId, ProcessServicesClient.class);
            Long responseBody = processServicesClient.startProcess(containerId, processId, (Map)new StringContentMap(body));
            resp.getOutputStream().write(responseBody.toString().getBytes("UTF-8"));
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serverTemplateId = req.getParameter("templateid");
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            throw new IllegalArgumentException("Missing path information");
        }
        String containerId = this.extractValue(this.containerPattern, pathInfo);
        String taskId = this.extractValue(this.taskIdPattern, pathInfo);
        String taskState = this.extractValue(this.taskStatePattern, pathInfo);
        UserTaskServicesClient taskServicesClient = this.getClient(serverTemplateId, UserTaskServicesClient.class);
        if ("claimed".equalsIgnoreCase(taskState)) {
            taskServicesClient.claimTask(containerId, Long.valueOf(taskId), "");
        } else if ("released".equalsIgnoreCase(taskState)) {
            taskServicesClient.releaseTask(containerId, Long.valueOf(taskId), "");
        } else if ("started".equalsIgnoreCase(taskState)) {
            taskServicesClient.startTask(containerId, Long.valueOf(taskId), "");
        } else if ("stopped".equalsIgnoreCase(taskState)) {
            taskServicesClient.stopTask(containerId, Long.valueOf(taskId), "");
        } else if ("completed".equalsIgnoreCase(taskState)) {
            String body = req.getReader().lines().collect(Collectors.joining());
            taskServicesClient.completeAutoProgress(containerId, Long.valueOf(taskId), "", (Map)new StringContentMap(body));
        } else {
            String body = req.getReader().lines().collect(Collectors.joining());
            taskServicesClient.saveTaskContent(containerId, Long.valueOf(taskId), (Map)new StringContentMap(body));
        }
    }

    protected <T> T getClient(String serverTemplateId, Class<T> clientType) {
        KieServicesClient client = this.getKieServicesClient(serverTemplateId);
        return (T)client.getServicesClient(clientType);
    }

    protected KieServicesClient getKieServicesClient(String serverTemplateId) {
        KieServicesClient client = this.kieServerIntegration.getServerClient(serverTemplateId);
        if (client == null) {
            throw new RuntimeException("No connection to '" + serverTemplateId + "' server(s)");
        }
        return client;
    }

    protected String extractValue(Pattern p, String text) {
        Matcher matcher = p.matcher(text);
        if (matcher.find()) {
            String value = matcher.group(1);
            return value;
        }
        return null;
    }
}

