/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.client.display.standalone;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jbpm.workbench.forms.client.display.api.HumanTaskFormDisplayProvider;
import org.jbpm.workbench.forms.client.display.standalone.StandaloneTaskFormDisplayScreen;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.forms.client.display.views.display.EmbeddedFormDisplayer;
import org.jbpm.workbench.forms.display.api.HumanTaskDisplayerConfig;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@RunWith(value=MockitoJUnitRunner.class)
public class StandaloneTaskFormDisplayScreenTest {
    private static final String SERVER_TEMPLATE_ID = "test-kie-server";
    private static final String DOMAIN_ID = "test_1.0.0";
    private static final String TASK_ID = "1";
    @Mock
    private PlaceManager placeManager;
    @Mock
    private EmbeddedFormDisplayer displayer;
    @Mock
    private HumanTaskFormDisplayProvider humanTaskFormDisplayProvider;
    private StandaloneTaskFormDisplayScreen screen;

    @Before
    public void init() {
        this.screen = new StandaloneTaskFormDisplayScreen(this.placeManager, this.displayer, this.humanTaskFormDisplayProvider);
    }

    @Test
    public void testBasicFunctions() {
        ((AbstractStringAssert)Assertions.assertThat((String)this.screen.getTitle()).isNotNull()).isEmpty();
        ((ObjectAssert)Assertions.assertThat((Object)this.screen.getView()).isNotNull()).isEqualTo((Object)this.displayer);
    }

    @Test
    public void testOnOpen() {
        DefaultPlaceRequest place = new DefaultPlaceRequest();
        place.addParameter("serverTemplateId", SERVER_TEMPLATE_ID);
        place.addParameter("domainId", DOMAIN_ID);
        place.addParameter("taskId", TASK_ID);
        this.screen.onStartup((PlaceRequest)place);
        this.screen.onOpen();
        ArgumentCaptor configArgumentCaptor = ArgumentCaptor.forClass(HumanTaskDisplayerConfig.class);
        ((HumanTaskFormDisplayProvider)Mockito.verify((Object)this.humanTaskFormDisplayProvider)).setup((HumanTaskDisplayerConfig)configArgumentCaptor.capture(), (FormDisplayerView)Matchers.any());
        HumanTaskDisplayerConfig config = (HumanTaskDisplayerConfig)configArgumentCaptor.getValue();
        Assertions.assertThat((Object)config).isNotNull();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)config.getKey()).isNotNull()).hasFieldOrPropertyWithValue("serverTemplateId", (Object)SERVER_TEMPLATE_ID)).hasFieldOrPropertyWithValue("deploymentId", (Object)DOMAIN_ID)).hasFieldOrPropertyWithValue("taskId", (Object)Long.decode(TASK_ID));
        ArgumentCaptor commandArgumentCaptor = ArgumentCaptor.forClass(Command.class);
        ((EmbeddedFormDisplayer)Mockito.verify((Object)this.displayer)).setOnCloseCommand((Command)commandArgumentCaptor.capture());
        Command command = (Command)commandArgumentCaptor.getValue();
        Assertions.assertThat((Object)command).isNotNull();
        command.execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).closePlace((PlaceRequest)place);
    }
}

