/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.workbench.forms.client.display.displayer;

import elemental2.dom.HTMLDivElement;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.forms.dynamic.client.DynamicFormRenderer;
import org.kie.workbench.common.forms.dynamic.service.shared.FormRenderingContext;

import javax.inject.Inject;

@Templated
public class KieWorkbenchFormDisplayerViewImpl implements KieWorkbenchFormDisplayerView, IsElement {

    @Inject
    @DataField
    private HTMLDivElement header;

    @Inject
    @DataField
    private HTMLDivElement alert;

    @Inject
    @DataField
    private DynamicFormRenderer form;

    @Override
    public void show(FormRenderingContext ctx, boolean showHeader) {
        boolean alertAdded = header.contains(alert);

        if(!alertAdded && showHeader) {
            header.appendChild(alert);
        } else if(alertAdded && !showHeader) {
            header.removeChild(alert);
        }

        form.render(ctx);
    }

    @Override
    public boolean isValid() {
        return form.isValid();
    }
}
