/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.client.display.views.display;

import org.jbpm.workbench.forms.client.display.GenericFormDisplayer;
import org.jbpm.workbench.forms.client.display.views.display.EmbeddedFormDisplayer;
import org.jbpm.workbench.forms.client.display.views.display.EmbeddedFormDisplayerView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class EmbeddedFormDisplayerTest {
    public static final String ERROR_HEADER = "Error header.";
    public static final String ERROR_MESSAGE = "Cannot render form.";
    @Mock
    private EmbeddedFormDisplayerView view;
    @Mock
    private Command onCloseCommand;
    @Mock
    private GenericFormDisplayer formDisplayer;
    private EmbeddedFormDisplayer displayer;

    @Before
    public void init() {
        this.displayer = new EmbeddedFormDisplayer(this.view);
        this.displayer.setOnCloseCommand(this.onCloseCommand);
    }

    @Test
    public void testDisplayForm() {
        this.displayer.display(this.formDisplayer);
        ((EmbeddedFormDisplayerView)Mockito.verify((Object)this.view)).display(this.formDisplayer);
        Assert.assertEquals((Object)this.formDisplayer, (Object)this.displayer.getCurrentDisplayer());
        Assert.assertEquals((Object)this.onCloseCommand, (Object)this.displayer.getOnCloseCommand());
        this.displayer.asWidget();
        ((EmbeddedFormDisplayerView)Mockito.verify((Object)this.view)).asWidget();
    }

    @Test
    public void testShowErrorMessage() {
        this.displayer.displayErrorMessage(ERROR_HEADER, ERROR_MESSAGE);
        ((EmbeddedFormDisplayerView)Mockito.verify((Object)this.view)).showErrorMessage(ERROR_HEADER, ERROR_MESSAGE);
    }
}

