/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.forms.modeler.client.editors.displayers;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.formModeler.api.client.FormRenderContextTO;
import org.jbpm.formModeler.api.events.FormSubmittedEvent;
import org.jbpm.formModeler.api.events.ResizeFormcontainerEvent;
import org.jbpm.formModeler.renderer.client.FormRendererWidget;
import org.jbpm.workbench.forms.client.display.util.JSNIHelper;
import org.jbpm.workbench.forms.display.view.FormContentResizeListener;
import org.jbpm.workbench.forms.modeler.client.editors.displayers.test.TestFormModellerTaskDisplayerImpl;
import org.jbpm.workbench.forms.modeler.display.impl.FormModelerFormRenderingSettings;
import org.jbpm.workbench.forms.modeler.service.FormModelerProcessStarterEntryPoint;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class FormModellerTaskDisplayerTest {
    @Mock
    protected TaskService taskService;
    @Mock
    protected EventSourceMock<TaskRefreshedEvent> taskRefreshed;
    @Mock
    protected User identity;
    @GwtMock
    private FormRendererWidget rendererWidget;
    @Mock
    private FormModelerProcessStarterEntryPoint service;
    @Mock
    private FormContentResizeListener resizeListener;
    @GwtMock
    protected JSNIHelper jsniHelper;
    protected CallerMock<TaskService> taskServiceCaller;
    private CallerMock<FormModelerProcessStarterEntryPoint> serviceCaller;
    private TestFormModellerTaskDisplayerImpl displayer;
    private FormModelerFormRenderingSettings settings = new FormModelerFormRenderingSettings("ctxtID");

    @Before
    public void init() {
        this.serviceCaller = new CallerMock((Object)this.service);
        this.taskServiceCaller = new CallerMock((Object)this.taskService);
        this.displayer = new TestFormModellerTaskDisplayerImpl(this.rendererWidget, (Caller<FormModelerProcessStarterEntryPoint>)this.serviceCaller);
        this.displayer.setIdentity(this.identity);
        this.displayer.setJSNIHelper(this.jsniHelper);
        this.displayer.setTaskRefreshedEvent((Event<TaskRefreshedEvent>)this.taskRefreshed);
        this.displayer.setResizeListener(this.resizeListener);
        this.displayer.setTaskService((Caller<TaskService>)this.taskServiceCaller);
    }

    @Test
    public void testDisplay() {
        this.displayer.setRenderingSettings(this.settings);
        this.displayer.initDisplayer();
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).loadContext(this.settings.getContextId());
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).setVisible(true);
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).asWidget();
    }

    @Test
    public void testResizeEventWithSettings() {
        this.displayer.setRenderingSettings(this.settings);
        ResizeFormcontainerEvent resizeEvent = new ResizeFormcontainerEvent();
        resizeEvent.setContext(new FormRenderContextTO(this.settings.getContextId()));
        resizeEvent.setHeight(100);
        resizeEvent.setWidth(100);
        this.displayer.onFormResized(resizeEvent);
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).resize(100, 100);
        ((FormContentResizeListener)Mockito.verify((Object)this.resizeListener)).resize(100, 100);
    }

    @Test
    public void testResizeEventWithoutSettings() {
        ResizeFormcontainerEvent resizeEvent = new ResizeFormcontainerEvent();
        resizeEvent.setContext(new FormRenderContextTO(this.settings.getContextId()));
        resizeEvent.setHeight(100);
        resizeEvent.setWidth(100);
        this.displayer.onFormResized(resizeEvent);
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget, (VerificationMode)Mockito.never())).resize(100, 100);
        ((FormContentResizeListener)Mockito.verify((Object)this.resizeListener, (VerificationMode)Mockito.never())).resize(100, 100);
    }

    @Test
    public void testClaimTask() {
        this.displayer.setRenderingSettings(this.settings);
        this.displayer.claimFromDisplayer();
        ((FormModelerProcessStarterEntryPoint)Mockito.verify((Object)this.service)).clearContext(this.settings.getContextId());
        ((TaskService)Mockito.verify((Object)this.taskService)).claimTask(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((EventSourceMock)Mockito.verify(this.taskRefreshed)).fire(Matchers.any());
        ((JSNIHelper)Mockito.verify((Object)this.jsniHelper)).notifySuccessMessage(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testStartTask() {
        this.displayer.setRenderingSettings(this.settings);
        this.displayer.startFromDisplayer();
        ((FormModelerProcessStarterEntryPoint)Mockito.verify((Object)this.service)).clearContext(this.settings.getContextId());
        ((TaskService)Mockito.verify((Object)this.taskService)).startTask(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((EventSourceMock)Mockito.verify(this.taskRefreshed)).fire(Matchers.any());
        ((JSNIHelper)Mockito.verify((Object)this.jsniHelper)).notifySuccessMessage(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testReleaseTask() {
        this.displayer.setRenderingSettings(this.settings);
        this.displayer.releaseFromDisplayer();
        ((FormModelerProcessStarterEntryPoint)Mockito.verify((Object)this.service)).clearContext(this.settings.getContextId());
        ((TaskService)Mockito.verify((Object)this.taskService)).releaseTask(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((EventSourceMock)Mockito.verify(this.taskRefreshed)).fire(Matchers.any());
        ((JSNIHelper)Mockito.verify((Object)this.jsniHelper)).notifySuccessMessage(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testSaveTaskWithSettings() {
        this.displayer.setRenderingSettings(this.settings);
        this.displayer.saveStateFromDisplayer();
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).submitFormAndPersist();
        FormSubmittedEvent formSubmittedEvent = new FormSubmittedEvent(new FormRenderContextTO(this.settings.getContextId(), true, 0));
        this.displayer.onFormSubmitted(formSubmittedEvent);
        ((FormModelerProcessStarterEntryPoint)Mockito.verify((Object)this.service)).saveTaskStateFromRenderContext(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((EventSourceMock)Mockito.verify(this.taskRefreshed)).fire(Matchers.any());
        ((JSNIHelper)Mockito.verify((Object)this.jsniHelper)).notifySuccessMessage(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testSaveTaskWithoutSettings() {
        this.displayer.saveStateFromDisplayer();
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).submitFormAndPersist();
        FormSubmittedEvent formSubmittedEvent = new FormSubmittedEvent(new FormRenderContextTO(this.settings.getContextId(), true, 0));
        this.displayer.onFormSubmitted(formSubmittedEvent);
        ((FormModelerProcessStarterEntryPoint)Mockito.verify((Object)this.service, (VerificationMode)Mockito.never())).saveTaskStateFromRenderContext(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((EventSourceMock)Mockito.verify(this.taskRefreshed, (VerificationMode)Mockito.never())).fire(Matchers.any());
        ((JSNIHelper)Mockito.verify((Object)this.jsniHelper, (VerificationMode)Mockito.never())).notifySuccessMessage(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testCompleteTaskWithSettings() {
        this.displayer.setRenderingSettings(this.settings);
        this.displayer.completeFromDisplayer();
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).submitFormAndPersist();
        FormSubmittedEvent formSubmittedEvent = new FormSubmittedEvent(new FormRenderContextTO(this.settings.getContextId(), true, 0));
        this.displayer.onFormSubmitted(formSubmittedEvent);
        ((FormModelerProcessStarterEntryPoint)Mockito.verify((Object)this.service)).completeTaskFromContext(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((EventSourceMock)Mockito.verify(this.taskRefreshed)).fire(Matchers.any());
        ((JSNIHelper)Mockito.verify((Object)this.jsniHelper)).notifySuccessMessage(Matchers.anyString(), Matchers.anyString());
    }

    @Test
    public void testCompleteTaskWithoutSettings() {
        this.displayer.completeFromDisplayer();
        ((FormRendererWidget)Mockito.verify((Object)this.rendererWidget)).submitFormAndPersist();
        FormSubmittedEvent formSubmittedEvent = new FormSubmittedEvent(new FormRenderContextTO(this.settings.getContextId(), true, 0));
        this.displayer.onFormSubmitted(formSubmittedEvent);
        ((FormModelerProcessStarterEntryPoint)Mockito.verify((Object)this.service, (VerificationMode)Mockito.never())).saveTaskStateFromRenderContext(Matchers.anyString(), Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((EventSourceMock)Mockito.verify(this.taskRefreshed, (VerificationMode)Mockito.never())).fire(Matchers.any());
        ((JSNIHelper)Mockito.verify((Object)this.jsniHelper, (VerificationMode)Mockito.never())).notifySuccessMessage(Matchers.anyString(), Matchers.anyString());
    }
}

