/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.util;

import java.util.Arrays;

public enum TaskStatus {
    TASK_STATUS_CREATED("Created"),
    TASK_STATUS_READY("Ready"),
    TASK_STATUS_RESERVED("Reserved"),
    TASK_STATUS_IN_PROGRESS("InProgress"),
    TASK_STATUS_SUSPENDED("Suspended"),
    TASK_STATUS_FAILED("Failed"),
    TASK_STATUS_ERROR("Error"),
    TASK_STATUS_EXITED("Exited"),
    TASK_STATUS_OBSOLETE("Obsolete"),
    TASK_STATUS_COMPLETED("Completed");

    private String identifier;

    private TaskStatus(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public static TaskStatus fromStatus(String status) {
        return Arrays.stream(TaskStatus.values()).filter(e -> e.getIdentifier().equals(status)).findFirst().get();
    }

    public boolean equals(String otherName) {
        return this.identifier.equals(otherName);
    }
}

