/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.backend.server;

import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.jbpm.workbench.ht.backend.server.DataSetDefsBootstrap;
import org.jbpm.workbench.ks.integration.KieServerDataSetProvider;
import org.jbpm.workbench.ks.integration.event.QueryDefinitionLoaded;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.server.api.model.definition.QueryDefinition;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetDefsBootstrapTest {
    @Mock
    DataSetDefRegistry dataSetDefRegistry;
    @InjectMocks
    DataSetDefsBootstrap dataSetsBootstrap;

    @Test
    public void testHumanTasksDataSet() {
        QueryDefinition qd = QueryDefinition.builder().name("jbpmHumanTasks").expression("SELECT *").source("source").target("target").build();
        this.dataSetsBootstrap.registerDataSetDefinitions(new QueryDefinitionLoaded(qd));
        ArgumentCaptor argument = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistry)).registerDataSetDef((DataSetDef)argument.capture());
        SQLDataSetDef dataSetDef = (SQLDataSetDef)argument.getValue();
        Assert.assertEquals((Object)"jbpmHumanTasks", (Object)dataSetDef.getUUID());
        Assert.assertEquals((Object)"target-jbpmHumanTasks", (Object)dataSetDef.getName());
        Assert.assertEquals((Object)KieServerDataSetProvider.TYPE, (Object)dataSetDef.getProvider());
        Assert.assertEquals((Object)"SELECT *", (Object)dataSetDef.getDbSQL());
        Assert.assertEquals((long)19L, (long)dataSetDef.getColumns().size());
    }

    @Test
    public void testHumanTasksWithUserDataSet() {
        QueryDefinition qd = QueryDefinition.builder().name("jbpmHumanTasksWithUser").expression("SELECT *").source("source").target("target").build();
        this.dataSetsBootstrap.registerDataSetDefinitions(new QueryDefinitionLoaded(qd));
        ArgumentCaptor argument = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistry)).registerDataSetDef((DataSetDef)argument.capture());
        SQLDataSetDef dataSetDef = (SQLDataSetDef)argument.getValue();
        Assert.assertEquals((Object)"jbpmHumanTasksWithUser", (Object)dataSetDef.getUUID());
        Assert.assertEquals((Object)"target-jbpmHumanTasksWithUser", (Object)dataSetDef.getName());
        Assert.assertEquals((Object)KieServerDataSetProvider.TYPE, (Object)dataSetDef.getProvider());
        Assert.assertEquals((Object)"SELECT *", (Object)dataSetDef.getDbSQL());
        Assert.assertEquals((long)21L, (long)dataSetDef.getColumns().size());
    }

    @Test
    public void testHumanTasksWithAdminDataSet() {
        QueryDefinition qd = QueryDefinition.builder().name("jbpmHumanTasksWithAdmin").expression("SELECT *").source("source").target("target").build();
        this.dataSetsBootstrap.registerDataSetDefinitions(new QueryDefinitionLoaded(qd));
        ArgumentCaptor argument = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistry)).registerDataSetDef((DataSetDef)argument.capture());
        SQLDataSetDef dataSetDef = (SQLDataSetDef)argument.getValue();
        Assert.assertEquals((Object)"jbpmHumanTasksWithAdmin", (Object)dataSetDef.getUUID());
        Assert.assertEquals((Object)"target-jbpmHumanTasksWithAdmin", (Object)dataSetDef.getName());
        Assert.assertEquals((Object)KieServerDataSetProvider.TYPE, (Object)dataSetDef.getProvider());
        Assert.assertEquals((Object)"SELECT *", (Object)dataSetDef.getDbSQL());
        Assert.assertEquals((long)21L, (long)dataSetDef.getColumns().size());
    }

    @Test
    public void testHumanTasksWithVariablesDataSet() {
        QueryDefinition qd = QueryDefinition.builder().name("jbpmHumanTasksWithVariables").expression("SELECT *").source("source").target("target").build();
        this.dataSetsBootstrap.registerDataSetDefinitions(new QueryDefinitionLoaded(qd));
        ArgumentCaptor argument = ArgumentCaptor.forClass(SQLDataSetDef.class);
        ((DataSetDefRegistry)Mockito.verify((Object)this.dataSetDefRegistry)).registerDataSetDef((DataSetDef)argument.capture());
        SQLDataSetDef dataSetDef = (SQLDataSetDef)argument.getValue();
        Assert.assertEquals((Object)"jbpmHumanTasksWithVariables", (Object)dataSetDef.getUUID());
        Assert.assertEquals((Object)"target-jbpmHumanTasksWithVariables", (Object)dataSetDef.getName());
        Assert.assertEquals((Object)KieServerDataSetProvider.TYPE, (Object)dataSetDef.getProvider());
        Assert.assertEquals((Object)"SELECT *", (Object)dataSetDef.getDbSQL());
        Assert.assertEquals((long)3L, (long)dataSetDef.getColumns().size());
    }
}

