/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.backend.server;

import java.util.Arrays;
import org.jbpm.workbench.ht.backend.server.TaskAssignmentSummaryMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.model.instance.TaskInstance;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskAssignmentSummaryMapperTest {
    private static final String CURRENT_USER = "CURRENT_USER";
    private static final String OTHER_USER = "OTHER_USER";
    @Mock
    private IdentityProvider identityProvider;

    @Before
    public void initMocks() {
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)CURRENT_USER);
    }

    @Test
    public void preventDelegateCompletedTask() {
        TaskInstance task = new TaskInstance();
        task.setStatus("Completed");
        Assert.assertFalse((boolean)new TaskAssignmentSummaryMapper().isDelegationAllowed(task, this.identityProvider));
    }

    @Test
    public void allowDelegateActualOwner() {
        TaskInstance task = new TaskInstance();
        task.setActualOwner(CURRENT_USER);
        Assert.assertTrue((boolean)new TaskAssignmentSummaryMapper().isDelegationAllowed(task, this.identityProvider));
    }

    @Test
    public void allowDelegateActualOwnerNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setActualOwner(OTHER_USER);
        Assert.assertFalse((boolean)new TaskAssignmentSummaryMapper().isDelegationAllowed(task, this.identityProvider));
    }

    @Test
    public void allowDelegateCreatedBy() {
        TaskInstance task = new TaskInstance();
        task.setCreatedBy(CURRENT_USER);
        Assert.assertTrue((boolean)new TaskAssignmentSummaryMapper().isDelegationAllowed(task, this.identityProvider));
    }

    @Test
    public void allowDelegateCreatedByNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setCreatedBy(OTHER_USER);
        Assert.assertFalse((boolean)new TaskAssignmentSummaryMapper().isDelegationAllowed(task, this.identityProvider));
    }

    @Test
    public void allowDelegatePotentialOwner() {
        TaskInstance task = new TaskInstance();
        task.setPotentialOwners(Arrays.asList(CURRENT_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertTrue((boolean)new TaskAssignmentSummaryMapper().isDelegationAllowed(task, this.identityProvider));
    }

    @Test
    public void allowDelegatePotentialOwnerNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setPotentialOwners(Arrays.asList(OTHER_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertFalse((boolean)new TaskAssignmentSummaryMapper().isDelegationAllowed(task, this.identityProvider));
    }

    @Test
    public void allowDelegateBusinessAdmins() {
        TaskInstance task = new TaskInstance();
        task.setBusinessAdmins(Arrays.asList(CURRENT_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertTrue((boolean)new TaskAssignmentSummaryMapper().isDelegationAllowed(task, this.identityProvider));
    }

    @Test
    public void allowDelegateBusinessAdminsNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setBusinessAdmins(Arrays.asList(OTHER_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertFalse((boolean)new TaskAssignmentSummaryMapper().isDelegationAllowed(task, this.identityProvider));
    }

    @Test
    public void preventForwardCompletedTask() {
        TaskInstance task = new TaskInstance();
        task.setStatus("Completed");
        Assert.assertFalse((boolean)new TaskAssignmentSummaryMapper().isForwardAllowed(task, this.identityProvider));
    }

    @Test
    public void allowForwardActualOwner() {
        TaskInstance task = new TaskInstance();
        task.setActualOwner(CURRENT_USER);
        Assert.assertTrue((boolean)new TaskAssignmentSummaryMapper().isForwardAllowed(task, this.identityProvider));
    }

    @Test
    public void allowForwardActualOwnerNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setActualOwner(OTHER_USER);
        Assert.assertFalse((boolean)new TaskAssignmentSummaryMapper().isForwardAllowed(task, this.identityProvider));
    }

    @Test
    public void allowForwardPotentialOwner() {
        TaskInstance task = new TaskInstance();
        task.setPotentialOwners(Arrays.asList(CURRENT_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertTrue((boolean)new TaskAssignmentSummaryMapper().isForwardAllowed(task, this.identityProvider));
    }

    @Test
    public void allowForwardPotentialOwnerNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setPotentialOwners(Arrays.asList(OTHER_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertFalse((boolean)new TaskAssignmentSummaryMapper().isForwardAllowed(task, this.identityProvider));
    }

    @Test
    public void allowForwardBusinessAdmins() {
        TaskInstance task = new TaskInstance();
        task.setBusinessAdmins(Arrays.asList(CURRENT_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertTrue((boolean)new TaskAssignmentSummaryMapper().isForwardAllowed(task, this.identityProvider));
    }

    @Test
    public void allowForwardBusinessAdminsNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setBusinessAdmins(Arrays.asList(OTHER_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        Assert.assertFalse((boolean)new TaskAssignmentSummaryMapper().isForwardAllowed(task, this.identityProvider));
    }
}

