/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.backend.server;

import java.util.Arrays;
import org.jbpm.workbench.ht.backend.server.TaskAssignmentSummaryMapper;
import org.jbpm.workbench.ht.util.TaskStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.internal.identity.IdentityProvider;
import org.kie.server.api.model.instance.TaskInstance;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskAssignmentSummaryMapperTest {
    private static final String CURRENT_USER = "CURRENT_USER";
    private static final String OTHER_USER = "OTHER_USER";
    @Mock
    private IdentityProvider identityProvider;

    @Before
    public void initMocks() {
        Mockito.when((Object)this.identityProvider.getName()).thenReturn((Object)CURRENT_USER);
    }

    @Test
    public void allowDelegateOwnedTasks() {
        TaskInstance task = new TaskInstance();
        task.setActualOwner(CURRENT_USER);
        this.assertDelegationAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertDelegationAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    @Test
    public void allowDelegateActualOwnerNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setActualOwner(OTHER_USER);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    @Test
    public void allowDelegatePotentialOwnerOnReadyTasks() {
        TaskInstance task = new TaskInstance();
        task.setPotentialOwners(Arrays.asList(CURRENT_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        this.assertDelegationAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    @Test
    public void allowDelegatePotentialOwnerNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setPotentialOwners(Arrays.asList(OTHER_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    @Test
    public void allowDelegateBusinessAdmins() {
        TaskInstance task = new TaskInstance();
        task.setBusinessAdmins(Arrays.asList(CURRENT_USER));
        task.setStatus(TaskStatus.TASK_STATUS_READY.getIdentifier());
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        this.assertDelegationAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertDelegationAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertDelegationAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    @Test
    public void allowDelegateBusinessAdminsNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setBusinessAdmins(Arrays.asList(OTHER_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertDelegationDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    @Test
    public void allowForwardActualOwner() {
        TaskInstance task = new TaskInstance();
        task.setActualOwner(CURRENT_USER);
        this.assertForwardAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertForwardAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    @Test
    public void allowForwardActualOwnerNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setActualOwner(OTHER_USER);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    @Test
    public void allowForwardPotentialOwner() {
        TaskInstance task = new TaskInstance();
        task.setPotentialOwners(Arrays.asList(CURRENT_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        this.assertForwardAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    @Test
    public void allowForwardPotentialOwnerNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setPotentialOwners(Arrays.asList(OTHER_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    @Test
    public void allowForwardBusinessAdmins() {
        TaskInstance task = new TaskInstance();
        task.setBusinessAdmins(Arrays.asList(CURRENT_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        this.assertForwardAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertForwardAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertForwardAllowed(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    @Test
    public void allowForwardBusinessAdminsNotCurrentUser() {
        TaskInstance task = new TaskInstance();
        task.setBusinessAdmins(Arrays.asList(OTHER_USER));
        Mockito.when((Object)this.identityProvider.getRoles()).thenReturn(Arrays.asList(CURRENT_USER));
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_READY);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_RESERVED);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_IN_PROGRESS);
        this.assertForwardDenied(task, this.identityProvider, TaskStatus.TASK_STATUS_COMPLETED);
    }

    private void assertDelegationAllowed(TaskInstance task, IdentityProvider identityProvider, TaskStatus taskStatus) {
        task.setStatus(taskStatus.getIdentifier());
        Assert.assertTrue((boolean)new TaskAssignmentSummaryMapper().isDelegationAllowed(task, identityProvider));
    }

    private void assertDelegationDenied(TaskInstance task, IdentityProvider identityProvider, TaskStatus taskStatus) {
        task.setStatus(taskStatus.getIdentifier());
        Assert.assertFalse((boolean)new TaskAssignmentSummaryMapper().isDelegationAllowed(task, identityProvider));
    }

    private void assertForwardAllowed(TaskInstance task, IdentityProvider identityProvider, TaskStatus taskStatus) {
        task.setStatus(taskStatus.getIdentifier());
        Assert.assertTrue((boolean)new TaskAssignmentSummaryMapper().isForwardAllowed(task, identityProvider));
    }

    private void assertForwardDenied(TaskInstance task, IdentityProvider identityProvider, TaskStatus taskStatus) {
        task.setStatus(taskStatus.getIdentifier());
        Assert.assertFalse((boolean)new TaskAssignmentSummaryMapper().isForwardAllowed(task, identityProvider));
    }
}

