/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskdetails;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.common.client.util.UTCDateBox;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.model.events.TaskCalendarEvent;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;

@Dependent
public class TaskDetailsPresenter {
    private Constants constants = Constants.INSTANCE;
    TaskDetailsView view;
    @Inject
    private Caller<TaskService> taskService;
    private Event<TaskRefreshedEvent> taskRefreshed;
    private Event<TaskCalendarEvent> taskCalendarEvent;
    private long currentTaskId = 0L;
    private String currentServerTemplateId;
    private String currentContainerId;

    @Inject
    public TaskDetailsPresenter(TaskDetailsView view, Event<TaskRefreshedEvent> taskRefreshed, Event<TaskCalendarEvent> taskCalendarEvent) {
        this.view = view;
        this.taskRefreshed = taskRefreshed;
        this.taskCalendarEvent = taskCalendarEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void updateTask(String taskDescription, String userId, Date dueDate, int priority) {
        if (this.currentTaskId > 0L) {
            ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

                public void callback(Void nothing) {
                    TaskDetailsPresenter.this.view.displayNotification(TaskDetailsPresenter.this.constants.TaskDetailsUpdatedForTaskId(TaskDetailsPresenter.this.currentTaskId));
                    TaskDetailsPresenter.this.taskRefreshed.fire((Object)new TaskRefreshedEvent(TaskDetailsPresenter.this.currentTaskId));
                    TaskDetailsPresenter.this.taskCalendarEvent.fire((Object)new TaskCalendarEvent(Long.valueOf(TaskDetailsPresenter.this.currentTaskId)));
                }
            })).updateTask(this.currentServerTemplateId, this.currentContainerId, Long.valueOf(this.currentTaskId), Integer.valueOf(priority), taskDescription, dueDate);
        }
    }

    public void refreshTask() {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<TaskSummary>(){

            public void callback(TaskSummary details) {
                if (details == null) {
                    TaskDetailsPresenter.this.setReadOnlyTaskDetail();
                    return;
                }
                if (details.getStatus().equals("Completed")) {
                    TaskDetailsPresenter.this.setReadOnlyTaskDetail();
                }
                TaskDetailsPresenter.this.view.setTaskDescription(details.getDescription());
                Long date = UTCDateBox.date2utc((Date)details.getExpirationTime());
                if (date != null) {
                    TaskDetailsPresenter.this.view.setDueDate(date);
                    TaskDetailsPresenter.this.view.setDueDateTime(date);
                }
                TaskDetailsPresenter.this.view.setUser(details.getActualOwner());
                TaskDetailsPresenter.this.view.setTaskStatus(details.getStatus());
                TaskDetailsPresenter.this.view.setTaskPriority(String.valueOf(details.getPriority()));
            }
        })).getTask(this.currentServerTemplateId, this.currentContainerId, Long.valueOf(this.currentTaskId));
    }

    public void setReadOnlyTaskDetail() {
        this.view.setTaskDescriptionEnabled(false);
        this.view.setDueDateEnabled(false);
        this.view.setDueDateTimeEnabled(false);
        this.view.setTaskPriorityEnabled(false);
        this.view.setUpdateTaskVisible(false);
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.currentServerTemplateId = event.getServerTemplateId();
        this.currentContainerId = event.getContainerId();
        this.refreshTask();
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshTask();
        }
    }

    public static interface TaskDetailsView
    extends IsWidget {
        public void init(TaskDetailsPresenter var1);

        public void setTaskDescription(String var1);

        public void setTaskDescriptionEnabled(Boolean var1);

        public void setDueDate(Long var1);

        public void setDueDateEnabled(Boolean var1);

        public void setDueDateTime(Long var1);

        public void setDueDateTimeEnabled(Boolean var1);

        public void setUser(String var1);

        public void setTaskStatus(String var1);

        public void setTaskPriority(String var1);

        public void setTaskPriorityEnabled(Boolean var1);

        public void setUpdateTaskVisible(Boolean var1);

        public void displayNotification(String var1);
    }
}

