/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist.grid.dash;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CompositeCell;
import com.google.gwt.cell.client.NumberCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.view.client.AbstractDataProvider;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jbpm.workbench.common.client.experimental.grid.base.ExtendedPagedTable;
import org.jbpm.workbench.common.client.list.base.AbstractListPresenter;
import org.jbpm.workbench.common.client.list.base.AbstractMultiGridView;
import org.jbpm.workbench.common.client.resources.CommonResources;
import org.jbpm.workbench.common.client.util.ButtonActionCell;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.workbench.df.client.list.base.DataSetEditorManager;
import org.jbpm.workbench.ht.client.editors.taskslist.grid.AbstractTasksListGridPresenter;
import org.jbpm.workbench.ht.client.resources.HumanTaskResources;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mvp.Command;

@Dependent
public class DataSetTasksListGridViewImpl
extends AbstractMultiGridView<TaskSummary, AbstractTasksListGridPresenter>
implements AbstractTasksListGridPresenter.DataSetTaskListView {
    public static final String DATASET_TASK_LIST_PREFIX = "DataSetTaskListGrid";
    public static final String COL_ID_ACTIONS = "actions";
    private final Constants constants = Constants.INSTANCE;
    @Inject
    private DataSetEditorManager dataSetEditorManager;

    public void init(final AbstractTasksListGridPresenter presenter) {
        final ArrayList<String> bannedColumns = new ArrayList<String>();
        bannedColumns.add("name");
        bannedColumns.add(COL_ID_ACTIONS);
        final ArrayList<String> initColumns = new ArrayList<String>();
        initColumns.add("name");
        initColumns.add("processId");
        initColumns.add("status");
        initColumns.add("createdOn");
        initColumns.add(COL_ID_ACTIONS);
        final Button button = (Button)GWT.create(Button.class);
        button.setIcon(IconType.PLUS);
        button.setSize(ButtonSize.SMALL);
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                final String key = DataSetTasksListGridViewImpl.this.getValidKeyForAdditionalListGrid("DataSetTaskListGrid_");
                Command addNewGrid = new Command(){

                    public void execute() {
                        final ExtendedPagedTable extendedPagedTable = DataSetTasksListGridViewImpl.this.createGridInstance(new GridGlobalPreferences(key, initColumns, bannedColumns), key);
                        extendedPagedTable.setDataProvider((AbstractDataProvider)presenter.getDataProvider());
                        DataSetTasksListGridViewImpl.this.filterPagedTable.createNewTab((PagedTable)extendedPagedTable, key, button, new Command(){

                            public void execute() {
                                DataSetTasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                                DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
                            }
                        });
                        DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
                    }
                };
                FilterSettings tableSettings = DataSetTasksListGridViewImpl.this.createTableSettingsPrototype();
                tableSettings.setKey(key);
                DataSetTasksListGridViewImpl.this.dataSetEditorManager.showTableSettingsEditor(DataSetTasksListGridViewImpl.this.filterPagedTable, Constants.INSTANCE.New_FilteredList(), tableSettings, addNewGrid);
            }
        });
        super.init((AbstractListPresenter)presenter, new GridGlobalPreferences(DATASET_TASK_LIST_PREFIX, initColumns, bannedColumns), button);
    }

    public void initSelectionModel() {
        final ExtendedPagedTable extendedPagedTable = this.getListGrid();
        this.selectedStyles = new RowStyles<TaskSummary>(){

            public String getStyleNames(TaskSummary row, int rowIndex) {
                if (rowIndex == DataSetTasksListGridViewImpl.this.selectedRow) {
                    return CommonResources.INSTANCE.css().selected();
                }
                if (row.getStatus().equals("InProgress") || row.getStatus().equals("Ready")) {
                    switch (row.getPriority()) {
                        case 5: {
                            return HumanTaskResources.INSTANCE.css().taskPriorityFive();
                        }
                        case 4: {
                            return HumanTaskResources.INSTANCE.css().taskPriorityFour();
                        }
                        case 3: {
                            return HumanTaskResources.INSTANCE.css().taskPriorityThree();
                        }
                        case 2: {
                            return HumanTaskResources.INSTANCE.css().taskPriorityTwo();
                        }
                        case 1: {
                            return HumanTaskResources.INSTANCE.css().taskPriorityOne();
                        }
                    }
                    return "";
                }
                if (row.getStatus().equals("Completed")) {
                    return HumanTaskResources.INSTANCE.css().taskCompleted();
                }
                return null;
            }
        };
        extendedPagedTable.setEmptyTableCaption(this.constants.No_Tasks_Found());
        this.selectionModel = new NoSelectionModel();
        this.selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                boolean close = false;
                if (DataSetTasksListGridViewImpl.this.selectedRow == -1) {
                    DataSetTasksListGridViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.setRowStyles(DataSetTasksListGridViewImpl.this.selectedStyles);
                    extendedPagedTable.redraw();
                } else if (extendedPagedTable.getKeyboardSelectedRow() != DataSetTasksListGridViewImpl.this.selectedRow) {
                    extendedPagedTable.setRowStyles(DataSetTasksListGridViewImpl.this.selectedStyles);
                    DataSetTasksListGridViewImpl.this.selectedRow = extendedPagedTable.getKeyboardSelectedRow();
                    extendedPagedTable.redraw();
                } else {
                    close = true;
                }
                DataSetTasksListGridViewImpl.this.selectedItem = (GenericSummary)DataSetTasksListGridViewImpl.this.selectionModel.getLastSelectedObject();
                ((AbstractTasksListGridPresenter)DataSetTasksListGridViewImpl.this.presenter).selectTask((TaskSummary)DataSetTasksListGridViewImpl.this.selectedItem, close);
            }
        });
        this.noActionColumnManager = DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new DefaultSelectionEventManager.EventTranslator<TaskSummary>(){

            public boolean clearCurrentSelection(CellPreviewEvent<TaskSummary> event) {
                return false;
            }

            public DefaultSelectionEventManager.SelectAction translateSelectionEvent(CellPreviewEvent<TaskSummary> event) {
                NativeEvent nativeEvent = event.getNativeEvent();
                if ("click".equals(nativeEvent.getType()) && extendedPagedTable.getColumnIndex(DataSetTasksListGridViewImpl.this.actionsColumn) == event.getColumn()) {
                    return DefaultSelectionEventManager.SelectAction.IGNORE;
                }
                return DefaultSelectionEventManager.SelectAction.DEFAULT;
            }
        });
        extendedPagedTable.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.noActionColumnManager);
        extendedPagedTable.setRowStyles(this.selectedStyles);
    }

    public void initColumns(ExtendedPagedTable extendedPagedTable) {
        this.initCellPreview(extendedPagedTable);
        Column taskIdColumn = this.initTaskIdColumn();
        Column taskNameColumn = this.initTaskNameColumn();
        Column descriptionColumn = this.initTaskDescriptionColumn();
        Column processIdColumn = this.initProcessIdColumn();
        Column processInstanceIdColumn = this.initProcessInstanceIdColumn();
        Column taskPriorityColumn = this.initTaskPriorityColumn();
        Column statusColumn = this.initTaskStatusColumn();
        Column createdOnDateColumn = this.initTaskCreatedOnColumn();
        Column dueDateColumn = this.initTaskDueColumn();
        this.actionsColumn = this.initActionsColumn();
        ArrayList<ColumnMeta<TaskSummary>> columnMetas = new ArrayList<ColumnMeta<TaskSummary>>();
        columnMetas.add(new ColumnMeta(taskIdColumn, this.constants.Id()));
        columnMetas.add(new ColumnMeta(taskNameColumn, this.constants.Task()));
        columnMetas.add(new ColumnMeta(descriptionColumn, this.constants.Description()));
        columnMetas.add(new ColumnMeta(processIdColumn, this.constants.Process_Name()));
        columnMetas.add(new ColumnMeta(processInstanceIdColumn, this.constants.Process_Id()));
        columnMetas.add(new ColumnMeta(taskPriorityColumn, this.constants.Priority()));
        columnMetas.add(new ColumnMeta(statusColumn, this.constants.Status()));
        columnMetas.add(new ColumnMeta(createdOnDateColumn, this.constants.Created_On()));
        columnMetas.add(new ColumnMeta(dueDateColumn, this.constants.Due_On()));
        columnMetas.add(new ColumnMeta(this.actionsColumn, this.constants.Actions()));
        List columPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        for (GridColumnPreference colPref : columPreferenceList) {
            if (this.isColumnAdded(columnMetas, colPref.getName())) continue;
            Column genericColumn = this.initGenericColumn(colPref.getName());
            genericColumn.setSortable(false);
            columnMetas.add((ColumnMeta<TaskSummary>)new ColumnMeta(genericColumn, colPref.getName(), true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    private void initCellPreview(final ExtendedPagedTable extendedPagedTable) {
        extendedPagedTable.addCellPreviewHandler((CellPreviewEvent.Handler)new CellPreviewEvent.Handler<TaskSummary>(){

            public void onCellPreview(CellPreviewEvent<TaskSummary> event) {
                if ("mouseover".equalsIgnoreCase(event.getNativeEvent().getType())) {
                    DataSetTasksListGridViewImpl.this.onMouseOverGrid(extendedPagedTable, (CellPreviewEvent<TaskSummary>)event);
                }
            }
        });
    }

    private void onMouseOverGrid(ExtendedPagedTable extendedPagedTable, CellPreviewEvent<TaskSummary> event) {
        TaskSummary task = (TaskSummary)event.getValue();
        if (task.getDescription() != null) {
            extendedPagedTable.setTooltip(extendedPagedTable.getKeyboardSelectedRow(), event.getColumn(), task.getDescription());
        }
    }

    private Column initTaskIdColumn() {
        Column<TaskSummary, Number> taskIdColumn = new Column<TaskSummary, Number>((Cell)new NumberCell()){

            public Number getValue(TaskSummary object) {
                return object.getTaskId();
            }
        };
        taskIdColumn.setSortable(true);
        taskIdColumn.setDataStoreName("taskId");
        return taskIdColumn;
    }

    private Column initTaskNameColumn() {
        Column<TaskSummary, String> taskNameColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getTaskName();
            }
        };
        taskNameColumn.setSortable(true);
        taskNameColumn.setDataStoreName("name");
        return taskNameColumn;
    }

    private Column initTaskDescriptionColumn() {
        Column<TaskSummary, String> descriptionColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getDescription();
            }
        };
        descriptionColumn.setSortable(true);
        descriptionColumn.setDataStoreName("description");
        return descriptionColumn;
    }

    private Column initTaskPriorityColumn() {
        Column<TaskSummary, Number> taskPriorityColumn = new Column<TaskSummary, Number>((Cell)new NumberCell()){

            public Number getValue(TaskSummary object) {
                return object.getPriority();
            }
        };
        taskPriorityColumn.setSortable(true);
        taskPriorityColumn.setDataStoreName("priority");
        return taskPriorityColumn;
    }

    private Column initTaskStatusColumn() {
        Column<TaskSummary, String> statusColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getStatus();
            }
        };
        statusColumn.setSortable(true);
        statusColumn.setDataStoreName("status");
        return statusColumn;
    }

    private Column initTaskCreatedOnColumn() {
        Column<TaskSummary, String> createdOnDateColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return DateUtils.getDateTimeStr((Date)object.getCreatedOn());
            }
        };
        createdOnDateColumn.setSortable(true);
        createdOnDateColumn.setDataStoreName("createdOn");
        return createdOnDateColumn;
    }

    private Column initTaskDueColumn() {
        Column<TaskSummary, String> dueDateColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return DateUtils.getDateTimeStr((Date)object.getExpirationTime());
            }
        };
        dueDateColumn.setSortable(true);
        dueDateColumn.setDataStoreName("dueDate");
        return dueDateColumn;
    }

    private Column initProcessIdColumn() {
        Column<TaskSummary, String> taskProcessIdColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getProcessId();
            }
        };
        taskProcessIdColumn.setSortable(true);
        taskProcessIdColumn.setDataStoreName("processId");
        return taskProcessIdColumn;
    }

    private Column initProcessInstanceIdColumn() {
        Column<TaskSummary, Number> taskProcessInstanceIdColumn = new Column<TaskSummary, Number>((Cell)new NumberCell()){

            public Number getValue(TaskSummary object) {
                return object.getProcessInstanceId();
            }
        };
        taskProcessInstanceIdColumn.setSortable(true);
        taskProcessInstanceIdColumn.setDataStoreName("processInstanceId");
        return taskProcessInstanceIdColumn;
    }

    private Column initActionsColumn() {
        LinkedList<ButtonActionCell> cells = new LinkedList<ButtonActionCell>();
        cells.add(new ClaimActionHasCell(this.constants.Claim(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                ((AbstractTasksListGridPresenter)DataSetTasksListGridViewImpl.this.presenter).claimTask(task);
            }
        }));
        cells.add(new ReleaseActionHasCell(this.constants.Release(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                ((AbstractTasksListGridPresenter)DataSetTasksListGridViewImpl.this.presenter).releaseTask(task);
            }
        }));
        cells.add(new CompleteActionHasCell(this.constants.Open(), new ActionCell.Delegate<TaskSummary>(){

            public void execute(TaskSummary task) {
                DataSetTasksListGridViewImpl.this.selectedRow = -1;
                ((AbstractTasksListGridPresenter)DataSetTasksListGridViewImpl.this.presenter).selectTask(task, false);
            }
        }));
        CompositeCell cell = new CompositeCell(cells);
        Column<TaskSummary, TaskSummary> actionsColumn = new Column<TaskSummary, TaskSummary>((Cell)cell){

            public TaskSummary getValue(TaskSummary object) {
                return object;
            }
        };
        actionsColumn.setDataStoreName(COL_ID_ACTIONS);
        return actionsColumn;
    }

    public void initDefaultFilters(GridGlobalPreferences preferences, Button createTabButton) {
        ((AbstractTasksListGridPresenter)this.presenter).setAddingDefaultFilters(true);
        List states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ACTIVE);
        this.initOwnTabFilter(preferences, "DataSetTaskListGrid_0", Constants.INSTANCE.Active(), Constants.INSTANCE.FilterActive(), states);
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.PERSONAL);
        this.initPersonalTabFilter(preferences, "DataSetTaskListGrid_1", Constants.INSTANCE.Personal(), Constants.INSTANCE.FilterPersonal(), states);
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.GROUP);
        this.initGroupTabFilter(preferences, "DataSetTaskListGrid_2", Constants.INSTANCE.Group(), Constants.INSTANCE.FilterGroup(), states);
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ALL);
        this.initOwnTabFilter(preferences, "DataSetTaskListGrid_3", Constants.INSTANCE.All(), Constants.INSTANCE.FilterAll(), states);
        states = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ADMIN);
        this.initAdminTabFilter(preferences, "DataSetTaskListGrid_4", Constants.INSTANCE.Task_Admin(), Constants.INSTANCE.FilterTaskAdmin(), states);
        this.filterPagedTable.addAddTableButton(createTabButton);
        this.selectFirstTabAndEnableQueries("DataSetTaskListGrid_0");
    }

    private void initGroupTabFilter(GridGlobalPreferences preferences, String key, String tabName, String tabDesc, List<String> states) {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasksWithUser");
        ArrayList<String> names = new ArrayList<String>(states);
        builder.filter("status", new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
        builder.filter("actualOwner", new ColumnFilter[]{FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"")), FilterFactory.isNull()})});
        builder.group("taskId");
        this.addCommonColumnSettings(builder);
        this.initFilterTab(builder, key, tabName, tabDesc, preferences);
    }

    private void initAdminTabFilter(GridGlobalPreferences preferences, String key, String tabName, String tabDesc, List<String> states) {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasksWithAdmin");
        ArrayList<String> names = new ArrayList<String>(states);
        builder.filter("status", new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
        builder.group("taskId");
        this.addCommonColumnSettings(builder);
        this.initFilterTab(builder, key, tabName, tabDesc, preferences);
    }

    private void initPersonalTabFilter(GridGlobalPreferences preferences, String key, String tabName, String tabDesc, List<String> states) {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasks");
        ArrayList<String> names = new ArrayList<String>(states);
        builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
        builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"actualOwner", (Comparable)((Object)this.identity.getIdentifier()))});
        this.addCommonColumnSettings(builder);
        this.initFilterTab(builder, key, tabName, tabDesc, preferences);
    }

    private void initOwnTabFilter(GridGlobalPreferences preferences, String key, String tabName, String tabDesc, List<String> states) {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasksWithUser");
        ArrayList<String> names = new ArrayList<String>(states);
        builder.filter("status", new ColumnFilter[]{FilterFactory.equalsTo((String)"status", names)});
        builder.group("taskId");
        this.addCommonColumnSettings(builder);
        this.initFilterTab(builder, key, tabName, tabDesc, preferences);
    }

    private void addCommonColumnSettings(FilterSettingsBuilderHelper builder) {
        builder.setColumn("activationTime", this.constants.ActivationTime(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("actualOwner", this.constants.Actual_Owner());
        builder.setColumn("createdBy", this.constants.CreatedBy());
        builder.setColumn("createdOn", this.constants.Created_On(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("deploymentId", this.constants.DeploymentId());
        builder.setColumn("description", this.constants.Description());
        builder.setColumn("dueDate", this.constants.DueDate(), DateUtils.getDateTimeFormatMask());
        builder.setColumn("name", this.constants.Task());
        builder.setColumn("parentId", this.constants.ParentId());
        builder.setColumn("priority", this.constants.Priority());
        builder.setColumn("processId", this.constants.Process_Id());
        builder.setColumn("processInstanceId", this.constants.Process_Instance_Id());
        builder.setColumn("processSessionId", this.constants.ProcessSessionId());
        builder.setColumn("status", this.constants.Status());
        builder.setColumn("taskId", this.constants.Id());
        builder.setColumn("workItemId", this.constants.WorkItemId());
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("createdOn", SortOrder.DESCENDING);
    }

    private void initFilterTab(FilterSettingsBuilderHelper builder, final String key, String tabName, String tabDesc, GridGlobalPreferences preferences) {
        ExtendedPagedTable extendedPagedTable;
        FilterSettings tableSettings = builder.buildSettings();
        tableSettings.setKey(key);
        tableSettings.setTableName(tabName);
        tableSettings.setTableDescription(tabDesc);
        HashMap<String, String> tabSettingsValues = new HashMap<String, String>();
        tabSettingsValues.put(FILTER_TABLE_SETTINGS, this.dataSetEditorManager.getTableSettingsToStr(tableSettings));
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, tableSettings.getTableName());
        tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, tableSettings.getTableDescription());
        this.filterPagedTable.saveNewTabSettings(key, tabSettingsValues);
        this.currentListGrid = extendedPagedTable = this.createGridInstance(new GridGlobalPreferences(key, preferences.getInitialColumns(), preferences.getBannedColumns()), key);
        extendedPagedTable.setDataProvider((AbstractDataProvider)((AbstractTasksListGridPresenter)this.presenter).getDataProvider());
        this.filterPagedTable.addTab((PagedTable)extendedPagedTable, key, new Command(){

            public void execute() {
                DataSetTasksListGridViewImpl.this.currentListGrid = extendedPagedTable;
                DataSetTasksListGridViewImpl.this.applyFilterOnPresenter(key);
            }
        });
    }

    public void applyFilterOnPresenter(HashMap<String, Object> params) {
        String tableSettingsJSON = (String)params.get(FILTER_TABLE_SETTINGS);
        FilterSettings tableSettings = this.dataSetEditorManager.getStrToTableSettings(tableSettingsJSON);
        ((AbstractTasksListGridPresenter)this.presenter).filterGrid(tableSettings);
    }

    @Override
    public void applyFilterOnPresenter(String key) {
        this.initSelectionModel();
        this.applyFilterOnPresenter(this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings(key));
    }

    public FilterSettings createTableSettingsPrototype() {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasksWithUser");
        builder.group("taskId");
        this.addCommonColumnSettings(builder);
        return builder.buildSettings();
    }

    @Override
    public int getRefreshValue() {
        return this.getMultiGridPreferencesStore().getRefreshInterval();
    }

    @Override
    public void saveRefreshValue(int newValue) {
        this.filterPagedTable.saveNewRefreshInterval(newValue);
    }

    private boolean isColumnAdded(List<ColumnMeta<TaskSummary>> columnMetas, String caption) {
        if (caption != null) {
            for (ColumnMeta<TaskSummary> colMet : columnMetas) {
                if (!caption.equals(colMet.getColumn().getDataStoreName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addDomainSpecifColumns(ExtendedPagedTable<TaskSummary> extendedPagedTable, Set<String> columns) {
        extendedPagedTable.storeColumnToPreferences();
        HashMap<String, String> modifiedCaptions = new HashMap<String, String>();
        ArrayList<ColumnMeta> existingExtraColumns = new ArrayList<ColumnMeta>();
        for (ColumnMeta cm : extendedPagedTable.getColumnMetaList()) {
            if (cm.isExtraColumn()) {
                existingExtraColumns.add(cm);
                continue;
            }
            if (!columns.contains(cm.getCaption())) continue;
            for (String c : columns) {
                if (!c.equals(cm.getCaption())) continue;
                modifiedCaptions.put(c, "Var_" + c);
            }
        }
        for (ColumnMeta colMet : existingExtraColumns) {
            if (!columns.contains(colMet.getCaption())) {
                extendedPagedTable.removeColumnMeta(colMet);
                continue;
            }
            columns.remove(colMet.getCaption());
        }
        ArrayList<ColumnMeta> columnMetas = new ArrayList<ColumnMeta>();
        String caption = "";
        Iterator<String> iterator = columns.iterator();
        while (iterator.hasNext()) {
            String c;
            caption = c = iterator.next();
            if (modifiedCaptions.get(c) != null) {
                caption = (String)modifiedCaptions.get(c);
            }
            Column genericColumn = this.initGenericColumn(c);
            genericColumn.setSortable(false);
            columnMetas.add(new ColumnMeta(genericColumn, caption, true, true));
        }
        extendedPagedTable.addColumns(columnMetas);
    }

    @Override
    public FilterSettings getVariablesTableSettings(String taskName) {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasksWithVariables");
        builder.filter(new ColumnFilter[]{FilterFactory.equalsTo((String)"TASKNAME", (Comparable)((Object)taskName))});
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("taskId", SortOrder.ASCENDING);
        FilterSettings varTableSettings = builder.buildSettings();
        varTableSettings.setTablePageSize(-1);
        return varTableSettings;
    }

    private Column initGenericColumn(final String key) {
        Column<TaskSummary, String> genericColumn = new Column<TaskSummary, String>((Cell)new TextCell()){

            public String getValue(TaskSummary object) {
                return object.getDomainDataValue(key);
            }
        };
        genericColumn.setSortable(true);
        genericColumn.setDataStoreName(key);
        return genericColumn;
    }

    public void resetDefaultFilterTitleAndDescription() {
        HashMap tabSettingsValues = null;
        tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings("DataSetTaskListGrid_0");
        if (tabSettingsValues != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, Constants.INSTANCE.Active());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, Constants.INSTANCE.FilterActive());
            this.filterPagedTable.saveTabSettings("DataSetTaskListGrid_0", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings("DataSetTaskListGrid_1")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, Constants.INSTANCE.Personal());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, Constants.INSTANCE.FilterPersonal());
            this.filterPagedTable.saveTabSettings("DataSetTaskListGrid_1", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings("DataSetTaskListGrid_2")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, Constants.INSTANCE.Group());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, Constants.INSTANCE.FilterGroup());
            this.filterPagedTable.saveTabSettings("DataSetTaskListGrid_2", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings("DataSetTaskListGrid_3")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, Constants.INSTANCE.All());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, Constants.INSTANCE.FilterAll());
            this.filterPagedTable.saveTabSettings("DataSetTaskListGrid_3", tabSettingsValues);
        }
        if ((tabSettingsValues = this.filterPagedTable.getMultiGridPreferencesStore().getGridSettings("DataSetTaskListGrid_4")) != null) {
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_NAME_PARAM, Constants.INSTANCE.Task_Admin());
            tabSettingsValues.put(NewTabFilterPopup.FILTER_TAB_DESC_PARAM, Constants.INSTANCE.FilterTaskAdmin());
            this.filterPagedTable.saveTabSettings("DataSetTaskListGrid_4", tabSettingsValues);
        }
    }

    @Override
    public void setSelectedTask(TaskSummary selectedTask) {
        this.selectionModel.setSelected((Object)selectedTask, true);
    }

    protected class ReleaseActionHasCell
    extends ButtonActionCell<TaskSummary> {
        public ReleaseActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getActualOwner() != null && value.getActualOwner().equals(DataSetTasksListGridViewImpl.this.identity.getIdentifier()) && (value.getStatus().equals("Reserved") || value.getStatus().equals("InProgress"))) {
                super.render(context, (Object)value, sb);
            }
        }
    }

    protected class ClaimActionHasCell
    extends ButtonActionCell<TaskSummary> {
        public ClaimActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getStatus().equals("Ready")) {
                super.render(context, (Object)value, sb);
            }
        }
    }

    protected class CompleteActionHasCell
    extends ButtonActionCell<TaskSummary> {
        public CompleteActionHasCell(String text, ActionCell.Delegate<TaskSummary> delegate) {
            super(text, delegate);
        }

        public void render(Cell.Context context, TaskSummary value, SafeHtmlBuilder sb) {
            if (value.getActualOwner() != null && value.getStatus().equals("InProgress")) {
                super.render(context, (Object)value, sb);
            }
        }
    }
}

