/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskdetailsmulti;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.jbpm.workbench.forms.client.display.api.HumanTaskFormDisplayProvider;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.ht.client.editors.taskdetails.TaskDetailsPresenter;
import org.jbpm.workbench.ht.client.editors.taskdetailsmulti.TaskDetailsMultiPresenter;
import org.jbpm.workbench.ht.client.editors.taskdetailsmulti.TaskDetailsMultiViewImpl;
import org.jbpm.workbench.ht.client.editors.taskform.TaskFormPresenter;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskDetailsMultiPresenterTest {
    private static final Long TASK_ID = 1L;
    private static final String TASK_NAME = "taskName";
    @Mock
    private TaskFormPresenter taskFormPresenter;
    @Mock
    TaskFormPresenter.TaskFormView taskFormViewMock;
    @Mock
    FormDisplayerView formDisplayerViewMock;
    @Mock
    private TaskDetailsMultiViewImpl view;
    @Mock
    private HumanTaskFormDisplayProvider taskFormDisplayProvider;
    @Mock
    private TaskDetailsPresenter taskDetailsPresenter;
    @Spy
    Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent = new EventSourceMock();
    @Spy
    Event<TaskSelectionEvent> taskSelectionEvent = new EventSourceMock();
    @InjectMocks
    private TaskDetailsMultiPresenter presenter;

    @Before
    public void setupMocks() {
        Mockito.when((Object)this.taskFormPresenter.getTaskFormView()).thenReturn((Object)this.taskFormViewMock);
        Mockito.when((Object)this.taskFormViewMock.getDisplayerView()).thenReturn((Object)this.formDisplayerViewMock);
        ((Event)Mockito.doNothing().when(this.changeTitleWidgetEvent)).fire(Mockito.any(ChangeTitleWidgetEvent.class));
        ((Event)Mockito.doNothing().when(this.taskSelectionEvent)).fire(Mockito.any(TaskSelectionEvent.class));
    }

    @Test
    public void isForLogRemainsEnabledAfterRefresh() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(null, null, TASK_ID, TASK_NAME, false, true));
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).displayOnlyLogTab();
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).setAdminTabVisible(false);
        Assert.assertFalse((boolean)this.presenter.isForAdmin());
        Assert.assertTrue((boolean)this.presenter.isForLog());
        this.presenter.onRefresh();
        Assert.assertFalse((boolean)this.presenter.isForAdmin());
        Assert.assertTrue((boolean)this.presenter.isForLog());
    }

    @Test
    public void isForLogRemainsDisabledAfterRefresh() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(null, null, TASK_ID, TASK_NAME, false, false));
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).displayAllTabs();
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).setAdminTabVisible(false);
        Assert.assertFalse((boolean)this.presenter.isForAdmin());
        Assert.assertFalse((boolean)this.presenter.isForLog());
        this.presenter.onRefresh();
        Assert.assertFalse((boolean)this.presenter.isForAdmin());
        Assert.assertFalse((boolean)this.presenter.isForLog());
    }
}

