/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskassignments;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.ht.client.editors.taskassignments.TaskAssignmentsPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskAssignmentSummary;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskAssignmentsPresenterTest {
    private static final String CURRENT_USER = "Jan";
    private static final String OTHER_USER = "OTHER_USER";
    @Mock
    private TaskAssignmentsPresenter.TaskAssignmentsView viewMock;
    @Mock
    private TaskService taskService;
    private Caller<TaskService> remoteTaskServiceCaller;
    private TaskAssignmentsPresenter presenter;

    @Before
    public void initMocks() {
        this.remoteTaskServiceCaller = new CallerMock((Object)this.taskService);
        Event taskRefreshed = (Event)Mockito.spy((Object)new EventSourceMock());
        ((Event)Mockito.doNothing().when((Object)taskRefreshed)).fire(Mockito.any(TaskRefreshedEvent.class));
        this.presenter = new TaskAssignmentsPresenter(this.viewMock, this.remoteTaskServiceCaller, taskRefreshed);
    }

    @Test
    public void delegationButtonDisabled_whenDelegationSuccessful() {
        long TASK_ID = 1L;
        TaskAssignmentSummary task = new TaskAssignmentSummary();
        task.setTaskId(Long.valueOf(1L));
        task.setStatus(TaskUtils.TASK_STATUS_IN_PROGRESS);
        task.setPotOwnersString(Arrays.asList(CURRENT_USER));
        task.setDelegationAllowed(true);
        Mockito.when((Object)this.taskService.getTaskAssignmentDetails(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Mockito.eq((long)1L)))).thenReturn((Object)task);
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(Long.valueOf(1L)));
        this.presenter.delegateTask(OTHER_USER);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock)).setDelegateButtonActive(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).enableDelegateButton(false);
    }

    @Test
    public void emptyDelegationUserOrGroup_notAccepted() {
        this.presenter.delegateTask("");
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock)).setHelpText(Constants.INSTANCE.DelegationUserInputRequired());
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.never())).delegate(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()), Matchers.anyString());
    }

    @Test
    public void nullDelegationUserOrGroup_notAccepted() {
        this.presenter.delegateTask(null);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock)).setHelpText(Constants.INSTANCE.DelegationUserInputRequired());
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.never())).delegate(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()), Matchers.anyString());
    }

    @Test
    public void delegationDisabled_whenCompletedTaskSelected() {
        long COMPLETED_TASK_ID = 1L;
        TaskAssignmentSummary task = new TaskAssignmentSummary();
        task.setTaskId(Long.valueOf(1L));
        task.setStatus(TaskUtils.TASK_STATUS_COMPLETED);
        task.setPotOwnersString(Arrays.asList(CURRENT_USER));
        Mockito.when((Object)this.taskService.getTaskAssignmentDetails(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Mockito.eq((long)1L)))).thenReturn((Object)task);
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(Long.valueOf(1L)));
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).enableDelegateButton(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).enableUserOrGroupInput(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).enableDelegateButton(true);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).enableUserOrGroupInput(true);
    }

    @Test
    public void delegationDisabled_whenTaskNotOwnedByCurrentUserSelected() {
        long TASK_OWNED_BY_SOMEONE_ELSE_ID = 2L;
        TaskAssignmentSummary task = new TaskAssignmentSummary();
        task.setTaskId(Long.valueOf(2L));
        task.setStatus(TaskUtils.TASK_STATUS_READY);
        task.setActualOwner(OTHER_USER);
        task.setPotOwnersString(Arrays.asList(OTHER_USER));
        task.setDelegationAllowed(false);
        Mockito.when((Object)this.taskService.getTaskAssignmentDetails(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Mockito.eq((long)2L)))).thenReturn((Object)task);
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(Long.valueOf(2L)));
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).enableDelegateButton(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).enableUserOrGroupInput(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).enableDelegateButton(true);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).enableUserOrGroupInput(true);
    }

    @Test
    public void delegationEnabled_whenTaskOwnedByCurrentUserSelected() {
        long TASK_OWNED_BY_CURRENT_USER = 3L;
        TaskAssignmentSummary task = new TaskAssignmentSummary();
        task.setTaskId(Long.valueOf(3L));
        task.setStatus(TaskUtils.TASK_STATUS_READY);
        task.setActualOwner(CURRENT_USER);
        task.setPotOwnersString(Arrays.asList(CURRENT_USER));
        task.setDelegationAllowed(true);
        Mockito.when((Object)this.taskService.getTaskAssignmentDetails(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Mockito.eq((long)3L)))).thenReturn((Object)task);
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(Long.valueOf(3L)));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.viewMock});
        ((TaskAssignmentsPresenter.TaskAssignmentsView)inOrder.verify((Object)this.viewMock)).enableDelegateButton(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)inOrder.verify((Object)this.viewMock)).enableUserOrGroupInput(false);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)inOrder.verify((Object)this.viewMock)).enableDelegateButton(true);
        ((TaskAssignmentsPresenter.TaskAssignmentsView)inOrder.verify((Object)this.viewMock)).enableUserOrGroupInput(true);
    }
}

