/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwt.cell.client.ActionCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.Element;
import com.google.gwt.view.client.AsyncDataProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.gwtbootstrap3.client.ui.Button;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.base.DataSetEditorManager;
import org.jbpm.workbench.df.client.list.base.DataSetQueryHelper;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListView;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.table.client.ColumnMeta;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mvp.Command;

public abstract class AbstractTaskListViewTest {
    public static final String TEST_USER_ID = "testUser";
    protected CallerMock<UserPreferencesService> callerMockUserPreferencesService;
    @Mock
    protected UserPreferencesService userPreferencesServiceMock;
    @Mock
    protected ExtendedPagedTable<TaskSummary> currentListGrid;
    @Mock
    protected GridPreferencesStore gridPreferencesStoreMock;
    @Mock
    protected MultiGridPreferencesStore multiGridPreferencesStoreMock;
    @Mock
    protected DataSetQueryHelper dataSetQueryHelperMock;
    @Mock
    protected FilterPagedTable filterPagedTableMock;
    @Mock
    protected Button mockButton;
    @Mock
    protected User identity;
    @Mock
    protected Cell.Context cellContext;
    @Mock
    protected Element cellParent;
    @Mock
    protected ActionCell.Delegate<TaskSummary> cellDelegate;
    @Mock
    protected DataSetEditorManager dataSetEditorManagerMock;
    @Spy
    protected FilterSettings filterSettings;

    public abstract AbstractTaskListView getView();

    public abstract AbstractTaskListPresenter getPresenter();

    public abstract int getExpectedDefaultTabFilterCount();

    @Before
    public void setupMocks() {
        Mockito.when((Object)this.getPresenter().getDataProvider()).thenReturn(Mockito.mock(AsyncDataProvider.class));
        Mockito.when((Object)this.getPresenter().createTableSettingsPrototype()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.getPresenter().createSearchTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.filterPagedTableMock.getMultiGridPreferencesStore()).thenReturn((Object)this.multiGridPreferencesStoreMock);
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)new GridPreferencesStore());
        this.callerMockUserPreferencesService = new CallerMock((Object)this.userPreferencesServiceMock);
        this.getView().setPreferencesService(this.callerMockUserPreferencesService);
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)TEST_USER_ID);
    }

    @Test
    public void testDataStoreNameIsSet() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                for (ColumnMeta columnMeta : columns) {
                    Assert.assertNotNull((Object)columnMeta.getColumn().getDataStoreName());
                }
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        this.getView().initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void initColumnsTest() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertTrue((columns.size() == 14 ? 1 : 0) != 0);
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        ArrayList columnPreferences = new ArrayList();
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStoreMock);
        Mockito.when((Object)this.gridPreferencesStoreMock.getColumnPreferences()).thenReturn(columnPreferences);
        this.getView().initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void initColumnsWithTaskVarColumnsTest() {
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertTrue((columns.size() == 17 ? 1 : 0) != 0);
                return null;
            }
        }).when(this.currentListGrid)).addColumns(Mockito.anyList());
        ArrayList<GridColumnPreference> columnPreferences = new ArrayList<GridColumnPreference>();
        columnPreferences.add(new GridColumnPreference("var1", Integer.valueOf(0), "40"));
        columnPreferences.add(new GridColumnPreference("var2", Integer.valueOf(1), "40"));
        columnPreferences.add(new GridColumnPreference("var3", Integer.valueOf(1), "40"));
        Mockito.when((Object)this.currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStoreMock);
        Mockito.when((Object)this.gridPreferencesStoreMock.getColumnPreferences()).thenReturn(columnPreferences);
        this.getView().initColumns(this.currentListGrid);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void initDefaultFiltersOwnTaskFilter() {
        AbstractTaskListPresenter presenter = this.getPresenter();
        this.getView().initDefaultFilters(new GridGlobalPreferences(), this.mockButton);
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)this.getExpectedDefaultTabFilterCount()))).addTab((PagedTable)Mockito.any(ExtendedPagedTable.class), Mockito.anyString(), (Command)Mockito.any(Command.class), Mockito.eq((boolean)false));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock)).addAddTableButton(this.mockButton);
        ((AbstractTaskListPresenter)Mockito.verify((Object)presenter)).setAddingDefaultFilters(true);
    }

    @Test
    public void addDomainSpecifColumnsTest() {
        HashSet<String> domainColumns = new HashSet<String>();
        domainColumns.add("var1");
        domainColumns.add("var2");
        domainColumns.add("var3");
        this.getView().addDomainSpecifColumns(this.currentListGrid, domainColumns);
        ArgumentCaptor argument = ArgumentCaptor.forClass(List.class);
        ((ExtendedPagedTable)Mockito.verify(this.currentListGrid)).addColumns((List)argument.capture());
        List columns = (List)argument.getValue();
        Assert.assertTrue((columns.size() == 3 ? 1 : 0) != 0);
        int i = 0;
        for (String domainColumn : domainColumns) {
            Assert.assertEquals((Object)((ColumnMeta)columns.get(i)).getCaption(), (Object)domainColumn);
            ++i;
        }
    }

    @Test
    public void setDefaultFilterTitleAndDescriptionTest() {
        this.getView().resetDefaultFilterTitleAndDescription();
        int filterCount = this.getExpectedDefaultTabFilterCount();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)filterCount))).getMultiGridPreferencesStore();
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)1))).saveTabSettings((String)Mockito.eq((Object)"base"), (HashMap)Mockito.any(HashMap.class));
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTableMock, (VerificationMode)Mockito.times((int)filterCount))).saveTabSettings(Mockito.anyString(), (HashMap)Mockito.any(HashMap.class));
    }

    @Test
    public void initialColumsTest() {
        AbstractTaskListView view = this.getView();
        view.init(this.getPresenter());
        List columnPreferences = view.getListGrid().getGridPreferencesStore().getColumnPreferences();
        Assert.assertEquals((Object)"name", (Object)((GridColumnPreference)columnPreferences.get(0)).getName());
        Assert.assertEquals((Object)"processId", (Object)((GridColumnPreference)columnPreferences.get(1)).getName());
        Assert.assertEquals((Object)"status", (Object)((GridColumnPreference)columnPreferences.get(2)).getName());
        Assert.assertEquals((Object)"createdOn", (Object)((GridColumnPreference)columnPreferences.get(3)).getName());
        Assert.assertEquals((Object)"actions", (Object)((GridColumnPreference)columnPreferences.get(4)).getName());
    }
}

