/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskcomments;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Date;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.workbench.ht.model.CommentSummary;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskCommentsPresenterTest {
    private static final Long TASK_ID = 1L;
    private static final Long COMMENT_ID = 1L;
    private CallerMock<TaskService> callerMock;
    @Mock
    private TaskService commentsServiceMock;
    @Mock
    private TaskCommentsPresenter.TaskCommentsView viewMock;
    private TaskCommentsPresenter presenter;

    @Before
    public void setupMocks() {
        this.callerMock = new CallerMock((Object)this.commentsServiceMock);
        this.presenter = new TaskCommentsPresenter(this.viewMock, this.callerMock);
    }

    @Test
    public void commentsUpdatedWhenTaskSelectedOrRefreshed() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        boolean isForLog = false;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, TASK_ID, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog), "description", new Date(), "Ready", "actualOwner", Integer.valueOf(2), Long.valueOf(1L), "processId");
        this.presenter.onTaskSelectionEvent(event);
        ((TaskService)Mockito.verify((Object)this.commentsServiceMock)).getTaskComments(serverTemplateId, containerId, TASK_ID);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock)).redrawDataGrid();
        this.presenter.onTaskRefreshedEvent(new TaskRefreshedEvent(TASK_ID.longValue()));
        ((TaskService)Mockito.verify((Object)this.commentsServiceMock, (VerificationMode)Mockito.times((int)2))).getTaskComments(serverTemplateId, containerId, TASK_ID);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).redrawDataGrid();
    }

    @Test
    public void emptyCommentNotAccepted() {
        this.presenter.addTaskComment("");
        ((TaskService)Mockito.verify((Object)this.commentsServiceMock, (VerificationMode)Mockito.never())).addTaskComment(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()), Matchers.anyString(), (Date)Matchers.any(Date.class));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock)).displayNotification("CommentCannotBeEmpty");
    }

    @Test
    public void commentInputClearedAfterCommetAdded() {
        String comment = "Working on it, man.";
        this.presenter.addTaskComment(comment);
        ((TaskService)Mockito.verify((Object)this.commentsServiceMock)).addTaskComment(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()), (String)Matchers.eq((Object)comment), (Date)Matchers.any(Date.class));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock)).clearCommentInput();
    }

    @Test
    public void removeCommentAdded() {
        this.presenter.removeTaskComment(COMMENT_ID.longValue());
        ((TaskService)Mockito.verify((Object)this.commentsServiceMock)).deleteTaskComment(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()), (Long)Matchers.eq((Object)COMMENT_ID));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock)).clearCommentInput();
        ((TaskService)Mockito.verify((Object)this.commentsServiceMock)).getTaskComments(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.viewMock)).redrawDataGrid();
    }

    @Test
    public void taskSelectionEventIsForLogTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        boolean isForLog = true;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog));
        CommentSummary comment1 = new CommentSummary(1L, "commentText", "ByTest", new Date());
        Mockito.when((Object)this.commentsServiceMock.getTaskComments((String)Matchers.eq((Object)serverTemplateId), (String)Matchers.eq((Object)containerId), (Long)Matchers.eq((Object)taskId))).thenReturn(Arrays.asList(comment1));
        this.presenter.onTaskSelectionEvent(event);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.commentsServiceMock});
    }

    @Test
    public void taskSelectionEventNotIsForLogTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        boolean isForLog = false;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog));
        CommentSummary comment1 = new CommentSummary(1L, "commentText", "ByTest", new Date());
        Mockito.when((Object)this.commentsServiceMock.getTaskComments((String)Matchers.eq((Object)serverTemplateId), (String)Matchers.eq((Object)containerId), (Long)Matchers.eq((Object)taskId))).thenReturn(Arrays.asList(comment1));
        this.presenter.onTaskSelectionEvent(event);
        ((TaskService)Mockito.verify((Object)this.commentsServiceMock)).getTaskComments(serverTemplateId, containerId, taskId);
    }
}

