/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwt.user.cellview.client.RowStyles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jbpm.workbench.common.client.list.AbstractMultiGridViewTest;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListView;
import org.jbpm.workbench.ht.client.resources.HumanTaskResources;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.util.TaskStatus;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

public abstract class AbstractTaskListViewTest
extends AbstractMultiGridViewTest<TaskSummary> {
    public abstract AbstractTaskListView getView();

    public abstract AbstractTaskListPresenter getPresenter();

    public List<String> getExpectedBannedColumns() {
        return Arrays.asList("name", "Actions");
    }

    public Integer getExpectedNumberOfColumns() {
        return 15;
    }

    @Test
    public void addDomainSpecifColumnsTest() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        HashSet<String> domainColumns = new HashSet<String>();
        domainColumns.add("var1");
        domainColumns.add("var2");
        domainColumns.add("var3");
        this.getView().addDomainSpecifColumns(currentListGrid, domainColumns);
        ArgumentCaptor argument = ArgumentCaptor.forClass(List.class);
        ((ListTable)Mockito.verify((Object)currentListGrid)).addColumns((List)argument.capture());
        List columns = (List)argument.getValue();
        Assert.assertTrue((columns.size() == 3 ? 1 : 0) != 0);
        int i = 0;
        for (String domainColumn : domainColumns) {
            Assert.assertEquals((Object)((ColumnMeta)columns.get(i)).getCaption(), (Object)domainColumn);
            ++i;
        }
    }

    @Test
    public void testStylesNotAppliedDependingOnPriority() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        this.getView().initSelectionModel(currentListGrid);
        ArgumentCaptor rowStylesApplied = ArgumentCaptor.forClass(RowStyles.class);
        ((ListTable)Mockito.verify((Object)currentListGrid)).setRowStyles((RowStyles)rowStylesApplied.capture());
        Assert.assertNull((Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskStatus.TASK_STATUS_READY.getIdentifier()).priority(Integer.valueOf(1)).build(), 1));
        Assert.assertNull((Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskStatus.TASK_STATUS_READY.getIdentifier()).priority(Integer.valueOf(3)).build(), 1));
        Assert.assertNull((Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskStatus.TASK_STATUS_READY.getIdentifier()).priority(Integer.valueOf(10)).build(), 1));
        Assert.assertEquals((Object)HumanTaskResources.INSTANCE.css().taskCompleted(), (Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskStatus.TASK_STATUS_COMPLETED.getIdentifier()).priority(Integer.valueOf(10)).build(), 1));
    }

    public abstract List<String> getExpectedInitialColumns();
}

