/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskcomments;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.CommentSummary;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.uberfire.client.mvp.UberView;

@Dependent
public class TaskCommentsPresenter {
    private final TaskCommentsView view;
    private final Caller<TaskService> taskService;
    private final ListDataProvider<CommentSummary> dataProvider = new ListDataProvider();
    private Constants constants = Constants.INSTANCE;
    private long currentTaskId = 0L;
    private String serverTemplateId;
    private String containerId;

    @Inject
    public TaskCommentsPresenter(TaskCommentsView view, Caller<TaskService> taskService) {
        this.view = view;
        this.taskService = taskService;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public ListDataProvider<CommentSummary> getDataProvider() {
        return this.dataProvider;
    }

    public void refreshComments() {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<List<CommentSummary>>(){

            public void callback(List<CommentSummary> comments) {
                TaskCommentsPresenter.this.dataProvider.getList().clear();
                TaskCommentsPresenter.this.dataProvider.getList().addAll(comments);
                TaskCommentsPresenter.this.view.redrawDataGrid();
            }
        })).getTaskComments(this.serverTemplateId, this.containerId, Long.valueOf(this.currentTaskId));
    }

    public void addTaskComment(String text) {
        if ("".equals(text.trim())) {
            this.view.displayNotification(this.constants.CommentCannotBeEmpty());
        } else {
            this.addTaskComment(text, new Date());
        }
    }

    private void addTaskComment(String text, Date addedOn) {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                TaskCommentsPresenter.this.refreshComments();
                TaskCommentsPresenter.this.view.clearCommentInput();
            }
        })).addTaskComment(this.serverTemplateId, this.containerId, Long.valueOf(this.currentTaskId), text, addedOn);
    }

    public void removeTaskComment(long commentId) {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                TaskCommentsPresenter.this.refreshComments();
                TaskCommentsPresenter.this.view.clearCommentInput();
                TaskCommentsPresenter.this.view.displayNotification(TaskCommentsPresenter.this.constants.CommentDeleted());
            }
        })).deleteTaskComment(this.serverTemplateId, this.containerId, Long.valueOf(this.currentTaskId), Long.valueOf(commentId));
    }

    public void addDataDisplay(HasData<CommentSummary> display) {
        this.dataProvider.addDataDisplay(display);
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        if (!event.isForLog().booleanValue()) {
            this.currentTaskId = event.getTaskId();
            this.serverTemplateId = event.getServerTemplateId();
            this.containerId = event.getContainerId();
            this.refreshComments();
        }
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.currentTaskId == event.getTaskId()) {
            this.refreshComments();
        }
    }

    public static interface TaskCommentsView
    extends UberView<TaskCommentsPresenter> {
        public void clearCommentInput();

        public void redrawDataGrid();

        public void displayNotification(String var1);
    }
}

