/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskcomments;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Date;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenter;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenterTest;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.workbench.ht.model.CommentSummary;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskCommentsPresenterTest
extends AbstractTaskPresenterTest {
    private static final Long TASK_ID = 1L;
    private static final Long COMMENT_ID = 1L;
    private CallerMock<TaskService> callerMock;
    @Mock
    private TaskService commentsService;
    @Mock
    private TaskCommentsPresenter.TaskCommentsView view;
    @Mock
    private User identity;
    private TaskCommentsPresenter presenter;

    @Override
    public AbstractTaskPresenter getPresenter() {
        return this.presenter;
    }

    @Before
    public void setupMocks() {
        this.callerMock = new CallerMock((Object)this.commentsService);
        this.presenter = new TaskCommentsPresenter(this.view, this.callerMock, this.identity);
    }

    @Test
    public void commentsUpdatedWhenTaskSelectedOrRefreshed() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        boolean isForLog = false;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, TASK_ID, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog), "description", new Date(), "Ready", "actualOwner", Integer.valueOf(2), Long.valueOf(1L), "processId");
        this.presenter.onTaskSelectionEvent(event);
        ((TaskService)Mockito.verify((Object)this.commentsService)).getTaskComments(serverTemplateId, containerId, TASK_ID);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.view)).redrawDataGrid();
        this.presenter.onTaskRefreshedEvent(new TaskRefreshedEvent(serverTemplateId, containerId, TASK_ID));
        ((TaskService)Mockito.verify((Object)this.commentsService, (VerificationMode)Mockito.times((int)2))).getTaskComments(serverTemplateId, containerId, TASK_ID);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).redrawDataGrid();
    }

    @Test
    public void emptyCommentNotAccepted() {
        TaskSelectionEvent event = new TaskSelectionEvent("serverTemplateId", "containerId", Long.valueOf(1L), "task", Boolean.valueOf(true), Boolean.valueOf(false));
        this.presenter.onTaskSelectionEvent(event);
        this.presenter.addTaskComment("");
        ((TaskService)Mockito.verify((Object)this.commentsService, (VerificationMode)Mockito.never())).addTaskComment(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()), Matchers.anyString(), (Date)Matchers.any(Date.class));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.view)).displayNotification("CommentCannotBeEmpty");
    }

    @Test
    public void commentInputClearedAfterCommentAdded() {
        String comment = "Working on it, man.";
        this.presenter.addTaskComment(comment);
        ((TaskService)Mockito.verify((Object)this.commentsService)).addTaskComment(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()), (String)Matchers.eq((Object)comment), (Date)Matchers.any(Date.class));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.view)).clearCommentInput();
    }

    @Test
    public void removeCommentAdded() {
        this.presenter.removeTaskComment(COMMENT_ID.longValue());
        ((TaskService)Mockito.verify((Object)this.commentsService)).deleteTaskComment(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()), (Long)Matchers.eq((Object)COMMENT_ID));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.view)).clearCommentInput();
        ((TaskService)Mockito.verify((Object)this.commentsService)).getTaskComments(Matchers.anyString(), Matchers.anyString(), Long.valueOf(Matchers.anyLong()));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.view)).redrawDataGrid();
    }

    @Test
    public void taskSelectionEventIsForLogTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        boolean isForLog = true;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog));
        CommentSummary comment1 = new CommentSummary(Long.valueOf(1L), "commentText", "ByTest", new Date());
        Mockito.when((Object)this.commentsService.getTaskComments((String)Matchers.eq((Object)serverTemplateId), (String)Matchers.eq((Object)containerId), (Long)Matchers.eq((Object)taskId))).thenReturn(Arrays.asList(comment1));
        this.presenter.onTaskSelectionEvent(event);
        ((TaskService)Mockito.verify((Object)this.commentsService)).getTaskComments(serverTemplateId, containerId, taskId);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.view)).newCommentsEnabled(Boolean.valueOf(false));
    }

    @Test
    public void taskSelectionEventNotIsForLogTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        boolean isForLog = false;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog));
        CommentSummary comment1 = new CommentSummary(Long.valueOf(1L), "commentText", "ByTest", new Date());
        Mockito.when((Object)this.commentsService.getTaskComments((String)Matchers.eq((Object)serverTemplateId), (String)Matchers.eq((Object)containerId), (Long)Matchers.eq((Object)taskId))).thenReturn(Arrays.asList(comment1));
        this.presenter.onTaskSelectionEvent(event);
        ((TaskService)Mockito.verify((Object)this.commentsService)).getTaskComments(serverTemplateId, containerId, taskId);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.view)).newCommentsEnabled(Boolean.valueOf(true));
    }

    @Test
    public void testDeleteCommentConditionForLog() {
        TaskSelectionEvent event = new TaskSelectionEvent("serverTemplateId", "containerId", Long.valueOf(1L), "task", Boolean.valueOf(true), Boolean.valueOf(true));
        this.presenter.onTaskSelectionEvent(event);
        String addedBy = "user1";
        CommentSummary comment1 = new CommentSummary(Long.valueOf(1L), "commentText", "user1", new Date());
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user1");
        Assert.assertFalse((boolean)this.presenter.getDeleteCondition().test(comment1));
    }

    @Test
    public void testDeleteCommentConditionForAdmin() {
        TaskSelectionEvent event = new TaskSelectionEvent("serverTemplateId", "containerId", Long.valueOf(1L), "task", Boolean.valueOf(true), Boolean.valueOf(false));
        this.presenter.onTaskSelectionEvent(event);
        String addedBy = "user1";
        CommentSummary comment1 = new CommentSummary(Long.valueOf(1L), "commentText", "user1", new Date());
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user2");
        Assert.assertTrue((boolean)this.presenter.getDeleteCondition().test(comment1));
    }

    @Test
    public void testDeleteCommentConditionForUser() {
        TaskSelectionEvent event = new TaskSelectionEvent("serverTemplateId", "containerId", Long.valueOf(1L), "task", Boolean.valueOf(false), Boolean.valueOf(false));
        this.presenter.onTaskSelectionEvent(event);
        String addedBy = "user1";
        CommentSummary comment1 = new CommentSummary(Long.valueOf(1L), "commentText", "user1", new Date());
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user1", (Object[])new String[]{"user2"});
        Assert.assertTrue((boolean)this.presenter.getDeleteCondition().test(comment1));
        Assert.assertFalse((boolean)this.presenter.getDeleteCondition().test(comment1));
    }
}

