/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.df.client.events.SavedFilterAddedEvent;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.workbench.df.client.filter.FilterSettingsJSONMarshaller;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListFilterSettingsManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

public abstract class AbstractTaskListFilterSettingsManagerTest {
    @Mock
    TranslationService translationServiceMock;
    @Mock
    protected User identity;
    @Mock
    protected FilterSettingsJSONMarshaller marshaller;
    @Spy
    protected Event<SavedFilterAddedEvent> filterSavedEvent = new EventSourceMock();
    @Mock
    protected UserPreferencesService preferencesService;
    protected CallerMock<UserPreferencesService> userPreferencesServiceCallerMock;

    public abstract AbstractTaskListFilterSettingsManager getFilterSettingsManager();

    public abstract String getDataSetId();

    @Before
    public void setupMocks() {
        this.userPreferencesServiceCallerMock = new CallerMock((Object)this.preferencesService);
        this.getFilterSettingsManager().setPreferencesService(this.userPreferencesServiceCallerMock);
        ((Event)Mockito.doNothing().when(this.filterSavedEvent)).fire(Mockito.any(SavedFilterAddedEvent.class));
    }

    @Test
    public void testIsNullTableSettingsPrototype() {
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user");
        FilterSettings filterSettings = this.getFilterSettingsManager().createFilterSettingsPrototype();
        List ops = filterSettings.getDataSetLookup().getOperationList();
        for (DataSetOp op : ops) {
            if (!op.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List columnFilters = ((DataSetFilter)op).getColumnFilterList();
            for (ColumnFilter columnFilter : columnFilters) {
                Assert.assertTrue((boolean)columnFilter.toString().contains("actualOwner is_null"));
            }
        }
    }

    @Test
    public void getVariablesTableSettingsTest() {
        FilterSettings filterSettings = this.getFilterSettingsManager().getVariablesFilterSettings("Test");
        List ops = filterSettings.getDataSetLookup().getOperationList();
        for (DataSetOp op : ops) {
            if (!op.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List columnFilters = ((DataSetFilter)op).getColumnFilterList();
            for (ColumnFilter columnFilter : columnFilters) {
                Assert.assertTrue((boolean)columnFilter.toString().contains("TASKNAME = Test"));
            }
        }
    }

    @Test
    public void testDataSetName() {
        Assert.assertEquals((Object)this.getDataSetId(), (Object)this.getFilterSettingsManager().createFilterSettingsPrototype().getDataSetLookup().getDataSetUUID());
    }

    @Test
    public void testStatusSettingsColumns() {
        FilterSettingsBuilderHelper helper = FilterSettingsBuilderHelper.init();
        this.getFilterSettingsManager().commonColumnSettings().accept(helper);
        FilterSettings filterSettings = helper.buildSettings();
        Assert.assertEquals((long)this.getDataSetExpectedColumns().size(), (long)filterSettings.getColumnSettingsList().size());
        this.getDataSetExpectedColumns().forEach(c -> Assert.assertNotNull((Object)filterSettings.getColumnSettings(c)));
    }

    protected List<String> getDataSetExpectedColumns() {
        return Arrays.asList("activationTime", "actualOwner", "createdBy", "createdOn", "deploymentId", "description", "dueDate", "name", "parentId", "priority", "processId", "processInstanceId", "processSessionId", "status", "taskId", "workItemId", "lastModificationDate", "correlationKey", "processInstanceDescription");
    }
}

