/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.GenericErrorSummaryCountCell;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListView;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListViewTest;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskAdminListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskAdminListViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskAdminListViewImplTest
extends AbstractTaskListViewTest {
    @InjectMocks
    @Spy
    private TaskAdminListViewImpl view;
    @Mock
    private TaskAdminListPresenter presenter;
    @Spy
    private GenericErrorSummaryCountCell cellMock;
    @Mock
    private ManagedInstance<GenericErrorSummaryCountCell> popoverCellInstance;

    @Override
    public AbstractTaskListView getView() {
        return this.view;
    }

    @Override
    public AbstractTaskListPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    public List<String> getExpectedInitialColumns() {
        return Arrays.asList("name", "processId", "status", "actualOwner", "createdOn", "errorCount", "Actions");
    }

    @Override
    public Integer getExpectedNumberOfColumns() {
        return 16;
    }

    @Before
    public void setupMocks() {
        super.setupMocks();
        Mockito.when((Object)this.popoverCellInstance.get()).thenReturn((Object)this.cellMock);
    }

    @Test
    public void initColumnsWithTaskVarColumnsTest() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        ((ListTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertEquals((long)19L, (long)columns.size());
                return null;
            }
        }).when((Object)currentListGrid)).addColumns(Matchers.anyList());
        ArrayList<GridColumnPreference> columnPreferences = new ArrayList<GridColumnPreference>();
        columnPreferences.add(new GridColumnPreference("var1", Integer.valueOf(0), "40"));
        columnPreferences.add(new GridColumnPreference("var2", Integer.valueOf(1), "40"));
        columnPreferences.add(new GridColumnPreference("var3", Integer.valueOf(1), "40"));
        Mockito.when((Object)currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStore);
        Mockito.when((Object)this.gridPreferencesStore.getColumnPreferences()).thenReturn(columnPreferences);
        this.getView().initColumns(currentListGrid);
        ((ListTable)Mockito.verify((Object)currentListGrid)).addColumns(Matchers.anyList());
    }
}

