/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskcomments;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import java.util.Date;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.CommentSummary;
import org.jbpm.workbench.ht.model.events.AbstractTaskEvent;
import org.jbpm.workbench.ht.model.events.TaskCompletedEvent;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.uberfire.client.mvp.UberView;

@Dependent
public class TaskCommentsPresenter
extends AbstractTaskPresenter {
    private final TaskCommentsView view;
    private final Caller<TaskService> taskService;
    private final ListDataProvider<CommentSummary> dataProvider = new ListDataProvider();
    private Constants constants = Constants.INSTANCE;
    private User identity;
    private boolean forLog = false;
    private boolean forAdmin = false;

    @Inject
    public TaskCommentsPresenter(TaskCommentsView view, Caller<TaskService> taskService, User identity) {
        this.view = view;
        this.taskService = taskService;
        this.identity = identity;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public ListDataProvider<CommentSummary> getDataProvider() {
        return this.dataProvider;
    }

    public void refreshComments() {
        ((TaskService)this.taskService.call(comments -> {
            this.dataProvider.getList().clear();
            this.dataProvider.getList().addAll(comments);
            this.view.redrawDataGrid();
        }, (message, throwable) -> {
            if (throwable.getMessage().contains("cannot find container")) {
                this.view.setErrorMessage(this.constants.TaskCommentsNotAvailable(this.getContainerId()));
                return false;
            }
            return true;
        })).getTaskComments(this.getServerTemplateId(), this.getContainerId(), this.getTaskId());
    }

    public void addTaskComment(String text) {
        if (this.forLog) {
            return;
        }
        if ("".equals(text.trim())) {
            this.view.displayNotification(this.constants.CommentCannotBeEmpty());
        } else {
            this.addTaskComment(text, new Date());
        }
    }

    private void addTaskComment(String text, Date addedOn) {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                TaskCommentsPresenter.this.refreshComments();
                TaskCommentsPresenter.this.view.clearCommentInput();
            }
        })).addTaskComment(this.getServerTemplateId(), this.getContainerId(), this.getTaskId(), text, addedOn);
    }

    public void removeTaskComment(long commentId) {
        ((TaskService)this.taskService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void response) {
                TaskCommentsPresenter.this.refreshComments();
                TaskCommentsPresenter.this.view.clearCommentInput();
                TaskCommentsPresenter.this.view.displayNotification(TaskCommentsPresenter.this.constants.CommentDeleted());
            }
        })).deleteTaskComment(this.getServerTemplateId(), this.getContainerId(), this.getTaskId(), Long.valueOf(commentId));
    }

    public void addDataDisplay(HasData<CommentSummary> display) {
        this.dataProvider.addDataDisplay(display);
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.setSelectedTask(event);
        this.forAdmin = event.isForAdmin();
        this.forLog = event.isForLog();
        this.view.newCommentsEnabled(!this.forLog);
        this.refreshComments();
    }

    public Predicate<CommentSummary> getDeleteCondition() {
        return c -> !this.forLog && (this.forAdmin || c.getAddedBy().equals(this.identity.getIdentifier()));
    }

    public void onTaskRefreshedEvent(@Observes TaskRefreshedEvent event) {
        if (this.isSameTaskFromEvent().test((AbstractTaskEvent)event)) {
            this.refreshComments();
        }
    }

    public void onTaskCompletedEvent(@Observes TaskCompletedEvent event) {
        if (this.isSameTaskFromEvent().test((AbstractTaskEvent)event) && !this.forLog) {
            this.forLog = true;
            this.view.newCommentsEnabled(false);
            this.refreshComments();
        }
    }

    public static interface TaskCommentsView
    extends UberView<TaskCommentsPresenter> {
        public void clearCommentInput();

        public void redrawDataGrid();

        public void displayNotification(String var1);

        public void newCommentsEnabled(Boolean var1);

        public void setErrorMessage(String var1);
    }
}

