/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwt.user.cellview.client.RowStyles;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jbpm.workbench.common.client.list.AbstractMultiGridViewTest;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListView;
import org.jbpm.workbench.ht.client.resources.HumanTaskResources;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.util.TaskStatus;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreferencesType;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

public abstract class AbstractTaskListViewTest
extends AbstractMultiGridViewTest<TaskSummary> {
    public abstract AbstractTaskListView getView();

    public abstract AbstractTaskListPresenter getPresenter();

    public List<String> getExpectedBannedColumns() {
        return Arrays.asList("name", "Actions");
    }

    public Integer getExpectedNumberOfColumns() {
        return 17;
    }

    @Test
    public void addDomainSpecifColumnsTest() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        Mockito.when((Object)this.getView().getListGrid()).thenReturn((Object)currentListGrid);
        HashSet<String> domainColumns = new HashSet<String>();
        domainColumns.add("var1");
        domainColumns.add("var2");
        domainColumns.add("var3");
        this.getView().addDomainSpecifColumns(domainColumns);
        ArgumentCaptor argument = ArgumentCaptor.forClass(List.class);
        ((ListTable)Mockito.verify((Object)currentListGrid, (VerificationMode)Mockito.times((int)3))).addColumns((List)argument.capture());
        List columns = argument.getAllValues();
        Assert.assertEquals((long)3L, (long)columns.size());
        Set captions = columns.stream().map(l -> (ColumnMeta)l.get(0)).map(m -> m.getCaption()).collect(Collectors.toSet());
        Assert.assertEquals(domainColumns, captions);
    }

    @Test
    public void removeDomainSpecifColumnsTest() {
        ListTable listGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        ColumnMeta columnToRemove = new ColumnMeta(AbstractTaskListViewTest.newColumnMock((String)"c1"), "", true, true);
        listGrid.getColumnMetaList().add(columnToRemove);
        listGrid.getColumnMetaList().add(new ColumnMeta(AbstractTaskListViewTest.newColumnMock((String)"c2"), "", false, true));
        listGrid.getColumnMetaList().add(new ColumnMeta(AbstractTaskListViewTest.newColumnMock((String)"c3"), "", true, false));
        listGrid.getColumnMetaList().add(new ColumnMeta(AbstractTaskListViewTest.newColumnMock((String)"c4"), "", false, false));
        listGrid.getGridPreferencesStore().setPreferenceKey("key");
        Mockito.when((Object)this.getView().getListGrid()).thenReturn((Object)listGrid);
        ((ListTable)Mockito.doNothing().when((Object)listGrid)).removeColumnMeta((ColumnMeta)Mockito.any());
        GridPreferencesStore store = new GridPreferencesStore(new GridGlobalPreferences());
        store.getColumnPreferences().add(new GridColumnPreference("c3", Integer.valueOf(0), ""));
        store.getColumnPreferences().add(new GridColumnPreference("c1", Integer.valueOf(1), ""));
        Mockito.when((Object)this.userPreferencesServiceMock.loadUserPreferences(listGrid.getGridPreferencesStore().getPreferenceKey(), UserPreferencesType.GRIDPREFERENCES)).thenReturn((Object)store);
        this.getView().removeDomainSpecifColumns();
        Assert.assertEquals((long)1L, (long)store.getColumnPreferences().size());
        Assert.assertEquals((Object)"c3", (Object)((GridColumnPreference)store.getColumnPreferences().get(0)).getName());
        ((ListTable)Mockito.verify((Object)listGrid)).removeColumnMeta(columnToRemove);
        ((ListTable)Mockito.verify((Object)listGrid)).saveGridPreferences();
    }

    @Test
    public void testStylesNotAppliedDependingOnPriority() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        this.getView().initSelectionModel(currentListGrid);
        ArgumentCaptor rowStylesApplied = ArgumentCaptor.forClass(RowStyles.class);
        ((ListTable)Mockito.verify((Object)currentListGrid)).setRowStyles((RowStyles)rowStylesApplied.capture());
        Assert.assertNull((Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskStatus.TASK_STATUS_READY.getIdentifier()).priority(Integer.valueOf(1)).build(), 1));
        Assert.assertNull((Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskStatus.TASK_STATUS_READY.getIdentifier()).priority(Integer.valueOf(3)).build(), 1));
        Assert.assertNull((Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskStatus.TASK_STATUS_READY.getIdentifier()).priority(Integer.valueOf(10)).build(), 1));
        Assert.assertEquals((Object)HumanTaskResources.INSTANCE.css().taskCompleted(), (Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskStatus.TASK_STATUS_COMPLETED.getIdentifier()).priority(Integer.valueOf(10)).build(), 1));
    }

    public abstract List<String> getExpectedInitialColumns();
}

