/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.common.collect.Sets;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Index;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListView;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListViewTest;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskListViewImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskListViewImplTest
extends AbstractTaskListViewTest {
    @InjectMocks
    @Spy
    private TaskListViewImpl view;
    @Mock
    private TaskListPresenter presenter;

    @Override
    public AbstractTaskListView getView() {
        return this.view;
    }

    @Override
    public AbstractTaskListPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    public List<String> getExpectedInitialColumns() {
        return Arrays.asList("name", "processId", "status", "createdOn", "Actions");
    }

    @Test
    public void initColumnsWithTaskVarColumnsTest() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        ((ListTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertEquals((long)20L, (long)columns.size());
                return null;
            }
        }).when((Object)currentListGrid)).addColumns(Matchers.anyList());
        ArrayList<GridColumnPreference> columnPreferences = new ArrayList<GridColumnPreference>();
        columnPreferences.add(new GridColumnPreference("var1", Integer.valueOf(0), "40"));
        columnPreferences.add(new GridColumnPreference("var2", Integer.valueOf(1), "40"));
        columnPreferences.add(new GridColumnPreference("var3", Integer.valueOf(1), "40"));
        Mockito.when((Object)currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStore);
        Mockito.when((Object)this.gridPreferencesStore.getColumnPreferences()).thenReturn(columnPreferences);
        this.getView().initColumns(currentListGrid);
        ((ListTable)Mockito.verify((Object)currentListGrid)).addColumns(Matchers.anyList());
    }

    @Override
    @Test
    public void addDomainSpecifColumnsTest() {
        ListTable currentListGrid = (ListTable)Mockito.spy((Object)new ListTable(new GridGlobalPreferences()));
        Mockito.when((Object)this.view.getListGrid()).thenReturn((Object)currentListGrid);
        List<String> resultList = Arrays.asList("var1", "var2", "var3");
        HashSet<String> domainColumns = new HashSet<String>(resultList);
        this.getView().addDomainSpecifColumns(domainColumns);
        ArgumentCaptor argument = ArgumentCaptor.forClass(List.class);
        ((ListTable)Mockito.verify((Object)currentListGrid, (VerificationMode)Mockito.times((int)3))).addColumns((List)argument.capture());
        List columnsList = argument.getAllValues();
        Assertions.assertThat((int)columnsList.size()).isEqualTo(3);
        Assertions.assertThat(columnsList.stream()).extracting(columns -> ((ColumnMeta)columns.get(0)).getCaption()).contains((Object)"var3", Index.atIndex((int)0)).contains((Object)"var2", Index.atIndex((int)1)).contains((Object)"var1", Index.atIndex((int)2));
    }

    @Test
    public void testRenameProcessVariableForInitColumns() {
        GridGlobalPreferences gridPreferences = new GridGlobalPreferences("test", this.view.getInitColumns(), this.view.getBannedColumns());
        ListTable extendedPagedTable = new ListTable(gridPreferences);
        List gridColumnPreferenceList = extendedPagedTable.getGridPreferencesStore().getColumnPreferences();
        gridColumnPreferenceList.add(new GridColumnPreference("Id", Integer.valueOf(-1), ""));
        gridColumnPreferenceList.add(new GridColumnPreference("performance", Integer.valueOf(-1), ""));
        this.view.initCellPreview(extendedPagedTable);
        Column createdOnColumn = this.view.createTextColumn("createdOn", task -> DateUtils.getDateTimeStr((Date)task.getCreatedOn()));
        ColumnMeta actionsColumnMeta = this.view.initActionsColumn();
        extendedPagedTable.addSelectionIgnoreColumn(actionsColumnMeta.getColumn());
        List columnMetas = this.view.getGeneralColumnMetas(extendedPagedTable, createdOnColumn, actionsColumnMeta);
        ((AbstractListAssert)Assertions.assertThat(columnMetas.stream()).extracting(c -> c.getCaption()).hasSize(17)).doesNotContain((Object[])new String[]{"Var_Id"});
        List tmp = this.view.renameVariables(extendedPagedTable, columnMetas);
        columnMetas.addAll(tmp);
        ((AbstractListAssert)Assertions.assertThat(columnMetas.stream()).extracting(c -> c.getCaption()).hasSize(19)).containsOnlyOnce((Object[])new String[]{"Var_Id"});
    }

    @Test
    public void testRenameProcessVariableForAddDomainSpecifColumns() {
        GridGlobalPreferences gridPreferences = new GridGlobalPreferences("test", this.view.getInitColumns(), this.view.getBannedColumns());
        ListTable extendedPagedTable = new ListTable(gridPreferences);
        Mockito.when((Object)this.view.getListGrid()).thenReturn((Object)extendedPagedTable);
        Set<String> set = Collections.singleton("Id");
        this.view.initColumns(extendedPagedTable);
        ((AbstractListAssert)Assertions.assertThat(extendedPagedTable.getColumnMetaList().stream()).extracting(c -> c.getCaption()).hasSize(17)).doesNotContain((Object[])new String[]{"Var_Id"});
        this.view.addDomainSpecifColumns(set);
        ((AbstractListAssert)Assertions.assertThat(extendedPagedTable.getColumnMetaList().stream()).extracting(c -> c.getCaption()).hasSize(18)).containsOnlyOnce((Object[])new String[]{"Var_Id"});
    }

    @Test
    public void testRemoveColumnMetaFromColumnsForAddDomainSpecifColumns() {
        GridGlobalPreferences gridPreferences = new GridGlobalPreferences("test", this.view.getInitColumns(), this.view.getBannedColumns());
        ListTable extendedPagedTable = new ListTable(gridPreferences);
        Mockito.when((Object)this.view.getListGrid()).thenReturn((Object)extendedPagedTable);
        extendedPagedTable.getGridPreferencesStore().getColumnPreferences().add(new GridColumnPreference("Extra", Integer.valueOf(-1), ""));
        HashSet set = Sets.newHashSet((Object[])new String[]{"Extra"});
        this.view.initColumns(extendedPagedTable);
        Assertions.assertThat((int)extendedPagedTable.getColumnMetaList().size()).isEqualTo(18);
        this.view.addDomainSpecifColumns((Set)set);
        Assertions.assertThat((int)set.size()).isEqualTo(0);
    }

    @Test
    public void testRemoveColumnMetaFromExtendedPagedTableForAddDomainSpecifColumns() {
        GridGlobalPreferences gridPreferences = new GridGlobalPreferences("test", this.view.getInitColumns(), this.view.getBannedColumns());
        ListTable extendedPagedTable = new ListTable(gridPreferences);
        Mockito.when((Object)this.view.getListGrid()).thenReturn((Object)extendedPagedTable);
        Column column = this.view.createTextColumn("Extra", taskSummary -> taskSummary.getName());
        ColumnMeta columnMeta = new ColumnMeta(column, "Extra", true, true);
        Set<String> set = Collections.singleton("Extra_test");
        this.view.initColumns(extendedPagedTable);
        Assertions.assertThat((int)extendedPagedTable.getColumnMetaList().size()).isEqualTo(17);
        extendedPagedTable.addColumns(Collections.singletonList(columnMeta));
        ((AbstractListAssert)Assertions.assertThat(extendedPagedTable.getColumnMetaList().stream()).extracting(c -> c.getCaption()).hasSize(18)).containsOnlyOnce((Object[])new String[]{"Extra"});
        this.view.addDomainSpecifColumns(set);
        ((AbstractListAssert)Assertions.assertThat(extendedPagedTable.getColumnMetaList().stream()).extracting(c -> c.getCaption()).hasSize(18)).doesNotContain((Object[])new String[]{"Extra"});
        Assertions.assertThat((int)set.size()).isEqualTo(1);
    }
}

