/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskcomments;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.common.client.dom.TextArea;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsViewImpl;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.views.pfly.widgets.FormGroup;
import org.uberfire.client.views.pfly.widgets.ValidationState;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskCommentsViewImplTest {
    @InjectMocks
    private TaskCommentsViewImpl view;
    @Mock
    private TaskCommentsPresenter presenter;
    @Mock
    private TextArea newCommentTextArea;
    @Mock(name="newCommentTextAreaHelp")
    private Span newCommentTextAreaHelp;
    @Mock
    private FormGroup newCommentTextAreaGroup;

    @Before
    public void setupMocks() {
    }

    @Test
    public void fieldValidationErrorTest() {
        Mockito.when((Object)this.newCommentTextArea.getValue()).thenReturn((Object)"");
        this.view.submitCommentAddition();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.newCommentTextAreaHelp});
        ((Span)inOrder.verify((Object)this.newCommentTextAreaHelp)).setTextContent("");
        ((Span)inOrder.verify((Object)this.newCommentTextAreaHelp)).setTextContent(Constants.INSTANCE.CommentCannotBeEmpty());
        InOrder inOrderValidationState = Mockito.inOrder((Object[])new Object[]{this.newCommentTextAreaGroup});
        ((FormGroup)inOrderValidationState.verify((Object)this.newCommentTextAreaGroup)).clearValidationState();
        ((FormGroup)inOrderValidationState.verify((Object)this.newCommentTextAreaGroup)).setValidationState(ValidationState.ERROR);
        ((TextArea)Mockito.verify((Object)this.newCommentTextArea)).focus();
        ((TaskCommentsPresenter)Mockito.verify((Object)this.presenter, (VerificationMode)Mockito.never())).addTaskComment(Mockito.anyString());
    }

    @Test
    public void fieldValidationSuccessTest() {
        String commentContent = "New comment";
        Mockito.when((Object)this.newCommentTextArea.getValue()).thenReturn((Object)commentContent);
        this.view.submitCommentAddition();
        ((TextArea)Mockito.verify((Object)this.newCommentTextArea, (VerificationMode)Mockito.never())).focus();
        ((Span)Mockito.verify((Object)this.newCommentTextAreaHelp)).setTextContent("");
        ((FormGroup)Mockito.verify((Object)this.newCommentTextAreaGroup)).clearValidationState();
        ((TaskCommentsPresenter)Mockito.verify((Object)this.presenter)).addTaskComment(commentContent);
    }
}

