/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskdetailsmulti;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.preferences.ManagePreferences;
import org.jbpm.workbench.forms.client.display.api.HumanTaskFormDisplayProvider;
import org.jbpm.workbench.forms.client.display.views.FormDisplayerView;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenter;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenterTest;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.workbench.ht.client.editors.taskdetails.TaskDetailsPresenter;
import org.jbpm.workbench.ht.client.editors.taskdetailsmulti.TaskDetailsMultiPresenter;
import org.jbpm.workbench.ht.client.editors.taskdetailsmulti.TaskDetailsMultiViewImpl;
import org.jbpm.workbench.ht.client.editors.taskform.TaskFormPresenter;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.ParameterizedCommand;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskDetailsMultiPresenterTest
extends AbstractTaskPresenterTest {
    private static final Long TASK_ID = 1L;
    private static final String TASK_NAME = "taskName";
    @Mock
    TaskService taskServiceMock;
    Caller<TaskService> taskService;
    @Mock
    TaskFormPresenter.TaskFormView taskFormViewMock;
    @Mock
    FormDisplayerView formDisplayerViewMock;
    @Spy
    Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent = new EventSourceMock();
    @Spy
    Event<TaskSelectionEvent> taskSelectionEvent = new EventSourceMock();
    @Mock
    private TaskFormPresenter taskFormPresenter;
    @Mock
    private TaskCommentsPresenter taskCommentsPresenter;
    @Mock
    private TaskCommentsPresenter taskWorkCommentsPresenter;
    @Mock
    private TaskDetailsMultiViewImpl view;
    @Mock
    private HumanTaskFormDisplayProvider taskFormDisplayProvider;
    @Mock
    private TaskDetailsPresenter taskDetailsPresenter;
    @Mock
    ManagePreferences managePreferences;
    @InjectMocks
    private TaskDetailsMultiPresenter presenter;

    @Override
    public AbstractTaskPresenter getPresenter() {
        return this.presenter;
    }

    @Before
    public void setupMocks() {
        this.taskService = new CallerMock((Object)this.taskServiceMock);
        this.presenter.setTaskDataService(this.taskService);
        Mockito.when((Object)this.taskServiceMock.getTask(Mockito.anyString(), Mockito.anyString(), Long.valueOf(Mockito.anyLong()))).thenReturn(Mockito.mock(TaskSummary.class));
        Mockito.when((Object)this.taskFormPresenter.getTaskFormView()).thenReturn((Object)this.taskFormViewMock);
        Mockito.when((Object)this.taskFormViewMock.getDisplayerView()).thenReturn((Object)this.formDisplayerViewMock);
        ((Event)Mockito.doNothing().when(this.changeTitleWidgetEvent)).fire(Mockito.any(ChangeTitleWidgetEvent.class));
        ((Event)Mockito.doNothing().when(this.taskSelectionEvent)).fire(Mockito.any(TaskSelectionEvent.class));
    }

    @Test
    public void isForLogRemainsEnabledAfterRefresh() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent("", "", TASK_ID, TASK_NAME, Boolean.valueOf(false), Boolean.valueOf(true)));
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).displayOnlyLogTab();
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).setAdminTabVisible(false);
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).resetTabs(true);
        ((TaskFormPresenter)Mockito.verify((Object)this.taskFormPresenter, (VerificationMode)Mockito.never())).getTaskFormView();
        Assert.assertFalse((boolean)this.presenter.isForAdmin());
        Assert.assertTrue((boolean)this.presenter.isForLog());
        this.presenter.onRefresh();
        Assert.assertFalse((boolean)this.presenter.isForAdmin());
        Assert.assertTrue((boolean)this.presenter.isForLog());
    }

    @Test
    public void isForLogRemainsDisabledAfterRefresh() {
        boolean logOnly = false;
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent("", "", TASK_ID, TASK_NAME, Boolean.valueOf(false), Boolean.valueOf(logOnly)));
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).displayAllTabs();
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).setAdminTabVisible(false);
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).resetTabs(logOnly);
        Assert.assertFalse((boolean)this.presenter.isForAdmin());
        Assert.assertFalse((boolean)this.presenter.isForLog());
        ((TaskFormPresenter)Mockito.verify((Object)this.taskFormPresenter, (VerificationMode)Mockito.times((int)2))).getTaskFormView();
        this.presenter.onRefresh();
        Assert.assertFalse((boolean)this.presenter.isForAdmin());
        Assert.assertFalse((boolean)this.presenter.isForLog());
    }

    @Test
    public void refreshTest() {
        Long taskId = 1L;
        String containerId = "container1.2";
        String serverTemplateId = "serverTemplateId";
        int slaCompliance = 1;
        TaskSummary taskSummary = TaskSummary.builder().deploymentId(containerId).id(taskId).name("name").description("description").expirationTime(new Date()).status("Completed").actualOwner("Rob").priority(Integer.valueOf(5)).processInstanceId(Long.valueOf(2L)).processId("Evaluation").slaCompliance(Integer.valueOf(slaCompliance)).build();
        Mockito.when((Object)this.taskServiceMock.getTask(serverTemplateId, containerId, taskId)).thenReturn((Object)taskSummary);
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(serverTemplateId, taskSummary.getDeploymentId(), (Long)taskSummary.getId(), taskSummary.getName(), Boolean.valueOf(false), Boolean.valueOf(false), taskSummary.getDescription(), taskSummary.getExpirationTime(), taskSummary.getStatus(), taskSummary.getActualOwner(), taskSummary.getPriority(), taskSummary.getProcessInstanceId(), taskSummary.getProcessId(), taskSummary.getSlaCompliance()));
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).displayAllTabs();
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).resetTabs(false);
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).setAdminTabVisible(false);
        this.presenter.onRefresh();
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getTask((String)Mockito.eq((Object)serverTemplateId), (String)Mockito.eq((Object)containerId), (Long)Mockito.eq((Object)taskId));
        ArgumentCaptor taskSelectionEventArgumentCaptor = ArgumentCaptor.forClass(TaskSelectionEvent.class);
        ((Event)Mockito.verify(this.taskSelectionEvent)).fire(taskSelectionEventArgumentCaptor.capture());
        Assert.assertEquals((Object)serverTemplateId, (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getServerTemplateId());
        Assert.assertEquals((Object)taskSummary.getDeploymentId(), (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getContainerId());
        Assert.assertEquals((Object)taskSummary.getId(), (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getTaskId());
        Assert.assertEquals((Object)taskSummary.getName(), (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getTaskName());
        Assert.assertEquals((Object)taskSummary.getDescription(), (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getDescription());
        Assert.assertEquals((Object)taskSummary.getExpirationTime(), (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getExpirationTime());
        Assert.assertEquals((Object)taskSummary.getStatus(), (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getStatus());
        Assert.assertEquals((Object)taskSummary.getActualOwner(), (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getActualOwner());
        Assert.assertEquals((Object)taskSummary.getPriority(), (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getPriority());
        Assert.assertEquals((Object)taskSummary.getProcessInstanceId(), (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getProcessInstanceId());
        Assert.assertEquals((Object)taskSummary.getProcessId(), (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getProcessId());
        Assert.assertEquals((Object)taskSummary.getSlaCompliance(), (Object)((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue()).getSlaCompliance());
        this.presenter.onTaskSelectionEvent((TaskSelectionEvent)taskSelectionEventArgumentCaptor.getValue());
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).displayAllTabs();
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).resetTabs(false);
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).setAdminTabVisible(false);
    }

    @Test
    public void refreshWithUnableTaskDetailsTest() {
        Long taskId = 1L;
        String containerId = "container1.2";
        String serverTemplateId = "serverTemplateId";
        Mockito.when((Object)this.taskServiceMock.getTask(serverTemplateId, containerId, taskId)).thenReturn(null);
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(false), Boolean.valueOf(false)));
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).displayAllTabs();
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).resetTabs(false);
        this.presenter.onRefresh();
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getTask((String)Mockito.eq((Object)serverTemplateId), (String)Mockito.eq((Object)containerId), (Long)Mockito.eq((Object)taskId));
        ((TaskDetailsMultiViewImpl)Mockito.verify((Object)this.view)).displayNotification(Mockito.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskSelectionEvent});
    }

    @Test
    public void showTaskCommentsAtWorkTabTest() {
        ManagePreferences showCommentsAtWorkTab = new ManagePreferences().defaultValue(new ManagePreferences());
        ((ManagePreferences)Mockito.doAnswer(inv -> {
            ((ParameterizedCommand)inv.getArguments()[0]).execute((Object)showCommentsAtWorkTab);
            return null;
        }).when((Object)this.managePreferences)).load((ParameterizedCommand)Mockito.any(ParameterizedCommand.class), (ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        this.presenter.getTaskWorkView();
        ((TaskFormPresenter)Mockito.verify((Object)this.taskFormPresenter)).getView();
        ((TaskCommentsPresenter)Mockito.verify((Object)this.taskWorkCommentsPresenter)).getView();
    }

    @Test
    public void noTaskCommentsAtWorkTabTest() {
        ManagePreferences showCommentsAtWorkTab = new ManagePreferences().defaultValue(new ManagePreferences());
        showCommentsAtWorkTab.setShowTaskCommentsAtWorkTab(false);
        ((ManagePreferences)Mockito.doAnswer(inv -> {
            ((ParameterizedCommand)inv.getArguments()[0]).execute((Object)showCommentsAtWorkTab);
            return null;
        }).when((Object)this.managePreferences)).load((ParameterizedCommand)Mockito.any(ParameterizedCommand.class), (ParameterizedCommand)Mockito.any(ParameterizedCommand.class));
        this.presenter.getTaskWorkView();
        ((TaskFormPresenter)Mockito.verify((Object)this.taskFormPresenter)).getView();
        ((TaskCommentsPresenter)Mockito.verify((Object)this.taskCommentsPresenter, (VerificationMode)Mockito.never())).getView();
    }
}

