/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListFilterSettingsManager;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenterTest;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskListFilterSettingsManager;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskListPresenter;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.util.TaskStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.Commands;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskListPresenterTest
extends AbstractTaskListPresenterTest {
    private static final String PERSPECTIVE_ID = "Tasks";
    private Constants commonConstants;
    @Spy
    TaskListFilterSettingsManager manager;
    @InjectMocks
    protected TaskListPresenter presenter;

    public TaskListPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    protected AbstractTaskListFilterSettingsManager getFilterSettingsManager() {
        return this.manager;
    }

    @Override
    @Before
    public void setupMocks() {
        super.setupMocks();
        Mockito.when((Object)this.perspectiveActivity.getIdentifier()).thenReturn((Object)PERSPECTIVE_ID);
        this.commonConstants = Constants.INSTANCE;
    }

    @Test
    public void testSuspendActionCondition() {
        TaskListPresenterTest.testTaskStatusCondition(this.getPresenter().getSuspendActionCondition(), TaskStatus.TASK_STATUS_RESERVED.getIdentifier(), TaskStatus.TASK_STATUS_IN_PROGRESS.getIdentifier());
    }

    @Test
    public void testResumeActionCondition() {
        TaskListPresenterTest.testTaskStatusCondition(this.getPresenter().getResumeActionCondition(), TaskStatus.TASK_STATUS_SUSPENDED.getIdentifier());
    }

    @Test
    public void userShouldNotBeAbleToReleaseTasksOwnedByOthers() {
        Assert.assertFalse((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner("userx").status(TaskStatus.TASK_STATUS_RESERVED.getIdentifier()).build()));
        Assert.assertFalse((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner("userx").status(TaskStatus.TASK_STATUS_IN_PROGRESS.getIdentifier()).build()));
    }

    @Test
    public void testListBreadcrumbCreation() {
        this.presenter.createListBreadcrumb();
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).clearBreadcrumbs(PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)this.commonConstants.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)this.commonConstants.Task_Inbox()), (Command)Matchers.eq((Object)Commands.DO_NOTHING));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.breadcrumbs});
    }

    @Test
    public void testSetupDetailBreadcrumb() {
        String detailLabel = "detailLabel";
        String detailScreenId = "screenId";
        PlaceManager placeManagerMock = (PlaceManager)Mockito.mock(PlaceManager.class);
        this.presenter.setPlaceManager(placeManagerMock);
        this.presenter.setupDetailBreadcrumb(placeManagerMock, this.commonConstants.Task_Inbox(), detailLabel, detailScreenId);
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).clearBreadcrumbs(PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)this.commonConstants.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)this.commonConstants.Task_Inbox()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).closePlace(detailScreenId);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)detailLabel), (Command)Matchers.eq((Object)Commands.DO_NOTHING));
    }
}

