/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskdetailsmulti;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.menu.RefreshMenuBuilder;
import org.jbpm.workbench.common.preferences.ManagePreferences;
import org.jbpm.workbench.forms.client.display.api.HumanTaskFormDisplayProvider;
import org.jbpm.workbench.forms.display.api.HumanTaskDisplayerConfig;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenter;
import org.jbpm.workbench.ht.client.editors.taskadmin.TaskAdminPresenter;
import org.jbpm.workbench.ht.client.editors.taskassignments.TaskAssignmentsPresenter;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.workbench.ht.client.editors.taskdetails.TaskDetailsPresenter;
import org.jbpm.workbench.ht.client.editors.taskform.TaskFormPresenter;
import org.jbpm.workbench.ht.client.editors.tasklogs.TaskLogsPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskKey;
import org.jbpm.workbench.ht.model.events.AbstractTaskEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.kie.workbench.common.workbench.client.error.DefaultWorkbenchErrorCallback;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="TaskDetailsScreen")
public class TaskDetailsMultiPresenter
extends AbstractTaskPresenter
implements RefreshMenuBuilder.SupportsRefresh {
    private Constants constants = Constants.INSTANCE;
    private Caller<TaskService> taskDataService;
    @Inject
    private TaskDetailsMultiView view;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private HumanTaskFormDisplayProvider taskFormDisplayProvider;
    @Inject
    private TaskFormPresenter taskFormPresenter;
    @Inject
    private TaskDetailsPresenter taskDetailsPresenter;
    @Inject
    private TaskLogsPresenter taskLogsPresenter;
    @Inject
    private TaskAssignmentsPresenter taskAssignmentsPresenter;
    @Inject
    private TaskCommentsPresenter taskCommentsPresenter;
    @Inject
    private TaskCommentsPresenter taskWorkCommentsPresenter;
    @Inject
    private TaskAdminPresenter taskAdminPresenter;
    @Inject
    protected ManagePreferences preferences;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleWidgetEvent;
    @Inject
    private Event<TaskSelectionEvent> taskSelected;
    private PlaceRequest place;
    private String processId = "";
    private boolean forLog = false;
    private boolean forAdmin = false;

    @WorkbenchPartView
    public UberView<TaskDetailsMultiPresenter> getView() {
        return this.view;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return Constants.INSTANCE.Details();
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @PostConstruct
    public void init() {
        this.preferences.load();
    }

    public boolean isForAdmin() {
        return this.forAdmin;
    }

    public void setIsForAdmin(boolean isForAdmin) {
        this.forAdmin = isForAdmin;
    }

    public boolean isForLog() {
        return this.forLog;
    }

    public void setIsForLog(boolean isForLog) {
        this.forLog = isForLog;
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        boolean refreshDetails = this.isSameTaskFromEvent().test((AbstractTaskEvent)event);
        this.setSelectedTask(event);
        this.processId = event.getTaskName();
        if (!event.isForLog().booleanValue()) {
            this.taskFormPresenter.getTaskFormView().getDisplayerView().setOnCloseCommand(() -> this.closeDetails());
            this.taskFormDisplayProvider.setup(new HumanTaskDisplayerConfig(new TaskKey(this.getServerTemplateId(), this.getContainerId(), this.getTaskId())), this.taskFormPresenter.getTaskFormView().getDisplayerView());
        }
        this.setIsForLog(event.isForLog());
        this.setIsForAdmin(event.isForAdmin());
        this.changeTitleWidgetEvent.fire((Object)new ChangeTitleWidgetEvent(this.place, String.valueOf(this.getTaskId()) + " - " + this.processId));
        this.view.setAdminTabVisible(false);
        if (this.isForLog()) {
            this.view.displayOnlyLogTab();
            this.disableTaskDetailsEdition();
        } else {
            this.view.displayAllTabs();
            if (this.isForAdmin()) {
                this.view.setAdminTabVisible(true);
            }
        }
        if (!refreshDetails) {
            this.view.resetTabs(event.isForLog());
        }
    }

    public void closeDetails() {
        this.placeManager.closePlace(this.place);
    }

    public void onRefresh() {
        ((TaskService)this.taskDataService.call(taskSummary -> {
            if (taskSummary != null) {
                this.taskSelected.fire((Object)new TaskSelectionEvent(this.getServerTemplateId(), taskSummary.getDeploymentId(), (Long)taskSummary.getId(), taskSummary.getName(), Boolean.valueOf(this.isForAdmin()), Boolean.valueOf(this.isForLog()), taskSummary.getDescription(), taskSummary.getExpirationTime(), taskSummary.getStatus(), taskSummary.getActualOwner(), taskSummary.getPriority(), taskSummary.getProcessInstanceId(), taskSummary.getProcessId(), taskSummary.getSlaCompliance()));
            } else {
                this.view.displayNotification(this.constants.TaskDetailsNotAvailable());
            }
        })).getTask(this.getServerTemplateId(), this.getContainerId(), this.getTaskId());
    }

    @WorkbenchMenu
    public void buildMenu(Consumer<Menus> menusConsumer) {
        menusConsumer.accept(((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build());
    }

    public IsWidget getGenericFormView() {
        return this.taskFormPresenter.getView();
    }

    public IsWidget getTaskDetailsView() {
        return this.taskDetailsPresenter.getView();
    }

    public IsWidget getTaskAssignmentsView() {
        return this.taskAssignmentsPresenter.getView();
    }

    public IsWidget getTaskCommentsView() {
        return this.taskCommentsPresenter.getView();
    }

    public IsWidget getTaskWorkView() {
        FlowPanel vPanel = (FlowPanel)GWT.create(FlowPanel.class);
        this.preferences.load(preferences -> {
            vPanel.add(this.getGenericFormView());
            if (preferences.isShowTaskCommentsAtWorkTab()) {
                this.taskWorkCommentsPresenter.setPageSize(3);
                this.taskWorkCommentsPresenter.showCommentsHeader();
                vPanel.add(this.taskWorkCommentsPresenter.getView());
            }
        }, error -> new DefaultWorkbenchErrorCallback().error(error));
        return vPanel;
    }

    public IsWidget getTaskAdminView() {
        return this.taskAdminPresenter.getView();
    }

    public IsWidget getTaskLogsView() {
        return this.taskLogsPresenter.getView();
    }

    public void disableTaskDetailsEdition() {
        this.taskDetailsPresenter.setReadOnlyTaskDetail();
    }

    public void taskAssignmentsRefresh() {
        this.taskAssignmentsPresenter.refreshTaskPotentialOwners();
    }

    public void taskCommentsRefresh() {
        this.taskWorkCommentsPresenter.refreshCommentsView();
        this.taskCommentsPresenter.refreshCommentsView();
    }

    public void taskLogsRefresh() {
        this.taskLogsPresenter.refreshLogs();
    }

    public void taskAdminRefresh() {
        this.taskAdminPresenter.refreshTaskPotentialOwners();
    }

    @Inject
    public void setTaskDataService(Caller<TaskService> taskDataService) {
        this.taskDataService = taskDataService;
    }

    public static interface TaskDetailsMultiView
    extends UberView<TaskDetailsMultiPresenter> {
        public void setAdminTabVisible(boolean var1);

        public void displayAllTabs();

        public void resetTabs(boolean var1);

        public void displayOnlyLogTab();

        public void displayNotification(String var1);
    }
}

