/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist.popup;

import com.google.gwt.core.client.GWT;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskKey;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchPopup;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@WorkbenchPopup(identifier="Tasks Reassignment Popup")
public class TasksReassignmentPresenter {
    public static final String TASKS_REASSIGNMENT_POPUP = "Tasks Reassignment Popup";
    private Constants constants = (Constants)GWT.create(Constants.class);
    @Inject
    private TasksReassignmentView view;
    @Inject
    private PlaceManager placeManager;
    private Event<TaskRefreshedEvent> taskRefreshed;
    private Event<NotificationEvent> notificationEvent;
    private PlaceRequest place;
    private Caller<TaskService> taskService;
    private String serverTemplateId;
    private String[] deploymentIds;
    private String[] taskIdsStr;
    private List<TaskKey> tasksToReassign;

    @Inject
    public void setTaskService(Caller<TaskService> taskService) {
        this.taskService = taskService;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Tasks_Reassignment();
    }

    @WorkbenchPartView
    public UberView<TasksReassignmentPresenter> getView() {
        return this.view;
    }

    @Inject
    public void setNotificationEvent(Event<NotificationEvent> notificationEvent) {
        this.notificationEvent = notificationEvent;
    }

    @Inject
    public void setTaskRefreshedEvent(Event<TaskRefreshedEvent> taskRefreshedEvent) {
        this.taskRefreshed = taskRefreshedEvent;
    }

    public void reassignTasksToUser(final String userId) {
        ((TaskService)this.taskService.call(reassignments -> {
            reassignments.forEach(taskAssignmentSummary -> {
                if (taskAssignmentSummary.isDelegationAllowed().booleanValue()) {
                    this.displayNotification(this.constants.TaskWasDelegated(String.valueOf(taskAssignmentSummary.getTaskId()), taskAssignmentSummary.getTaskName(), userId));
                } else {
                    this.displayUnsuccessfulNotification(this.constants.ReassignmentNotAllowedOn(String.valueOf(taskAssignmentSummary.getTaskId()), taskAssignmentSummary.getTaskName(), userId));
                }
            });
            reassignments.forEach(taskAssignmentSummary -> {
                if (taskAssignmentSummary.isDelegationAllowed().booleanValue()) {
                    this.taskRefreshed.fire((Object)new TaskRefreshedEvent());
                    return;
                }
            });
            this.placeManager.closePlace(this.place);
        }, (ErrorCallback)new DefaultErrorCallback(){

            public boolean error(Message message, Throwable throwable) {
                TasksReassignmentPresenter.this.displayUnsuccessfulNotification(TasksReassignmentPresenter.this.constants.UnableToPerformReassignment(userId, throwable.getMessage()));
                return false;
            }
        })).delegateTasks(this.serverTemplateId, this.tasksToReassign, userId);
    }

    public void displayNotification(String text) {
        this.notificationEvent.fire((Object)new NotificationEvent(text));
    }

    public void displayUnsuccessfulNotification(String text) {
        this.notificationEvent.fire((Object)new NotificationEvent(text, NotificationEvent.NotificationType.WARNING));
    }

    @OnOpen
    public void onOpen() {
        this.serverTemplateId = this.place.getParameter("serverTemplateId", "").toString();
        this.deploymentIds = this.place.getParameter("deploymentIds", "").toString().split(",");
        this.taskIdsStr = this.place.getParameter("taskIds", "-1").split(",");
        this.tasksToReassign = new ArrayList<TaskKey>();
        for (int i = 0; i < this.taskIdsStr.length; ++i) {
            this.tasksToReassign.add(new TaskKey(this.serverTemplateId, this.deploymentIds[i], Long.valueOf(this.taskIdsStr[i])));
        }
    }

    public static interface TasksReassignmentView
    extends UberView<TasksReassignmentPresenter> {
    }
}

