/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwt.view.client.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.enterprise.event.Event;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.common.client.dataset.ErrorHandlerBuilder;
import org.jbpm.workbench.common.client.filters.active.ActiveFilterItem;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterAddEvent;
import org.jbpm.workbench.common.client.filters.basic.BasicFilterRemoveEvent;
import org.jbpm.workbench.common.client.list.ListTable;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListFilterSettingsManager;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskListViewImpl;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskSummaryDataSetMapper;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.client.util.TaskUtils;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.model.events.TaskCompletedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.jbpm.workbench.ht.util.TaskStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.BeforeClosePlaceEvent;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

public abstract class AbstractTaskListPresenterTest {
    protected static final Long TASK_ID = 1L;
    protected static final String TASK_DEPLOYMENT_ID = "deploymentId";
    protected static final String USER_ID = "userId";
    @Mock
    protected User identity;
    @Mock
    TranslationService translationServiceMock;
    @Mock
    protected TaskService taskService;
    protected CallerMock<TaskService> callerMockRemoteTaskService;
    @Mock
    protected DataSetQueryHelper dataSetQueryHelper;
    @Mock
    protected DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Mock
    protected TaskListViewImpl viewMock;
    @Mock
    protected ListTable<TaskSummary> extendedPagedTable;
    @Mock
    protected DataSet dataSetMock;
    @Mock
    protected DataSet dataSetTaskVarMock;
    @Mock
    protected PlaceManager placeManager;
    @Mock
    protected UberfireBreadcrumbs breadcrumbs;
    @Mock
    protected PerspectiveManager perspectiveManager;
    @Mock
    protected PerspectiveActivity perspectiveActivity;
    @Mock
    private ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder;
    @Spy
    protected FilterSettings filterSettings;
    @Spy
    protected DataSetLookup dataSetLookup;
    @Spy
    protected Event<TaskSelectionEvent> taskSelected = new EventSourceMock();
    @Mock
    protected ManagedInstance<ErrorHandlerBuilder> errorHandlerBuilder;
    @Spy
    protected ErrorHandlerBuilder errorHandler;
    private String datasetUId = "dataserUId";

    protected static void testTaskStatusCondition(Predicate<TaskSummary> predicate, String ... validStatutes) {
        List allStatus = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ALL);
        List<String> validStatuses = Arrays.asList(validStatutes);
        allStatus.removeAll(validStatuses);
        allStatus.forEach(s -> Assert.assertFalse((boolean)predicate.test(TaskSummary.builder().status(s).build())));
        validStatuses.forEach(s -> Assert.assertTrue((boolean)predicate.test(TaskSummary.builder().status(s).build())));
    }

    @Before
    public void setupMocks() {
        this.callerMockRemoteTaskService = new CallerMock((Object)this.taskService);
        this.getPresenter().setTaskService(this.callerMockRemoteTaskService);
        ((Event)Mockito.doNothing().when(this.taskSelected)).fire(Matchers.any(TaskSelectionEvent.class));
        this.dataSetLookup.setDataSetUUID("jbpmHumanTasks");
        Mockito.when((Object)this.filterSettings.getDataSetLookup()).thenReturn((Object)this.dataSetLookup);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.filterSettings.getKey()).thenReturn((Object)"key");
        Mockito.when((Object)this.filterSettings.getUUID()).thenReturn((Object)this.datasetUId);
        Mockito.when((Object)this.perspectiveManager.getCurrentPerspective()).thenReturn((Object)this.perspectiveActivity);
        Mockito.when((Object)this.serverTemplateSelectorMenuBuilder.getView()).thenReturn(Mockito.mock(ServerTemplateSelectorMenuBuilder.ServerTemplateSelectorElementView.class));
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(AbstractTaskListPresenterTest.this.dataSetMock);
                return null;
            }
        }).when((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(AbstractTaskListPresenterTest.this.dataSetTaskVarMock);
                return null;
            }
        }).when((Object)this.dataSetQueryHelperDomainSpecific)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)USER_ID);
        Mockito.when((Object)this.errorHandlerBuilder.get()).thenReturn((Object)this.errorHandler);
        ((ErrorHandlerBuilder)Mockito.doNothing().when((Object)this.errorHandler)).showErrorMessage((String)Matchers.any());
        this.getPresenter().setServerTemplateSelectorMenuBuilder(this.serverTemplateSelectorMenuBuilder);
    }

    protected abstract AbstractTaskListPresenter getPresenter();

    protected abstract AbstractTaskListFilterSettingsManager getFilterSettingsManager();

    @Test
    public void getDataTest() {
        this.getPresenter().getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific, (VerificationMode)Mockito.never())).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
    }

    @Test
    public void releaseTaskTest() {
        TaskSummary task = TaskSummary.builder().id(TASK_ID).deploymentId(TASK_DEPLOYMENT_ID).build();
        this.getPresenter().releaseTask(task);
        ((TaskService)Mockito.verify((Object)this.taskService)).releaseTask("", TASK_DEPLOYMENT_ID, TASK_ID);
    }

    @Test
    public void bulkReleaseTasksTest() {
        HashMap containerTasks = new HashMap();
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>();
        taskSummaries.add(this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_RESERVED, this.identity.getIdentifier()));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 1L, TaskStatus.TASK_STATUS_RESERVED, this.identity.getIdentifier()));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 2L, TaskStatus.TASK_STATUS_RESERVED, this.identity.getIdentifier()));
        this.getPresenter().bulkRelease(taskSummaries);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)3))).releaseTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void claimTaskTest() {
        TaskSummary task = TaskSummary.builder().id(TASK_ID).deploymentId(TASK_DEPLOYMENT_ID).build();
        this.getPresenter().claimTask(task);
        ((TaskService)Mockito.verify((Object)this.taskService)).claimTask("", TASK_DEPLOYMENT_ID, TASK_ID);
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification((String)Matchers.any());
    }

    @Test
    public void bulkClaimTasksTest() {
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>();
        taskSummaries.add(this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_READY, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 1L, TaskStatus.TASK_STATUS_READY, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 2L, TaskStatus.TASK_STATUS_READY, ""));
        this.getPresenter().bulkClaim(taskSummaries);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)3))).claimTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void bulkClaimOnlyOnReadyTasksTest() {
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>();
        taskSummaries.add(this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_RESERVED, this.identity.getIdentifier()));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 1L, TaskStatus.TASK_STATUS_READY, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 2L, TaskStatus.TASK_STATUS_READY, ""));
        this.getPresenter().bulkClaim(taskSummaries);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)2))).claimTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.anyLong()));
        ((TaskService)Mockito.verify((Object)this.taskService)).claimTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.eq((long)(TASK_ID + 1L))));
        ((TaskService)Mockito.verify((Object)this.taskService)).claimTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.eq((long)(TASK_ID + 2L))));
    }

    @Test
    public void bulkResumeTasksTest() {
        HashMap containerTasks = new HashMap();
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>();
        taskSummaries.add(this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_SUSPENDED, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 1L, TaskStatus.TASK_STATUS_SUSPENDED, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 2L, TaskStatus.TASK_STATUS_SUSPENDED, ""));
        this.getPresenter().bulkResume(taskSummaries);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)3))).resumeTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.anyLong()));
    }

    @Test
    public void bulkResumeOnlyOnSuspendTasksTest() {
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>();
        taskSummaries.add(this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_RESERVED, this.identity.getIdentifier()));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 1L, TaskStatus.TASK_STATUS_SUSPENDED, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 2L, TaskStatus.TASK_STATUS_SUSPENDED, ""));
        this.getPresenter().bulkResume(taskSummaries);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)2))).resumeTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.anyLong()));
        ((TaskService)Mockito.verify((Object)this.taskService)).resumeTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.eq((long)(TASK_ID + 1L))));
        ((TaskService)Mockito.verify((Object)this.taskService)).resumeTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.eq((long)(TASK_ID + 2L))));
    }

    @Test
    public void bulkSuspendTasksTest() {
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>();
        taskSummaries.add(this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_RESERVED, this.identity.getIdentifier()));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 1L, TaskStatus.TASK_STATUS_IN_PROGRESS, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 2L, TaskStatus.TASK_STATUS_IN_PROGRESS, ""));
        this.getPresenter().bulkSuspend(taskSummaries);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)3))).suspendTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.anyLong()));
        ((TaskService)Mockito.verify((Object)this.taskService)).suspendTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), (Long)Mockito.eq((Object)TASK_ID));
        ((TaskService)Mockito.verify((Object)this.taskService)).suspendTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.eq((long)(TASK_ID + 1L))));
        ((TaskService)Mockito.verify((Object)this.taskService)).suspendTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.eq((long)(TASK_ID + 2L))));
    }

    @Test
    public void bulkSuspendOnlyOnActiveTasksTest() {
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>();
        taskSummaries.add(this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_RESERVED, this.identity.getIdentifier()));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 1L, TaskStatus.TASK_STATUS_IN_PROGRESS, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 2L, TaskStatus.TASK_STATUS_SUSPENDED, ""));
        this.getPresenter().bulkSuspend(taskSummaries);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)2))).suspendTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.anyLong()));
        ((TaskService)Mockito.verify((Object)this.taskService)).suspendTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), (Long)Mockito.eq((Object)TASK_ID));
        ((TaskService)Mockito.verify((Object)this.taskService)).suspendTask(Mockito.anyString(), (String)Mockito.eq((Object)TASK_DEPLOYMENT_ID), Long.valueOf(Mockito.eq((long)(TASK_ID + 1L))));
    }

    @Test
    public void claimAndWorkTaskTest() {
        TaskSummary task = TaskSummary.builder().id(TASK_ID).deploymentId(TASK_DEPLOYMENT_ID).status("Ready").build();
        this.getPresenter().claimAndWorkTask(task);
        ((TaskService)Mockito.verify((Object)this.taskService)).claimTask("", TASK_DEPLOYMENT_ID, TASK_ID);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("TaskDetailsScreen");
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock)).displayNotification((String)Matchers.any());
    }

    @Test
    public void resumeTaskTest() {
        TaskSummary task = TaskSummary.builder().id(TASK_ID).deploymentId(TASK_DEPLOYMENT_ID).build();
        this.getPresenter().resumeTask(task);
        ((TaskService)Mockito.verify((Object)this.taskService)).resumeTask("", TASK_DEPLOYMENT_ID, TASK_ID);
    }

    @Test
    public void suspendTaskTest() {
        TaskSummary task = TaskSummary.builder().id(TASK_ID).deploymentId(TASK_DEPLOYMENT_ID).build();
        this.getPresenter().suspendTask(task);
        ((TaskService)Mockito.verify((Object)this.taskService)).suspendTask("", TASK_DEPLOYMENT_ID, TASK_ID);
    }

    @Test
    public void bulkReassignTasksTest() {
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>();
        taskSummaries.add(this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_RESERVED, this.identity.getIdentifier()));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 1L, TaskStatus.TASK_STATUS_IN_PROGRESS, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 2L, TaskStatus.TASK_STATUS_SUSPENDED, ""));
        ArrayList<Object> tIds = new ArrayList<Object>();
        ArrayList<String> deploymentIds = new ArrayList<String>();
        for (TaskSummary summary : taskSummaries) {
            tIds.add(summary.getId());
            deploymentIds.add(summary.getDeploymentId());
        }
        this.getPresenter().bulkReassign(taskSummaries);
        ArgumentCaptor placeRequest = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)placeRequest.capture());
        Assert.assertEquals((Object)"Tasks Reassignment Popup", (Object)((PlaceRequest)placeRequest.getValue()).getIdentifier());
        Assert.assertEquals((Object)StringUtils.join(tIds, (String)","), (Object)((PlaceRequest)placeRequest.getValue()).getParameter("taskIds", null));
        Assert.assertEquals((Object)StringUtils.join(deploymentIds, (String)","), (Object)((PlaceRequest)placeRequest.getValue()).getParameter("deploymentIds", null));
    }

    @Test
    public void testRemoveActiveFilter() {
        String taskName = "taskName";
        this.getPresenter().removeActiveFilter(FilterFactory.equalsTo((String)"name", (Comparable)((Object)"taskName")));
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock)).removeDomainSpecifColumns();
        Mockito.reset((Object[])new TaskListViewImpl[]{this.viewMock});
        this.getPresenter().removeActiveFilter(FilterFactory.in((String)"name", Arrays.asList("taskName")));
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.never())).removeDomainSpecifColumns();
    }

    @Test
    public void isFilteredByTaskNameTest() {
        String taskName = "taskName";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"name", (Comparable)((Object)"taskName"))});
        String filterTaskName = this.getPresenter().isFilteredByTaskName(Collections.singletonList(filter));
        Assert.assertEquals((Object)"taskName", (Object)filterTaskName);
    }

    @Test
    public void isFilteredByTaskNameInvalidTest() {
        String taskName = "taskName";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.likeTo((String)"description", (String)"taskName")});
        String filterTaskName = this.getPresenter().isFilteredByTaskName(Collections.singletonList(filter));
        Assert.assertNull((Object)filterTaskName);
    }

    @Test
    public void getDomainSpecificDataForTasksTest() {
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"name", (Comparable)((Object)"taskName"))});
        this.filterSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        Mockito.when((Object)this.dataSetMock.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetMock.getValueAt(0, "taskId")).thenReturn((Object)1L);
        Mockito.when((Object)this.dataSetTaskVarMock.getRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "taskId")).thenReturn((Object)1L);
        String taskVariable1 = "var1";
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "name")).thenReturn((Object)taskVariable1);
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "value")).thenReturn((Object)"value1");
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(1, "taskId")).thenReturn((Object)1L);
        String taskVariable2 = "var2";
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(1, "name")).thenReturn((Object)taskVariable2);
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(1, "value")).thenReturn((Object)"value2");
        Set<String> expectedColumns = new HashSet<String>();
        expectedColumns.add(taskVariable1);
        expectedColumns.add(taskVariable2);
        this.getPresenter().getData(new Range(0, 5));
        ArgumentCaptor argument = ArgumentCaptor.forClass(Set.class);
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock)).addDomainSpecifColumns((Set)argument.capture());
        Assert.assertEquals(expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        Mockito.when((Object)this.dataSetTaskVarMock.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "taskId")).thenReturn((Object)1L);
        taskVariable1 = "varTest1";
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "name")).thenReturn((Object)taskVariable1);
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "value")).thenReturn((Object)"value1");
        expectedColumns = Collections.singleton(taskVariable1);
        this.getPresenter().getData(new Range(0, 5));
        argument = ArgumentCaptor.forClass(Set.class);
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).addDomainSpecifColumns((Set)argument.capture());
        Assert.assertEquals(expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
    }

    @Test
    public void testTaskSummaryAdmin() {
        List<String> dataSets = Arrays.asList("jbpmHumanTasksWithAdmin", "jbpmHumanTasksWithUser", "jbpmHumanTasks", "jbpmHumanTasksWithVariables");
        for (String dataSet : dataSets) {
            Mockito.when((Object)this.dataSetMock.getUUID()).thenReturn((Object)dataSet);
            TaskSummary summary = new TaskSummaryDataSetMapper().apply(this.dataSetMock, Integer.valueOf(0));
            Assert.assertNotNull((Object)summary);
            Assert.assertEquals((Object)"jbpmHumanTasksWithAdmin".equals(dataSet), (Object)summary.isForAdmin());
        }
    }

    @Test
    public void testExistActiveSearchFilters() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)place.getParameter("processInstanceId", null)).thenReturn((Object)"1");
        this.getPresenter().onStartup(place);
        Assert.assertTrue((boolean)this.getPresenter().existActiveSearchFilters());
        Mockito.when((Object)place.getParameter("taskId", null)).thenReturn((Object)"1");
        Assert.assertTrue((boolean)this.getPresenter().existActiveSearchFilters());
        Mockito.when((Object)place.getParameter("taskId", null)).thenReturn(null);
        Mockito.when((Object)place.getParameter("processInstanceId", null)).thenReturn(null);
        Assert.assertFalse((boolean)this.getPresenter().existActiveSearchFilters());
    }

    @Test
    public void testActiveSearchFiltersProcessInstanceId() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        String processInstanceId = "1";
        Mockito.when((Object)place.getParameter("processInstanceId", null)).thenReturn((Object)"1");
        this.getPresenter().onStartup(place);
        this.getPresenter().setupActiveSearchFilters();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((ActiveFilterItem)captor.capture());
        ActiveFilterItem filterItem = (ActiveFilterItem)captor.getValue();
        Assert.assertNotNull((Object)filterItem);
        Assert.assertEquals((Object)Constants.INSTANCE.Process_Instance_Id(), (Object)filterItem.getKey());
        Assert.assertEquals((Object)1, (Object)filterItem.getValue());
        Assert.assertEquals((Object)(Constants.INSTANCE.Process_Instance_Id() + ": " + "1"), (Object)filterItem.getLabelValue());
    }

    @Test
    public void testSetUpActiveSearchByTaskIdFilters() {
        PlaceRequest place = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        String taskId = "1";
        Mockito.when((Object)place.getParameter("taskId", null)).thenReturn((Object)"1");
        this.getPresenter().onStartup(place);
        this.getPresenter().setupActiveSearchFilters();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActiveFilterItem.class);
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((ActiveFilterItem)captor.capture());
        ActiveFilterItem filterItem = (ActiveFilterItem)captor.getValue();
        Assert.assertNotNull((Object)filterItem);
        Assert.assertEquals((Object)Constants.INSTANCE.Task(), (Object)filterItem.getKey());
        Assert.assertEquals((Object)1, (Object)filterItem.getValue());
        Assert.assertEquals((Object)(Constants.INSTANCE.Task() + ": " + "1"), (Object)filterItem.getLabelValue());
    }

    @Test
    public void testActiveFilterLabelStatus() {
        String readyTranslation = "Ready_t";
        String reservedTranslation = "Reserved_t";
        String inProgressTranslation = "InProgress_t";
        ArrayList status = new ArrayList(TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ACTIVE));
        Mockito.when((Object)this.translationServiceMock.format("Ready", new Object[0])).thenReturn((Object)readyTranslation);
        Mockito.when((Object)this.translationServiceMock.format("Reserved", new Object[0])).thenReturn((Object)reservedTranslation);
        Mockito.when((Object)this.translationServiceMock.format("InProgress", new Object[0])).thenReturn((Object)inProgressTranslation);
        ColumnFilter testColumFilter = FilterFactory.in((String)"status", status);
        ActiveFilterItem activeFilterItem = this.getPresenter().getActiveFilterFromColumnFilter(testColumFilter);
        Assert.assertEquals((Object)Constants.INSTANCE.Status(), (Object)activeFilterItem.getKey());
        Assert.assertEquals((Object)"Status: Ready_t, Reserved_t, InProgress_t", (Object)activeFilterItem.getLabelValue());
        Assert.assertEquals((long)3L, (long)((List)activeFilterItem.getValue()).size());
        Assert.assertNotEquals((Object)testColumFilter.toString(), (Object)activeFilterItem.getLabelValue());
        ((TranslationService)Mockito.verify((Object)this.translationServiceMock, (VerificationMode)Mockito.times((int)3))).format(Mockito.anyString(), new Object[0]);
    }

    @Test
    public void testActiveFilterLabelOther() {
        ColumnFilter testColumFilter = FilterFactory.equalsTo((String)"processInstanceId", (Comparable)Integer.valueOf(1));
        ActiveFilterItem activeFilterItem = this.getPresenter().getActiveFilterFromColumnFilter(testColumFilter);
        Assert.assertEquals((Object)"processInstanceId", (Object)activeFilterItem.getKey());
        Assert.assertEquals((Object)testColumFilter.toString(), (Object)activeFilterItem.getLabelValue());
        testColumFilter = FilterFactory.equalsTo((String)"name", (Comparable)((Object)"columnName"));
        activeFilterItem = this.getPresenter().getActiveFilterFromColumnFilter(testColumFilter);
        Assert.assertEquals((Object)"name", (Object)activeFilterItem.getKey());
        Assert.assertEquals((Object)testColumFilter.toString(), (Object)activeFilterItem.getLabelValue());
    }

    @Test
    public void testCompleteActionCondition() {
        Assert.assertTrue((boolean)this.getPresenter().getCompleteActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskStatus.TASK_STATUS_IN_PROGRESS.getIdentifier()).build()));
        Assert.assertFalse((boolean)this.getPresenter().getCompleteActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskStatus.TASK_STATUS_READY.getIdentifier()).build()));
    }

    @Test
    public void testClaimActionCondition() {
        AbstractTaskListPresenterTest.testTaskStatusCondition(this.getPresenter().getClaimActionCondition(), TaskStatus.TASK_STATUS_READY.getIdentifier());
    }

    @Test
    public void testReleaseActionCondition() {
        Assert.assertTrue((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskStatus.TASK_STATUS_RESERVED.getIdentifier()).build()));
        Assert.assertTrue((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskStatus.TASK_STATUS_IN_PROGRESS.getIdentifier()).build()));
        Assert.assertFalse((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskStatus.TASK_STATUS_COMPLETED.getIdentifier()).build()));
        Assert.assertFalse((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskStatus.TASK_STATUS_CREATED.getIdentifier()).build()));
    }

    @Test
    public void testProcessInstanceCondition() {
        Assert.assertTrue((boolean)this.getPresenter().getProcessInstanceCondition().test(TaskSummary.builder().processInstanceId(Long.valueOf(1L)).build()));
        Assert.assertFalse((boolean)this.getPresenter().getProcessInstanceCondition().test(TaskSummary.builder().build()));
    }

    @Test
    public void testExitedTaskSelection() {
        TaskSummary taskSummary = this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_EXITED, "");
        this.getPresenter().selectSummaryItem(taskSummary);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("TaskDetailsScreen");
        ArgumentCaptor captor = ArgumentCaptor.forClass(TaskSelectionEvent.class);
        ((Event)Mockito.verify(this.taskSelected)).fire(captor.capture());
        Assert.assertTrue((boolean)((TaskSelectionEvent)captor.getValue()).isForLog());
        Assert.assertEquals((Object)taskSummary, (Object)this.getPresenter().getSelectedTask());
    }

    @Test
    public void testReadyTaskSelection() {
        Integer slaCompliance = 1;
        TaskSummary taskSummary = this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_READY, "");
        taskSummary.setSlaCompliance(slaCompliance);
        this.getPresenter().selectSummaryItem(taskSummary);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("TaskDetailsScreen");
        ArgumentCaptor captor = ArgumentCaptor.forClass(TaskSelectionEvent.class);
        ((Event)Mockito.verify(this.taskSelected)).fire(captor.capture());
        Assert.assertFalse((boolean)((TaskSelectionEvent)captor.getValue()).isForLog());
        Assert.assertEquals((Object)slaCompliance, (Object)((TaskSelectionEvent)captor.getValue()).getSlaCompliance());
        Assert.assertEquals((Object)taskSummary, (Object)this.getPresenter().getSelectedTask());
    }

    @Test
    public void testOnBasicFilterAddEvent() {
        ActiveFilterItem filter = new ActiveFilterItem("key1", null, null, null, null);
        ColumnFilter columnFilter = (ColumnFilter)Mockito.mock(ColumnFilter.class);
        this.getPresenter().onBasicFilterAddEvent(new BasicFilterAddEvent(this.datasetUId, filter, columnFilter));
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter(filter);
        ((FilterSettings)Mockito.verify((Object)this.filterSettings)).addColumnFilter(columnFilter);
    }

    @Test
    public void testOnBasicFilterRemoveEvent() {
        ActiveFilterItem filter = new ActiveFilterItem("key1", null, null, null, null);
        ColumnFilter columnFilter = (ColumnFilter)Mockito.mock(ColumnFilter.class);
        this.getPresenter().onBasicFilterRemoveEvent(new BasicFilterRemoveEvent(this.datasetUId, filter, columnFilter));
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock)).removeActiveFilter(filter);
        ((FilterSettings)Mockito.verify((Object)this.filterSettings)).removeColumnFilter(columnFilter);
    }

    @Test
    public void testTaskIsSameFromEvent() {
        String serverTemplateId = "serverTemplateId";
        Assert.assertFalse((boolean)this.getPresenter().isSameTaskFromEvent().test(new TaskCompletedEvent("serverTemplateId", TASK_DEPLOYMENT_ID, TASK_ID)));
        TaskSummary taskSummary = this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_READY, "");
        this.getPresenter().setSelectedServerTemplate(new ServerTemplate("serverTemplateId", null, Collections.singletonList(Capability.PROCESS.name()), Collections.emptyMap(), Collections.emptyList()));
        this.getPresenter().selectSummaryItem(taskSummary);
        Assert.assertTrue((boolean)this.getPresenter().isSameTaskFromEvent().test(new TaskCompletedEvent("serverTemplateId", TASK_DEPLOYMENT_ID, TASK_ID)));
        Assert.assertFalse((boolean)this.getPresenter().isSameTaskFromEvent().test(new TaskCompletedEvent("serverTemplateId", TASK_DEPLOYMENT_ID, Long.valueOf(2L))));
        Assert.assertFalse((boolean)this.getPresenter().isSameTaskFromEvent().test(new TaskCompletedEvent("anotherServerTemplateId", TASK_DEPLOYMENT_ID, TASK_ID)));
        Assert.assertFalse((boolean)this.getPresenter().isSameTaskFromEvent().test(new TaskCompletedEvent("serverTemplateId", "anotherContainerId", TASK_ID)));
    }

    @Test
    public void testOnTaskCompletedEvent() {
        TaskSummary taskSummary = this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_READY, "");
        String serverTemplateId = "serverTemplateId";
        this.getPresenter().setSelectedServerTemplate(new ServerTemplate("serverTemplateId", null, Collections.singletonList(Capability.PROCESS.name()), Collections.emptyMap(), Collections.emptyList()));
        this.getPresenter().selectSummaryItem(taskSummary);
        this.getPresenter().onTaskCompletedEvent(new TaskCompletedEvent("serverTemplateId", TASK_DEPLOYMENT_ID, TASK_ID));
        this.getPresenter().onTaskCompletedEvent(new TaskCompletedEvent("serverTemplateId", TASK_DEPLOYMENT_ID, Long.valueOf(2L)));
        ((ListTable)Mockito.verify(this.extendedPagedTable, (VerificationMode)Mockito.times((int)2))).setVisibleRangeAndClearData((Range)Matchers.any(), Mockito.eq((boolean)true));
    }

    protected static BeforeClosePlaceEvent newCloseEventMock(String placeId) {
        BeforeClosePlaceEvent event = (BeforeClosePlaceEvent)Mockito.mock(BeforeClosePlaceEvent.class);
        Mockito.when((Object)event.getPlace()).thenReturn((Object)new DefaultPlaceRequest(placeId));
        return event;
    }

    @Test
    public void testOnTaskDetailsClosed() {
        TaskSummary taskSummary = this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_EXITED, "");
        this.getPresenter().selectSummaryItem(taskSummary);
        Assert.assertEquals((Object)taskSummary, (Object)this.getPresenter().getSelectedTask());
        this.getPresenter().onTaskDetailsClosed(AbstractTaskListPresenterTest.newCloseEventMock("TaskAdminListScreen"));
        Assert.assertEquals((Object)taskSummary, (Object)this.getPresenter().getSelectedTask());
        this.getPresenter().onTaskDetailsClosed(AbstractTaskListPresenterTest.newCloseEventMock("TaskDetailsScreen"));
        Assert.assertNull((Object)this.getPresenter().getSelectedTask());
    }

    protected TaskSummary createTestTaskSummary(Long taskId, TaskStatus taskStatus, String actualOwner) {
        Long newTaskId = taskId;
        String statusStr = TaskStatus.TASK_STATUS_READY.getIdentifier();
        if (taskId == null) {
            newTaskId = new Random().nextLong();
        }
        if (taskStatus != null) {
            statusStr = taskStatus.getIdentifier();
        }
        return TaskSummary.builder().id(newTaskId).deploymentId(TASK_DEPLOYMENT_ID).status(statusStr).actualOwner(actualOwner).build();
    }
}

