/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist.popup;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import org.jbpm.workbench.ht.client.editors.taskslist.popup.TasksReassignmentPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskAssignmentSummary;
import org.jbpm.workbench.ht.model.TaskKey;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.views.pfly.widgets.ConfirmPopup;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class TasksReassignmentPresenterTest {
    private static final Long TASK_ID = 1L;
    private static final Long TASK_ID2 = 2L;
    private static final String TASK_NAME = "task_1";
    private static final String TASK_NAME2 = "task_2";
    private static final String SERVER_TEMPLATE_ID = "serverTemplateIdTest";
    private static final String DEPLOYMENT_ID = "deploymentIdTest";
    @Mock
    public TasksReassignmentPresenter.TasksReassignmentView view;
    @Mock
    ConfirmPopup confirmPopup;
    @Spy
    Event<TaskRefreshedEvent> taskRefreshedEvent = new EventSourceMock();
    @Spy
    Event<NotificationEvent> notificationEvent = new EventSourceMock();
    private CallerMock<TaskService> remoteTaskServiceCaller;
    @Mock
    private TaskService taskService;
    @Mock
    private PlaceRequest place;
    @Mock
    private PlaceManager placeManager;
    @InjectMocks
    private TasksReassignmentPresenter presenter;

    @Before
    public void setupMocks() {
        ((Event)Mockito.doNothing().when(this.taskRefreshedEvent)).fire(Mockito.any(TaskRefreshedEvent.class));
        ((Event)Mockito.doNothing().when(this.notificationEvent)).fire(Mockito.any());
        this.remoteTaskServiceCaller = new CallerMock((Object)this.taskService);
        this.presenter.setTaskService(this.remoteTaskServiceCaller);
    }

    @Test
    public void reassignTasksTest() {
        String userId = "testUser";
        Mockito.when((Object)this.place.getParameter("serverTemplateId", "")).thenReturn((Object)SERVER_TEMPLATE_ID);
        Mockito.when((Object)this.place.getParameter("deploymentIds", "")).thenReturn((Object)"deploymentIdTest,deploymentIdTest");
        Mockito.when((Object)this.place.getParameter("taskIds", "-1")).thenReturn((Object)(TASK_ID + "," + TASK_ID2));
        Mockito.when((Object)this.taskService.delegateTasks(Matchers.anyString(), Matchers.anyList(), (String)Mockito.eq((Object)userId))).thenReturn(Arrays.asList(TaskAssignmentSummary.builder().taskId(Long.valueOf(TASK_ID)).taskName(TASK_NAME).delegationAllowed(Boolean.valueOf(true)).build(), TaskAssignmentSummary.builder().taskId(Long.valueOf(TASK_ID2)).taskName(TASK_NAME2).delegationAllowed(Boolean.valueOf(false)).build()));
        this.presenter.onStartup(this.place);
        this.presenter.onOpen();
        this.presenter.reassignTasksToUser(userId);
        ArgumentCaptor listCaptor = ArgumentCaptor.forClass(List.class);
        ((TaskService)Mockito.verify((Object)this.taskService)).delegateTasks((String)Mockito.eq((Object)SERVER_TEMPLATE_ID), (List)listCaptor.capture(), (String)Mockito.eq((Object)userId));
        Assert.assertEquals((long)2L, (long)((List)listCaptor.getValue()).size());
        Assert.assertEquals((Object)SERVER_TEMPLATE_ID, (Object)((TaskKey)((List)listCaptor.getValue()).get(0)).getServerTemplateId());
        Assert.assertEquals((Object)TASK_ID, (Object)((TaskKey)((List)listCaptor.getValue()).get(0)).getTaskId());
        Assert.assertEquals((Object)DEPLOYMENT_ID, (Object)((TaskKey)((List)listCaptor.getValue()).get(0)).getDeploymentId());
        Assert.assertEquals((Object)SERVER_TEMPLATE_ID, (Object)((TaskKey)((List)listCaptor.getValue()).get(1)).getServerTemplateId());
        Assert.assertEquals((Object)TASK_ID2, (Object)((TaskKey)((List)listCaptor.getValue()).get(1)).getTaskId());
        Assert.assertEquals((Object)DEPLOYMENT_ID, (Object)((TaskKey)((List)listCaptor.getValue()).get(1)).getDeploymentId());
        ArgumentCaptor captor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((Event)Mockito.verify(this.notificationEvent, (VerificationMode)Mockito.times((int)2))).fire(captor.capture());
        Assert.assertEquals((long)2L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.DEFAULT, (Object)((NotificationEvent)captor.getAllValues().get(0)).getType());
        Assert.assertEquals((Object)Constants.INSTANCE.TaskWasDelegated(String.valueOf(TASK_ID), TASK_NAME, userId), (Object)((NotificationEvent)captor.getAllValues().get(0)).getNotification());
        Assert.assertEquals((Object)NotificationEvent.NotificationType.WARNING, (Object)((NotificationEvent)captor.getAllValues().get(1)).getType());
        Assert.assertEquals((Object)Constants.INSTANCE.ReassignmentNotAllowedOn(String.valueOf(TASK_ID2), TASK_NAME2, userId), (Object)((NotificationEvent)captor.getAllValues().get(1)).getNotification());
    }
}

