/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwt.user.cellview.client.RowStyles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jbpm.workbench.common.client.list.AbstractMultiGridViewTest;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListView;
import org.jbpm.workbench.ht.client.resources.HumanTaskResources;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.widgets.table.client.ColumnMeta;

public abstract class AbstractTaskListViewTest
extends AbstractMultiGridViewTest<TaskSummary> {
    public abstract AbstractTaskListView getView();

    public abstract AbstractTaskListPresenter getPresenter();

    public List<String> getExpectedInitialColumns() {
        return Arrays.asList("name", "processId", "status", "createdOn", "Actions");
    }

    public List<String> getExpectedBannedColumns() {
        return Arrays.asList("name", "Actions");
    }

    public Integer getExpectedNumberOfColumns() {
        return 15;
    }

    @Test
    public void initColumnsWithTaskVarColumnsTest() {
        ExtendedPagedTable currentListGrid = (ExtendedPagedTable)Mockito.spy((Object)new ExtendedPagedTable(new GridGlobalPreferences()));
        ((ExtendedPagedTable)Mockito.doAnswer((Answer)new Answer(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                List columns = (List)invocationOnMock.getArguments()[0];
                Assert.assertTrue((columns.size() == 18 ? 1 : 0) != 0);
                return null;
            }
        }).when((Object)currentListGrid)).addColumns(Mockito.anyList());
        ArrayList<GridColumnPreference> columnPreferences = new ArrayList<GridColumnPreference>();
        columnPreferences.add(new GridColumnPreference("var1", Integer.valueOf(0), "40"));
        columnPreferences.add(new GridColumnPreference("var2", Integer.valueOf(1), "40"));
        columnPreferences.add(new GridColumnPreference("var3", Integer.valueOf(1), "40"));
        Mockito.when((Object)currentListGrid.getGridPreferencesStore()).thenReturn((Object)this.gridPreferencesStore);
        Mockito.when((Object)this.gridPreferencesStore.getColumnPreferences()).thenReturn(columnPreferences);
        this.getView().initColumns(currentListGrid);
        ((ExtendedPagedTable)Mockito.verify((Object)currentListGrid)).addColumns(Mockito.anyList());
    }

    @Test
    public void addDomainSpecifColumnsTest() {
        ExtendedPagedTable currentListGrid = (ExtendedPagedTable)Mockito.spy((Object)new ExtendedPagedTable(new GridGlobalPreferences()));
        HashSet<String> domainColumns = new HashSet<String>();
        domainColumns.add("var1");
        domainColumns.add("var2");
        domainColumns.add("var3");
        this.getView().addDomainSpecifColumns(currentListGrid, domainColumns);
        ArgumentCaptor argument = ArgumentCaptor.forClass(List.class);
        ((ExtendedPagedTable)Mockito.verify((Object)currentListGrid)).addColumns((List)argument.capture());
        List columns = (List)argument.getValue();
        Assert.assertTrue((columns.size() == 3 ? 1 : 0) != 0);
        int i = 0;
        for (String domainColumn : domainColumns) {
            Assert.assertEquals((Object)((ColumnMeta)columns.get(i)).getCaption(), (Object)domainColumn);
            ++i;
        }
    }

    @Test
    public void testStylesNotAppliedDependingOnPriority() {
        ExtendedPagedTable currentListGrid = (ExtendedPagedTable)Mockito.spy((Object)new ExtendedPagedTable(new GridGlobalPreferences()));
        this.getView().initSelectionModel(currentListGrid);
        ArgumentCaptor rowStylesApplied = ArgumentCaptor.forClass(RowStyles.class);
        ((ExtendedPagedTable)Mockito.verify((Object)currentListGrid)).setRowStyles((RowStyles)rowStylesApplied.capture());
        Mockito.when((Object)currentListGrid.getSelectedRow()).thenReturn((Object)0);
        Assert.assertNull((Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskUtils.TASK_STATUS_READY).priority(Integer.valueOf(1)).build(), 1));
        Assert.assertNull((Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskUtils.TASK_STATUS_READY).priority(Integer.valueOf(3)).build(), 1));
        Assert.assertNull((Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskUtils.TASK_STATUS_READY).priority(Integer.valueOf(10)).build(), 1));
        Assert.assertEquals((Object)HumanTaskResources.INSTANCE.css().taskCompleted(), (Object)((RowStyles)rowStylesApplied.getValue()).getStyleNames((Object)TaskSummary.builder().status(TaskUtils.TASK_STATUS_COMPLETED).priority(Integer.valueOf(10)).build(), 1));
    }
}

