/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import java.util.ArrayList;
import java.util.function.Predicate;
import javax.enterprise.context.Dependent;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskAdminListViewImpl;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchScreen(identifier="Task Admin List")
public class TaskAdminListPresenter
extends AbstractTaskListPresenter<TaskAdminListViewImpl> {
    public static final String SCREEN_ID = "Task Admin List";

    @WorkbenchPartTitle
    public String getTitle() {
        return this.constants.Tasks_Admin();
    }

    @Override
    @WorkbenchMenu
    public Menus getMenus() {
        return super.getMenus();
    }

    @Override
    public void setupAdvancedSearchView() {
        super.setupAdvancedSearchView();
        this.addProcessNameFilter("jbpmHumanTasksWithAdmin");
    }

    public FilterSettings createTableSettingsPrototype() {
        return this.createStatusSettings("jbpmHumanTasksWithAdmin", null);
    }

    public FilterSettings createAdminTabSettings() {
        return this.createStatusSettings("jbpmHumanTasksWithAdmin", new ArrayList<Comparable>(TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ADMIN)));
    }

    @Override
    protected Predicate<TaskSummary> getSuspendActionCondition() {
        return task -> {
            String taskStatus = task.getStatus();
            return taskStatus.equals(TaskUtils.TASK_STATUS_RESERVED) || taskStatus.equals(TaskUtils.TASK_STATUS_IN_PROGRESS) || taskStatus.equals(TaskUtils.TASK_STATUS_READY);
        };
    }

    @Override
    protected Predicate<TaskSummary> getResumeActionCondition() {
        return task -> TaskUtils.TASK_STATUS_SUSPENDED.equals(task.getStatus());
    }
}

