/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskdetails;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.common.client.util.UTCDateBox;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;

@Dependent
public class TaskDetailsPresenter {
    @Inject
    protected Event<TaskRefreshedEvent> taskRefreshed;
    TaskDetailsView view;
    private Constants constants = Constants.INSTANCE;
    @Inject
    private Caller<TaskService> taskService;
    private long currentTaskId = 0L;
    private String currentServerTemplateId;
    private String currentContainerId;

    @Inject
    public TaskDetailsPresenter(TaskDetailsView view, Caller<TaskService> taskService, Event<TaskRefreshedEvent> taskRefreshed) {
        this.view = view;
        this.taskService = taskService;
        this.taskRefreshed = taskRefreshed;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void updateTask(String taskDescription, Date dueDate, int priority) {
        if (this.currentTaskId > 0L) {
            ((TaskService)this.taskService.call(Void2 -> {
                this.view.displayNotification(this.constants.TaskDetailsUpdatedForTaskId(this.currentTaskId));
                this.taskRefreshed.fire((Object)new TaskRefreshedEvent(this.currentTaskId));
            })).updateTask(this.currentServerTemplateId, this.currentContainerId, Long.valueOf(this.currentTaskId), Integer.valueOf(priority), taskDescription, dueDate);
        }
    }

    protected void setTaskDetails(String status, String description, String actualOwner, Date expirationTime, String priority) {
        if (TaskUtils.TASK_STATUS_COMPLETED.equals(status)) {
            this.setReadOnlyTaskDetail();
        }
        this.view.setTaskDescription(description);
        Long date = UTCDateBox.date2utc((Date)expirationTime);
        if (date != null) {
            this.view.setDueDate(date);
            this.view.setDueDateTime(date);
        }
        this.view.setUser(actualOwner);
        this.view.setTaskStatus(status);
        this.view.setTaskPriority(priority);
    }

    public void setReadOnlyTaskDetail() {
        this.view.setTaskDescriptionEnabled(false);
        this.view.setDueDateEnabled(false);
        this.view.setDueDateTimeEnabled(false);
        this.view.setTaskPriorityEnabled(false);
        this.view.setUpdateTaskVisible(false);
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentTaskId = event.getTaskId();
        this.currentServerTemplateId = event.getServerTemplateId();
        this.currentContainerId = event.getContainerId();
        this.setTaskDetails(event.getStatus(), event.getDescription(), event.getActualOwner(), event.getExpirationTime(), String.valueOf(event.getPriority()));
    }

    public static interface TaskDetailsView
    extends IsWidget {
        public void init(TaskDetailsPresenter var1);

        public void setTaskDescription(String var1);

        public void setTaskDescriptionEnabled(Boolean var1);

        public void setDueDate(Long var1);

        public void setDueDateEnabled(Boolean var1);

        public void setDueDateTime(Long var1);

        public void setDueDateTimeEnabled(Boolean var1);

        public void setUser(String var1);

        public void setTaskStatus(String var1);

        public void setTaskPriority(String var1);

        public void setTaskPriorityEnabled(Boolean var1);

        public void setUpdateTaskVisible(Boolean var1);

        public void displayNotification(String var1);
    }
}

