/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.function.Consumer;
import org.jbpm.workbench.df.client.filter.SavedFilter;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListFilterSettingsManager;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListFilterSettingsManagerTest;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskListFilterSettingsManager;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskListFilterSettingsManagerTest
extends AbstractTaskListFilterSettingsManagerTest {
    @InjectMocks
    TaskListFilterSettingsManager manager;

    @Override
    public AbstractTaskListFilterSettingsManager getFilterSettingsManager() {
        return this.manager;
    }

    @Override
    public String getDataSetId() {
        return "jbpmHumanTasksWithUser";
    }

    @Before
    public void setup() {
        super.setupMocks();
    }

    @Test
    public void testLoadPreferencesRemovingFilterAdmin() {
        this.testRemoveFilter("DataSetTaskListGrid_4");
    }

    @Test
    public void testLoadPreferencesRemovingFilterAll() {
        this.testRemoveFilter("DataSetTaskListGrid_3");
    }

    private void testRemoveFilter(String name) {
        MultiGridPreferencesStore pref = new MultiGridPreferencesStore();
        pref.getGridsId().add(name);
        this.manager.loadSavedFiltersFromPreferences(pref, null);
        ArgumentCaptor captor = ArgumentCaptor.forClass(MultiGridPreferencesStore.class);
        ((UserPreferencesService)Mockito.verify((Object)this.preferencesService, (VerificationMode)Mockito.times((int)2))).saveUserPreferences((UserPreference)captor.capture());
        Assert.assertFalse((boolean)((MultiGridPreferencesStore)captor.getAllValues().get(0)).getGridsId().contains(name));
    }

    @Test
    public void testDefaultFilters() {
        Consumer<List> callback = filters -> {
            Assert.assertEquals((long)3L, (long)filters.size());
            Assert.assertEquals((Object)Constants.INSTANCE.Active(), (Object)((SavedFilter)filters.get(0)).getName());
            Assert.assertEquals((Object)"DataSetTaskListGrid_base", (Object)((SavedFilter)filters.get(0)).getKey());
            Assert.assertEquals((Object)Constants.INSTANCE.Personal(), (Object)((SavedFilter)filters.get(1)).getName());
            Assert.assertEquals((Object)Constants.INSTANCE.Group(), (Object)((SavedFilter)filters.get(2)).getName());
        };
        MultiGridPreferencesStore store = new MultiGridPreferencesStore();
        this.manager.loadSavedFiltersFromPreferences(store, callback);
        ((UserPreferencesService)Mockito.verify((Object)this.preferencesService)).saveUserPreferences((UserPreference)store);
    }
}

