/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import org.jbpm.workbench.common.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListFilterSettingsManager;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenterTest;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskAdminListFilterSettingsManager;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskAdminListPresenter;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.service.TaskService;
import org.jbpm.workbench.ht.util.TaskStatus;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.breadcrumbs.UberfireBreadcrumbs;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.Commands;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskAdminListPresenterTest
extends AbstractTaskListPresenterTest {
    private static final String PERSPECTIVE_ID = "TaskAdmin";
    private Constants commonConstants;
    @Spy
    protected TaskAdminListFilterSettingsManager manager;
    @InjectMocks
    protected TaskAdminListPresenter presenter;

    public TaskAdminListPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    protected AbstractTaskListFilterSettingsManager getFilterSettingsManager() {
        return this.manager;
    }

    @Override
    @Before
    public void setupMocks() {
        super.setupMocks();
        Mockito.when((Object)this.perspectiveActivity.getIdentifier()).thenReturn((Object)PERSPECTIVE_ID);
        this.commonConstants = Constants.INSTANCE;
    }

    @Test
    public void testSuspendActionCondition() {
        TaskAdminListPresenterTest.testTaskStatusCondition(this.getPresenter().getSuspendActionCondition(), TaskStatus.TASK_STATUS_RESERVED.getIdentifier(), TaskStatus.TASK_STATUS_IN_PROGRESS.getIdentifier(), TaskStatus.TASK_STATUS_READY.getIdentifier());
    }

    @Test
    public void testResumeActionCondition() {
        TaskAdminListPresenterTest.testTaskStatusCondition(this.getPresenter().getResumeActionCondition(), TaskStatus.TASK_STATUS_SUSPENDED.getIdentifier());
    }

    @Test
    public void adminShouldBeAbleToReleaseTaskOwnedByOthers() {
        Assert.assertTrue((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner("userx").status(TaskStatus.TASK_STATUS_RESERVED.getIdentifier()).build()));
        Assert.assertTrue((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner("userx").status(TaskStatus.TASK_STATUS_IN_PROGRESS.getIdentifier()).build()));
    }

    @Test
    public void testListBreadcrumbCreation() {
        this.presenter.createListBreadcrumb();
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).clearBreadcrumbs(PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)this.commonConstants.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)this.commonConstants.Manage_Tasks()), (Command)Matchers.eq((Object)Commands.DO_NOTHING));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.breadcrumbs});
    }

    @Test
    public void testSetupDetailBreadcrumb() {
        String detailLabel = "detailLabel";
        String detailScreenId = "screenId";
        PlaceManager placeManagerMock = (PlaceManager)Mockito.mock(PlaceManager.class);
        this.presenter.setPlaceManager(placeManagerMock);
        this.presenter.setupDetailBreadcrumb(placeManagerMock, this.commonConstants.Manage_Tasks(), detailLabel, detailScreenId);
        ArgumentCaptor captureCommand = ArgumentCaptor.forClass(Command.class);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).clearBreadcrumbs(PERSPECTIVE_ID);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)this.commonConstants.Home()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).goTo("HomePerspective");
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)this.commonConstants.Manage_Tasks()), (Command)captureCommand.capture());
        ((Command)captureCommand.getValue()).execute();
        ((PlaceManager)Mockito.verify((Object)placeManagerMock)).closePlace(detailScreenId);
        ((UberfireBreadcrumbs)Mockito.verify((Object)this.breadcrumbs)).addBreadCrumb((String)Matchers.eq((Object)PERSPECTIVE_ID), (String)Matchers.eq((Object)detailLabel), (Command)Matchers.eq((Object)Commands.DO_NOTHING));
    }

    @Test
    public void bulkReleaseOnlyOnReservedOrInProgressTasksTest() {
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>();
        taskSummaries.add(this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_RESERVED, this.identity.getIdentifier()));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 1L, TaskStatus.TASK_STATUS_RESERVED, "otherUser"));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 2L, TaskStatus.TASK_STATUS_READY, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 3L, TaskStatus.TASK_STATUS_IN_PROGRESS, ""));
        this.getPresenter().bulkRelease(taskSummaries);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)3))).releaseTask(Matchers.anyString(), (String)Matchers.eq((Object)"deploymentId"), Long.valueOf(Matchers.anyLong()));
        ((TaskService)Mockito.verify((Object)this.taskService)).releaseTask(Matchers.anyString(), (String)Matchers.eq((Object)"deploymentId"), (Long)Matchers.eq((Object)TASK_ID));
        ((TaskService)Mockito.verify((Object)this.taskService)).releaseTask(Matchers.anyString(), (String)Matchers.eq((Object)"deploymentId"), Long.valueOf(Matchers.eq((long)(TASK_ID + 1L))));
        ((TaskService)Mockito.verify((Object)this.taskService)).releaseTask(Matchers.anyString(), (String)Matchers.eq((Object)"deploymentId"), Long.valueOf(Matchers.eq((long)(TASK_ID + 3L))));
    }

    @Test
    public void bulkSuspendOnlyOnReserveInProgressReadyTest() {
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>();
        taskSummaries.add(this.createTestTaskSummary(TASK_ID, TaskStatus.TASK_STATUS_RESERVED, this.identity.getIdentifier()));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 1L, TaskStatus.TASK_STATUS_IN_PROGRESS, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 2L, TaskStatus.TASK_STATUS_READY, ""));
        taskSummaries.add(this.createTestTaskSummary(TASK_ID + 3L, TaskStatus.TASK_STATUS_COMPLETED, "userId"));
        this.getPresenter().bulkSuspend(taskSummaries);
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)3))).suspendTask(Matchers.anyString(), (String)Matchers.eq((Object)"deploymentId"), Long.valueOf(Matchers.anyLong()));
        ((TaskService)Mockito.verify((Object)this.taskService)).suspendTask(Matchers.anyString(), (String)Matchers.eq((Object)"deploymentId"), (Long)Matchers.eq((Object)TASK_ID));
        ((TaskService)Mockito.verify((Object)this.taskService)).suspendTask(Matchers.anyString(), (String)Matchers.eq((Object)"deploymentId"), Long.valueOf(Matchers.eq((long)(TASK_ID + 1L))));
        ((TaskService)Mockito.verify((Object)this.taskService)).suspendTask(Matchers.anyString(), (String)Matchers.eq((Object)"deploymentId"), Long.valueOf(Matchers.eq((long)(TASK_ID + 2L))));
    }
}

