/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenterTest;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskListPresenter;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskListPresenterTest
extends AbstractTaskListPresenterTest {
    @InjectMocks
    protected TaskListPresenter presenter;

    public TaskListPresenter getPresenter() {
        return this.presenter;
    }

    @Override
    public String getDataSetId() {
        return "jbpmHumanTasksWithUser";
    }

    @Test
    public void testSuspendActionCondition() {
        TaskListPresenterTest.testTaskStatusCondition(this.getPresenter().getSuspendActionCondition(), TaskUtils.TASK_STATUS_RESERVED, TaskUtils.TASK_STATUS_IN_PROGRESS);
    }

    @Test
    public void testResumeActionCondition() {
        TaskListPresenterTest.testTaskStatusCondition(this.getPresenter().getResumeActionCondition(), TaskUtils.TASK_STATUS_SUSPENDED);
    }

    @Test
    public void userShouldNotBeAbleToReleaseTasksOwnedByOthers() {
        Assert.assertFalse((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner("userx").status(TaskUtils.TASK_STATUS_RESERVED).build()));
        Assert.assertFalse((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner("userx").status(TaskUtils.TASK_STATUS_IN_PROGRESS).build()));
    }
}

