/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskprocesscontext;

import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.ActivityResourceType;

@Dependent
public class TaskProcessContextPresenter {
    public User identity;
    private PlaceManager placeManager;
    private ActivityManager activityManager;
    private TaskProcessContextView view;
    private AuthorizationManager authorizationManager;
    private Long currentProcessInstanceId = -1L;

    @Inject
    public TaskProcessContextPresenter(TaskProcessContextView view, PlaceManager placeManager, ActivityManager activityManager, AuthorizationManager authorizationManager, User identity) {
        this.view = view;
        this.placeManager = placeManager;
        this.activityManager = activityManager;
        this.authorizationManager = authorizationManager;
        this.identity = identity;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        boolean enableProcessInstanceLink = false;
        if (this.hasAccessToPerspective("ProcessInstances") && !this.activityManager.getActivities((PlaceRequest)new DefaultPlaceRequest("ProcessInstances")).isEmpty()) {
            enableProcessInstanceLink = true;
        }
        this.view.enablePIDetailsButton(enableProcessInstanceLink);
    }

    public IsWidget getView() {
        return this.view;
    }

    public void goToProcessInstanceDetails() {
        DefaultPlaceRequest request = new DefaultPlaceRequest("ProcessInstances");
        request.addParameter("processInstanceId", this.currentProcessInstanceId.toString());
        this.placeManager.goTo((PlaceRequest)request);
    }

    public void setProcessContextData(Long processInstanceId, String processId) {
        if (processInstanceId == null) {
            this.view.setProcessInstanceId("None");
            this.view.setProcessId("None");
            this.view.enablePIDetailsButton(false);
            return;
        }
        this.view.setProcessInstanceId(String.valueOf(processInstanceId));
        this.view.setProcessId(processId);
        this.view.enablePIDetailsButton(true);
    }

    boolean hasAccessToPerspective(String perspectiveId) {
        ResourceRef resourceRef = new ResourceRef(perspectiveId, (ResourceType)ActivityResourceType.PERSPECTIVE);
        return this.authorizationManager.authorize((Resource)resourceRef, this.identity);
    }

    public void onTaskSelectionEvent(@Observes TaskSelectionEvent event) {
        this.currentProcessInstanceId = event.getProcessInstanceId();
        this.setProcessContextData(event.getProcessInstanceId(), event.getProcessId());
    }

    public static interface TaskProcessContextView
    extends UberView<TaskProcessContextPresenter> {
        public void displayNotification(String var1);

        public void setProcessInstanceId(String var1);

        public void setProcessId(String var1);

        public void enablePIDetailsButton(boolean var1);
    }
}

