/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskdetails;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import org.jbpm.workbench.ht.client.editors.taskdetails.TaskDetailsPresenter;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskDetailsPresenterTest {
    private CallerMock<TaskService> callerMock;
    @Mock
    private TaskService taskService;
    @Mock
    private TaskDetailsPresenter.TaskDetailsView viewMock;
    @Mock
    private EventSourceMock<TaskRefreshedEvent> taskRefreshedEvent;
    private TaskDetailsPresenter presenter;

    @Before
    public void setup() {
        this.callerMock = new CallerMock((Object)this.taskService);
        ((EventSourceMock)Mockito.doNothing().when(this.taskRefreshedEvent)).fire(Mockito.any(TaskRefreshedEvent.class));
        this.presenter = new TaskDetailsPresenter(this.viewMock, this.callerMock, this.taskRefreshedEvent);
    }

    @Test
    public void disableTaskDetailEditionTest() {
        this.presenter.setReadOnlyTaskDetail();
        this.verifyReadOnlyMode(1);
    }

    @Test
    public void testSetTaskDetails_statusComplete() {
        String status = "Completed";
        String description = "description";
        String actualOwner = "Owner";
        Date expirationTime = new Date();
        String priority = "2";
        this.presenter.setTaskDetails(status, description, actualOwner, expirationTime, priority);
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock)).setDueDate((Long)Mockito.any());
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock)).setDueDateTime((Long)Mockito.any());
        this.verifySetTaskDetails(actualOwner, status, priority);
        this.verifyReadOnlyMode(1);
    }

    @Test
    public void testSetTaskDetails_statusReady() {
        String status = "Ready";
        String description = "description";
        String actualOwner = "Owner";
        Date expirationTime = new Date();
        String priority = "2";
        this.presenter.setTaskDetails(status, description, actualOwner, expirationTime, priority);
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock)).setDueDate((Long)Mockito.any());
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock)).setDueDateTime((Long)Mockito.any());
        this.verifySetTaskDetails(actualOwner, status, priority);
        this.verifyReadOnlyMode(0);
    }

    @Test
    public void testUpdateDetails() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        boolean isForLog = false;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog), "description", new Date(), "Completed", "actualOwner", Integer.valueOf(2), Long.valueOf(1L), "processId");
        this.presenter.onTaskSelectionEvent(event);
        String description = "description";
        Date dueDate = new Date();
        int priority = 3;
        this.presenter.updateTask(description, dueDate, priority);
        ((TaskService)Mockito.verify((Object)this.taskService)).updateTask(serverTemplateId, containerId, taskId, Integer.valueOf(priority), description, dueDate);
        ArgumentCaptor argument = ArgumentCaptor.forClass(TaskRefreshedEvent.class);
        ((EventSourceMock)Mockito.verify(this.taskRefreshedEvent)).fire(argument.capture());
        Assert.assertEquals((Object)taskId, (Object)((TaskRefreshedEvent)argument.getValue()).getTaskId());
    }

    private void verifySetTaskDetails(String actualOwner, String status, String priority) {
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock)).setUser(actualOwner);
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock)).setTaskStatus(status);
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock)).setTaskPriority(priority);
    }

    private void verifyReadOnlyMode(int i) {
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)i))).setTaskDescriptionEnabled(Boolean.valueOf(false));
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)i))).setDueDateEnabled(Boolean.valueOf(false));
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)i))).setDueDateTimeEnabled(Boolean.valueOf(false));
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)i))).setTaskPriorityEnabled(Boolean.valueOf(false));
        ((TaskDetailsPresenter.TaskDetailsView)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)i))).setUpdateTaskVisible(Boolean.valueOf(false));
    }
}

