/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskprocesscontext;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.ht.client.editors.taskprocesscontext.TaskProcessContextPresenter;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;

@RunWith(value=MockitoJUnitRunner.class)
public class TaskProcessContextPresenterTest {
    private static final String PROCESS_ID = "ProcessId";
    private static final Long PROCESS_INSTANCE_ID = 1L;
    @Mock
    public User identity;
    @Mock
    private TaskProcessContextPresenter.TaskProcessContextView viewMock;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private AuthorizationManager authorizationManager;
    private TaskProcessContextPresenter presenter;

    @Before
    public void before() {
        this.presenter = new TaskProcessContextPresenter(this.viewMock, this.placeManager, this.activityManager, this.authorizationManager, this.identity);
    }

    @Test
    public void testSetProcessContextData() {
        this.presenter.setProcessContextData(PROCESS_INSTANCE_ID, PROCESS_ID);
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessId(PROCESS_ID);
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessInstanceId(PROCESS_INSTANCE_ID.toString());
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(true);
        this.presenter.setProcessContextData(null, null);
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessInstanceId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(false);
    }

    @Test
    public void processContex_whenTaskSelected() {
        TaskSelectionEvent testTaskSelectionEvent = new TaskSelectionEvent("serverTemplateId", "containerId", Long.valueOf(1L), "taskName", Boolean.valueOf(true), Boolean.valueOf(true), "description", new Date(), "Ready", "actualOwner", Integer.valueOf(3), PROCESS_INSTANCE_ID, PROCESS_ID);
        this.presenter.onTaskSelectionEvent(testTaskSelectionEvent);
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessId(PROCESS_ID);
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessInstanceId(PROCESS_INSTANCE_ID.toString());
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(true);
    }

    @Test
    public void processContex_whenTaskSelectedEmptyProcessInstanceId() {
        TaskSelectionEvent testTaskSelectionEvent = new TaskSelectionEvent("serverTemplateId", "containerId", Long.valueOf(1L), "taskName", Boolean.valueOf(true), Boolean.valueOf(true), "description", new Date(), "Ready", "actualOwner", Integer.valueOf(3), null, null);
        this.presenter.onTaskSelectionEvent(testTaskSelectionEvent);
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).setProcessInstanceId("None");
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(false);
    }

    @Test
    public void testGoToProcessInstanceDetails() {
        TaskSelectionEvent testTaskSelectionEvent = new TaskSelectionEvent("serverTemplateId", "containerId", Long.valueOf(1L), "taskName", Boolean.valueOf(true), Boolean.valueOf(true), "description", new Date(), "Ready", "actualOwner", Integer.valueOf(3), PROCESS_INSTANCE_ID, PROCESS_ID);
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(ResourceRef.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true, (Object[])new Boolean[]{false});
        this.presenter.onTaskSelectionEvent(testTaskSelectionEvent);
        this.presenter.goToProcessInstanceDetails();
        ArgumentCaptor captor = ArgumentCaptor.forClass(PlaceRequest.class);
        ((PlaceManager)Mockito.verify((Object)this.placeManager)).goTo((PlaceRequest)captor.capture());
        Assert.assertEquals((long)1L, (long)captor.getAllValues().size());
        Assert.assertEquals((Object)"ProcessInstances", (Object)((PlaceRequest)captor.getAllValues().get(0)).getIdentifier());
        Assert.assertEquals((Object)PROCESS_INSTANCE_ID.toString(), (Object)((PlaceRequest)captor.getAllValues().get(0)).getParameter("processInstanceId", ""));
    }

    @Test
    public void testProcessContextEnabled() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(Resource.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)Matchers.any(PlaceRequest.class))).thenReturn((Object)Sets.newHashSet((Object[])new Activity[]{(Activity)Mockito.mock(Activity.class)}));
        this.presenter.init();
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(true);
    }

    @Test
    public void testProcessContextDisabled() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(Resource.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)true);
        Mockito.when((Object)this.activityManager.getActivities((PlaceRequest)Matchers.any(PlaceRequest.class))).thenReturn(Collections.emptySet());
        this.presenter.init();
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(false);
    }

    @Test
    public void testProcessContextDisabledWhenUserHasNoPermission() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(Resource.class), (User)Mockito.eq((Object)this.identity))).thenReturn((Object)false);
        this.presenter.init();
        ((TaskProcessContextPresenter.TaskProcessContextView)Mockito.verify((Object)this.viewMock)).enablePIDetailsButton(false);
    }
}

