/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwt.view.client.Range;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.enterprise.event.Event;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.common.client.menu.ServerTemplateSelectorMenuBuilder;
import org.jbpm.workbench.common.client.util.TaskUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.list.DataSetQueryHelper;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskListViewImpl;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskSummaryDataSetMapper;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskSummary;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.model.menu.Menus;

public abstract class AbstractTaskListPresenterTest {
    private static final Long TASK_ID = 1L;
    private static final String TASK_DEPLOYMENT_ID = "deploymentId";
    @Mock
    protected User identity;
    @Mock
    protected TaskService taskService;
    protected CallerMock<TaskService> callerMockRemoteTaskService;
    @Mock
    protected ServerTemplateSelectorMenuBuilder serverTemplateSelectorMenuBuilder;
    @Mock
    DataSetQueryHelper dataSetQueryHelper;
    @Mock
    DataSetQueryHelper dataSetQueryHelperDomainSpecific;
    @Mock
    private TaskListViewImpl viewMock;
    @Mock
    private ExtendedPagedTable<TaskSummary> extendedPagedTable;
    @Mock
    private DataSet dataSetMock;
    @Mock
    private DataSet dataSetTaskVarMock;
    @Spy
    private FilterSettings filterSettings;
    @Spy
    private DataSetLookup dataSetLookup;
    @Spy
    private Event<TaskSelectionEvent> taskSelected = new EventSourceMock();

    protected static void testTaskStatusCondition(Predicate<TaskSummary> predicate, String ... validStatutes) {
        List allStatus = TaskUtils.getStatusByType((TaskUtils.TaskType)TaskUtils.TaskType.ALL);
        List<String> validStatuses = Arrays.asList(validStatutes);
        allStatus.removeAll(validStatuses);
        allStatus.forEach(s -> Assert.assertFalse((boolean)predicate.test(TaskSummary.builder().status(s).build())));
        validStatuses.forEach(s -> Assert.assertTrue((boolean)predicate.test(TaskSummary.builder().status(s).build())));
    }

    public abstract String getDataSetId();

    @Before
    public void setupMocks() {
        this.callerMockRemoteTaskService = new CallerMock((Object)this.taskService);
        this.getPresenter().setTaskService(this.callerMockRemoteTaskService);
        ((Event)Mockito.doNothing().when(this.taskSelected)).fire(Matchers.any(TaskSelectionEvent.class));
        this.dataSetLookup.setDataSetUUID("jbpmHumanTasks");
        Mockito.when((Object)this.filterSettings.getDataSetLookup()).thenReturn((Object)this.dataSetLookup);
        Mockito.when((Object)this.viewMock.getListGrid()).thenReturn(this.extendedPagedTable);
        Mockito.when((Object)this.extendedPagedTable.getPageSize()).thenReturn((Object)10);
        Mockito.when((Object)this.dataSetQueryHelper.getCurrentTableSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.viewMock.getAdvancedSearchFilterSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.filterSettings.getKey()).thenReturn((Object)"key");
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(AbstractTaskListPresenterTest.this.dataSetMock);
                return null;
            }
        }).when((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                ((DataSetReadyCallback)invocation.getArguments()[1]).callback(AbstractTaskListPresenterTest.this.dataSetTaskVarMock);
                return null;
            }
        }).when((Object)this.dataSetQueryHelperDomainSpecific)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"userId");
    }

    protected abstract AbstractTaskListPresenter getPresenter();

    @Test
    public void getDataTest() {
        this.getPresenter().setAddingDefaultFilters(false);
        this.getPresenter().getData(new Range(0, 5));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastSortOrder(SortOrder.ASCENDING);
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).setLastOrderedColumn("createdOn");
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific, (VerificationMode)Mockito.never())).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
    }

    @Test
    public void releaseTaskTest() {
        TaskSummary task = TaskSummary.builder().id(TASK_ID).deploymentId(TASK_DEPLOYMENT_ID).build();
        this.getPresenter().releaseTask(task);
        ((TaskService)Mockito.verify((Object)this.taskService)).releaseTask("", TASK_DEPLOYMENT_ID, TASK_ID);
    }

    @Test
    public void claimTaskTest() {
        TaskSummary task = TaskSummary.builder().id(TASK_ID).deploymentId(TASK_DEPLOYMENT_ID).build();
        this.getPresenter().claimTask(task);
        ((TaskService)Mockito.verify((Object)this.taskService)).claimTask("", TASK_DEPLOYMENT_ID, TASK_ID);
    }

    @Test
    public void resumeTaskTest() {
        TaskSummary task = TaskSummary.builder().id(TASK_ID).deploymentId(TASK_DEPLOYMENT_ID).build();
        this.getPresenter().resumeTask(task);
        ((TaskService)Mockito.verify((Object)this.taskService)).resumeTask("", TASK_DEPLOYMENT_ID, TASK_ID);
    }

    @Test
    public void suspendTaskTest() {
        TaskSummary task = TaskSummary.builder().id(TASK_ID).deploymentId(TASK_DEPLOYMENT_ID).build();
        this.getPresenter().suspendTask(task);
        ((TaskService)Mockito.verify((Object)this.taskService)).suspendTask("", TASK_DEPLOYMENT_ID, TASK_ID);
    }

    @Test
    public void isFilteredByTaskNameTest() {
        String taskName = "taskName";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"name", (Comparable)((Object)"taskName"))});
        String filterTaskName = this.getPresenter().isFilteredByTaskName(Collections.singletonList(filter));
        Assert.assertEquals((Object)"taskName", (Object)filterTaskName);
    }

    @Test
    public void isFilteredByTaskNameInvalidTest() {
        String taskName = "taskName";
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.likeTo((String)"description", (String)"taskName")});
        String filterTaskName = this.getPresenter().isFilteredByTaskName(Collections.singletonList(filter));
        Assert.assertNull((Object)filterTaskName);
    }

    @Test
    public void testSkipDomainSpecificColumnsForSearchTab() {
        this.getPresenter().setAddingDefaultFilters(false);
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"name", (Comparable)((Object)"taskName"))});
        this.filterSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        this.filterSettings.setKey("base");
        Mockito.when((Object)this.filterSettings.getKey()).thenReturn((Object)"base");
        Mockito.when((Object)this.dataSetMock.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetMock.getValueAt(0, "taskId")).thenReturn((Object)1L);
        this.getPresenter().getData(new Range(0, 5));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.dataSetQueryHelperDomainSpecific});
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).hideBusyIndicator();
    }

    @Test
    public void getDomainSpecificDataForTasksTest() {
        this.getPresenter().setAddingDefaultFilters(false);
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{FilterFactory.equalsTo((String)"name", (Comparable)((Object)"taskName"))});
        this.filterSettings.getDataSetLookup().addOperation(new DataSetOp[]{filter});
        Mockito.when((Object)this.dataSetMock.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetMock.getValueAt(0, "taskId")).thenReturn((Object)1L);
        Mockito.when((Object)this.dataSetTaskVarMock.getRowCount()).thenReturn((Object)2);
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "taskId")).thenReturn((Object)1L);
        String taskVariable1 = "var1";
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "name")).thenReturn((Object)taskVariable1);
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "value")).thenReturn((Object)"value1");
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(1, "taskId")).thenReturn((Object)1L);
        String taskVariable2 = "var2";
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(1, "name")).thenReturn((Object)taskVariable2);
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(1, "value")).thenReturn((Object)"value2");
        Set<String> expectedColumns = new HashSet<String>();
        expectedColumns.add(taskVariable1);
        expectedColumns.add(taskVariable2);
        this.getPresenter().getData(new Range(0, 5));
        ArgumentCaptor argument = ArgumentCaptor.forClass(Set.class);
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock)).addDomainSpecifColumns((ExtendedPagedTable)Matchers.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals(expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific)).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        Mockito.when((Object)this.dataSetTaskVarMock.getRowCount()).thenReturn((Object)1);
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "taskId")).thenReturn((Object)1L);
        taskVariable1 = "varTest1";
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "name")).thenReturn((Object)taskVariable1);
        Mockito.when((Object)this.dataSetTaskVarMock.getValueAt(0, "value")).thenReturn((Object)"value1");
        expectedColumns = Collections.singleton(taskVariable1);
        this.getPresenter().getData(new Range(0, 5));
        argument = ArgumentCaptor.forClass(Set.class);
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock, (VerificationMode)Mockito.times((int)2))).addDomainSpecifColumns((ExtendedPagedTable)Matchers.any(ExtendedPagedTable.class), (Set)argument.capture());
        Assert.assertEquals(expectedColumns, (Object)argument.getValue());
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelper, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
        ((DataSetQueryHelper)Mockito.verify((Object)this.dataSetQueryHelperDomainSpecific, (VerificationMode)Mockito.times((int)2))).lookupDataSet(Integer.valueOf(Matchers.anyInt()), (DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
    }

    @Test
    public void testTaskSummaryAdmin() {
        List<String> dataSets = Arrays.asList("jbpmHumanTasksWithAdmin", "jbpmHumanTasksWithUser", "jbpmHumanTasks", "jbpmHumanTasksWithVariables");
        for (String dataSet : dataSets) {
            Mockito.when((Object)this.dataSetMock.getUUID()).thenReturn((Object)dataSet);
            TaskSummary summary = new TaskSummaryDataSetMapper().apply(this.dataSetMock, Integer.valueOf(0));
            Assert.assertNotNull((Object)summary);
            Assert.assertEquals((Object)"jbpmHumanTasksWithAdmin".equals(dataSet), (Object)summary.isForAdmin());
        }
    }

    @Test
    public void testGetUserGroupFilters() {
        Group group1 = new Group(){

            public String getName() {
                return "group1";
            }
        };
        Group group2 = new Group(){

            public String getName() {
                return "group2";
            }
        };
        HashSet<Object> groups = new HashSet<Object>();
        groups.add(group1);
        groups.add(group2);
        Mockito.when((Object)this.identity.getGroups()).thenReturn(groups);
        ColumnFilter userTaskFilter = this.getPresenter().getUserGroupFilters(false);
        List columnFilters = ((LogicalExprFilter)userTaskFilter).getLogicalTerms();
        Assert.assertEquals((long)columnFilters.size(), (long)2L);
        Assert.assertEquals((Object)((LogicalExprFilter)userTaskFilter).getLogicalOperator(), (Object)LogicalExprType.OR);
        Assert.assertEquals((Object)((LogicalExprFilter)columnFilters.get(0)).getLogicalOperator(), (Object)LogicalExprType.AND);
        List userGroupFilter = ((LogicalExprFilter)columnFilters.get(0)).getLogicalTerms();
        Assert.assertEquals((long)userGroupFilter.size(), (long)2L);
        Assert.assertEquals((Object)((LogicalExprFilter)userGroupFilter.get(0)).getLogicalOperator(), (Object)LogicalExprType.OR);
        List groupFilter = ((LogicalExprFilter)userGroupFilter.get(0)).getLogicalTerms();
        List withoutActualOwnerFilter = ((LogicalExprFilter)userGroupFilter.get(1)).getLogicalTerms();
        Assert.assertEquals((Object)((LogicalExprFilter)userGroupFilter.get(1)).getLogicalOperator(), (Object)LogicalExprType.OR);
        Assert.assertEquals((long)withoutActualOwnerFilter.size(), (long)2L);
        Assert.assertEquals((Object)"actualOwner", (Object)((ColumnFilter)withoutActualOwnerFilter.get(0)).getColumnId());
        Assert.assertEquals((Object)"actualOwner", (Object)((ColumnFilter)withoutActualOwnerFilter.get(1)).getColumnId());
        Assert.assertEquals((Object)((LogicalExprFilter)userGroupFilter.get(0)).getLogicalOperator(), (Object)LogicalExprType.OR);
        Assert.assertEquals((long)groupFilter.size(), (long)3L);
        Assert.assertEquals((Object)"id", (Object)((ColumnFilter)groupFilter.get(0)).getColumnId());
        Assert.assertEquals((Object)"id", (Object)((ColumnFilter)groupFilter.get(1)).getColumnId());
        Assert.assertEquals((Object)"id", (Object)((ColumnFilter)groupFilter.get(2)).getColumnId());
        ColumnFilter userOwnerFilter = (ColumnFilter)columnFilters.get(1);
        Assert.assertEquals((Object)userOwnerFilter.getColumnId(), (Object)"actualOwner");
    }

    @Test
    public void testMenus() {
        Menus menus = this.getPresenter().getMenus();
        Assert.assertEquals((long)4L, (long)menus.getItems().size());
    }

    @Test
    public void testDefaultActiveSearchFilters() {
        this.getPresenter().setupDefaultActiveSearchFilters();
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock)).addActiveFilter((String)Matchers.eq((Object)Constants.INSTANCE.Status()), (String)Matchers.eq((Object)TaskUtils.TASK_STATUS_READY), Matchers.eq((Object)TaskUtils.TASK_STATUS_READY), (Consumer)Matchers.any(Consumer.class));
    }

    @Test
    public void testIsNullTableSettingsPrototype() {
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user");
        this.getPresenter().setIdentity(this.identity);
        FilterSettings filterSettings = this.getPresenter().createTableSettingsPrototype();
        List ops = filterSettings.getDataSetLookup().getOperationList();
        for (DataSetOp op : ops) {
            if (!op.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List columnFilters = ((DataSetFilter)op).getColumnFilterList();
            for (ColumnFilter columnFilter : columnFilters) {
                Assert.assertTrue((boolean)columnFilter.toString().contains("actualOwner is_null"));
            }
        }
    }

    @Test
    public void getVariablesTableSettingsTest() {
        FilterSettings filterSettings = this.getPresenter().getVariablesTableSettings("Test");
        List ops = filterSettings.getDataSetLookup().getOperationList();
        for (DataSetOp op : ops) {
            if (!op.getType().equals((Object)DataSetOpType.FILTER)) continue;
            List columnFilters = ((DataSetFilter)op).getColumnFilterList();
            for (ColumnFilter columnFilter : columnFilters) {
                Assert.assertTrue((boolean)columnFilter.toString().contains("TASKNAME = Test"));
            }
        }
    }

    @Test
    public void testDatasetName() {
        Assert.assertEquals((Object)this.getDataSetId(), (Object)this.getPresenter().createTableSettingsPrototype().getDataSetLookup().getDataSetUUID());
    }

    @Test
    public void testCompleteActionCondition() {
        Assert.assertTrue((boolean)this.getPresenter().getCompleteActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskUtils.TASK_STATUS_IN_PROGRESS).build()));
        Assert.assertFalse((boolean)this.getPresenter().getCompleteActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskUtils.TASK_STATUS_READY).build()));
    }

    @Test
    public void testClaimActionCondition() {
        AbstractTaskListPresenterTest.testTaskStatusCondition(this.getPresenter().getClaimActionCondition(), TaskUtils.TASK_STATUS_READY);
    }

    @Test
    public void testReleaseActionCondition() {
        Assert.assertTrue((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskUtils.TASK_STATUS_RESERVED).build()));
        Assert.assertTrue((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskUtils.TASK_STATUS_IN_PROGRESS).build()));
        Assert.assertFalse((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskUtils.TASK_STATUS_COMPLETED).build()));
        Assert.assertFalse((boolean)this.getPresenter().getReleaseActionCondition().test(TaskSummary.builder().actualOwner(this.identity.getIdentifier()).status(TaskUtils.TASK_STATUS_CREATED).build()));
    }

    @Test
    public void testProcessInstanceCondition() {
        Assert.assertTrue((boolean)this.getPresenter().getProcessInstanceCondition().test(TaskSummary.builder().processInstanceId(Long.valueOf(1L)).build()));
        Assert.assertFalse((boolean)this.getPresenter().getProcessInstanceCondition().test(TaskSummary.builder().build()));
    }

    @Test
    public void testCreateDataSetTaskCallback() {
        AbstractTaskListPresenter presenter = (AbstractTaskListPresenter)Mockito.spy((Object)this.getPresenter());
        ClientRuntimeError error = new ClientRuntimeError("");
        FilterSettings filterSettings = (FilterSettings)Mockito.mock(FilterSettings.class);
        DataSetReadyCallback callback = presenter.createDataSetTaskCallback(0, filterSettings);
        ((AbstractTaskListPresenter)Mockito.doNothing().when((Object)presenter)).showErrorPopup((String)Matchers.any());
        Assert.assertFalse((boolean)callback.onError(error));
        ((TaskListViewImpl)Mockito.verify((Object)this.viewMock)).hideBusyIndicator();
        ((AbstractTaskListPresenter)Mockito.verify((Object)presenter)).showErrorPopup(Constants.INSTANCE.TaskListCouldNotBeLoaded());
    }

    @Test
    public void testStatusSettingsColumns() {
        String dataSetId = "dataSetId";
        FilterSettings settings = this.getPresenter().createStatusSettings("dataSetId", null);
        Assert.assertEquals((Object)"dataSetId", (Object)settings.getDataSetLookup().getDataSetUUID());
        this.getDataSetExpectedColumns().forEach(c -> Assert.assertNotNull((Object)settings.getColumnSettings(c)));
    }

    protected List<String> getDataSetExpectedColumns() {
        return Arrays.asList("activationTime", "actualOwner", "createdBy", "createdOn", TASK_DEPLOYMENT_ID, "description", "dueDate", "name", "parentId", "priority", "processId", "processInstanceId", "processSessionId", "status", "taskId", "workItemId", "lastModificationDate", "correlationKey", "processInstanceDescription");
    }
}

