/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.workbench.ht.util.TaskStatus;

public class TaskUtils {
    public static List<TaskStatus> getTaskStatusByType(TaskType type) {
        ImmutableList status = null;
        switch (type) {
            case ACTIVE: {
                status = ImmutableList.of((Object)TaskStatus.TASK_STATUS_READY, (Object)TaskStatus.TASK_STATUS_RESERVED, (Object)TaskStatus.TASK_STATUS_IN_PROGRESS);
                break;
            }
            case GROUP: {
                status = ImmutableList.of((Object)TaskStatus.TASK_STATUS_READY);
                break;
            }
            case ALL: {
                status = ImmutableList.of((Object)TaskStatus.TASK_STATUS_CREATED, (Object)TaskStatus.TASK_STATUS_READY, (Object)TaskStatus.TASK_STATUS_RESERVED, (Object)TaskStatus.TASK_STATUS_IN_PROGRESS, (Object)TaskStatus.TASK_STATUS_SUSPENDED, (Object)TaskStatus.TASK_STATUS_FAILED, (Object)TaskStatus.TASK_STATUS_ERROR, (Object)TaskStatus.TASK_STATUS_EXITED, (Object)TaskStatus.TASK_STATUS_OBSOLETE, (Object)TaskStatus.TASK_STATUS_COMPLETED);
                break;
            }
            case PERSONAL: {
                status = ImmutableList.of((Object)TaskStatus.TASK_STATUS_IN_PROGRESS, (Object)TaskStatus.TASK_STATUS_CREATED, (Object)TaskStatus.TASK_STATUS_RESERVED);
                break;
            }
            case ADMIN: {
                status = ImmutableList.of((Object)TaskStatus.TASK_STATUS_READY, (Object)TaskStatus.TASK_STATUS_IN_PROGRESS, (Object)TaskStatus.TASK_STATUS_CREATED, (Object)TaskStatus.TASK_STATUS_RESERVED, (Object)TaskStatus.TASK_STATUS_SUSPENDED);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized view type '" + (Object)((Object)type) + "'!");
            }
        }
        return Lists.newArrayList((Iterable)status);
    }

    public static List<String> getStatusByType(TaskType type) {
        return TaskUtils.getTaskStatusByType(type).stream().map(s -> s.getIdentifier()).collect(Collectors.toList());
    }

    public static enum TaskType {
        PERSONAL,
        ACTIVE,
        GROUP,
        ALL,
        ADMIN;

    }
}

