/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import java.util.List;
import java.util.function.Consumer;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jbpm.workbench.common.client.util.DateUtils;
import org.jbpm.workbench.df.client.filter.FilterSettings;
import org.jbpm.workbench.df.client.filter.FilterSettingsBuilderHelper;
import org.jbpm.workbench.df.client.filter.FilterSettingsManagerImpl;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;

public abstract class AbstractTaskListFilterSettingsManager
extends FilterSettingsManagerImpl {
    protected Constants constants = Constants.INSTANCE;

    protected Consumer<FilterSettingsBuilderHelper> commonColumnSettings() {
        return builder -> {
            builder.setColumn("activationTime", this.constants.ActivationTime(), DateUtils.getDateTimeFormatMask());
            builder.setColumn("actualOwner", this.constants.Actual_Owner());
            builder.setColumn("createdBy", this.constants.CreatedBy());
            builder.setColumn("createdOn", this.constants.Created_On(), DateUtils.getDateTimeFormatMask());
            builder.setColumn("deploymentId", this.constants.DeploymentId());
            builder.setColumn("description", this.constants.Description());
            builder.setColumn("dueDate", this.constants.DueDate(), DateUtils.getDateTimeFormatMask());
            builder.setColumn("name", this.constants.Task());
            builder.setColumn("parentId", this.constants.ParentId());
            builder.setColumn("priority", this.constants.Priority());
            builder.setColumn("processId", this.constants.Process_Definition_Id());
            builder.setColumn("processInstanceId", this.constants.Process_Instance_Id());
            builder.setColumn("processSessionId", this.constants.ProcessSessionId());
            builder.setColumn("status", this.constants.Status());
            builder.setColumn("taskId", this.constants.Id());
            builder.setColumn("workItemId", this.constants.WorkItemId());
            builder.setColumn("lastModificationDate", this.constants.Last_Modification_Date());
            builder.setColumn("correlationKey", this.constants.Process_Instance_Correlation_Key());
            builder.setColumn("processInstanceDescription", this.constants.Process_Instance_Description());
            builder.setColumn("slaCompliance", this.constants.SlaCompliance());
            builder.setColumn("sla_due_date", this.constants.SlaDueDate());
        };
    }

    public FilterSettings getVariablesFilterSettings(List<Long> taskIds) {
        FilterSettingsBuilderHelper builder = FilterSettingsBuilderHelper.init();
        builder.initBuilder();
        builder.dataset("jbpmHumanTasksWithVariables");
        builder.filter(new ColumnFilter[]{FilterFactory.in((String)"taskId", taskIds)});
        builder.filterOn(true, true, true);
        builder.tableOrderEnabled(true);
        builder.tableOrderDefault("taskId", SortOrder.ASCENDING);
        FilterSettings varTableSettings = builder.buildSettings();
        varTableSettings.setTablePageSize(-1);
        return varTableSettings;
    }
}

