/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskadmin;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collections;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenter;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenterTest;
import org.jbpm.workbench.ht.client.editors.taskadmin.TaskAdminPresenter;
import org.jbpm.workbench.ht.client.resources.i18n.Constants;
import org.jbpm.workbench.ht.model.TaskAssignmentSummary;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskAdminPresenterTest
extends AbstractTaskPresenterTest {
    private static final String CURRENT_USER = "Jan";
    private static final String OTHER_USER = "OTHER_USER";
    private static final String OTHER_USER2 = "OTHER_USER2";
    @Mock
    TaskAdminPresenter.TaskAdminView viewMock;
    @Mock
    TaskService taskService;
    Caller<TaskService> remoteTaskServiceCaller;
    @Spy
    Event<TaskRefreshedEvent> taskRefreshed = new EventSourceMock();
    @Spy
    Event<NotificationEvent> notification = new EventSourceMock();
    @InjectMocks
    TaskAdminPresenter presenter;

    @Override
    public AbstractTaskPresenter getPresenter() {
        return this.presenter;
    }

    @Before
    public void initMocks() {
        this.remoteTaskServiceCaller = new CallerMock((Object)this.taskService);
        ((Event)Mockito.doNothing().when(this.taskRefreshed)).fire(Mockito.any());
        ((Event)Mockito.doNothing().when(this.notification)).fire(Mockito.any());
        this.presenter.setTaskService(this.remoteTaskServiceCaller);
    }

    @Test
    public void taskSelectionEventIsForLogTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        TaskAssignmentSummary ts = new TaskAssignmentSummary();
        ts.setPotOwnersString(Arrays.asList("owner1", "owner2"));
        Mockito.when((Object)this.taskService.getTaskAssignmentDetails((String)Mockito.eq((Object)serverTemplateId), (String)Mockito.eq((Object)containerId), (Long)Mockito.eq((Object)taskId))).thenReturn((Object)ts);
        boolean isForLog = true;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog));
        this.presenter.onTaskSelectionEvent(event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskService});
    }

    @Test
    public void taskSelectionEventNotIsForLogTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        TaskAssignmentSummary ts = new TaskAssignmentSummary();
        ts.setPotOwnersString(Arrays.asList(OTHER_USER, OTHER_USER2));
        ts.setActualOwner(CURRENT_USER);
        ts.setForwardAllowed(Boolean.valueOf(true));
        Mockito.when((Object)this.taskService.getTaskAssignmentDetails((String)Mockito.eq((Object)serverTemplateId), (String)Mockito.eq((Object)containerId), (Long)Mockito.eq((Object)taskId))).thenReturn((Object)ts);
        boolean isForLog = false;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog));
        this.presenter.onTaskSelectionEvent(event);
        ((TaskService)Mockito.verify((Object)this.taskService)).getTaskAssignmentDetails(serverTemplateId, containerId, taskId);
        ((TaskAdminPresenter.TaskAdminView)Mockito.verify((Object)this.viewMock)).enableForwardButton(true);
        ((TaskAdminPresenter.TaskAdminView)Mockito.verify((Object)this.viewMock)).enableUserOrGroupText(true);
        ((TaskAdminPresenter.TaskAdminView)Mockito.verify((Object)this.viewMock)).enableReminderButton(true);
        ((TaskAdminPresenter.TaskAdminView)Mockito.verify((Object)this.viewMock)).setActualOwnerText(CURRENT_USER);
        ((TaskAdminPresenter.TaskAdminView)Mockito.verify((Object)this.viewMock)).setUsersGroupsControlsPanelText(Arrays.asList(OTHER_USER, OTHER_USER2));
    }

    @Test
    public void testForwardTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        String entity = "user";
        TaskSelectionEvent event = new TaskSelectionEvent("serverTemplateId", "containerId", taskId, "task", Boolean.valueOf(true), Boolean.valueOf(false));
        this.presenter.onTaskSelectionEvent(event);
        this.presenter.forwardTask("user");
        ((TaskService)Mockito.verify((Object)this.taskService)).forward("serverTemplateId", "containerId", taskId, "user");
        ((Event)Mockito.verify(this.notification)).fire(Mockito.any());
        ((Event)Mockito.verify(this.taskRefreshed)).fire(Mockito.any());
    }

    @Test
    public void testRefreshTaskPotentialOwners() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        TaskSelectionEvent event = new TaskSelectionEvent("serverTemplateId", "containerId", taskId, "task", Boolean.valueOf(true), Boolean.valueOf(false));
        TaskAssignmentSummary summary = new TaskAssignmentSummary();
        summary.setForwardAllowed(Boolean.valueOf(false));
        Mockito.when((Object)this.taskService.getTaskAssignmentDetails("serverTemplateId", "containerId", taskId)).thenReturn((Object)summary);
        this.presenter.onTaskSelectionEvent(event);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.viewMock});
        ((TaskAdminPresenter.TaskAdminView)inOrder.verify((Object)this.viewMock)).enableReminderButton(false);
        ((TaskAdminPresenter.TaskAdminView)inOrder.verify((Object)this.viewMock)).enableForwardButton(false);
        ((TaskAdminPresenter.TaskAdminView)inOrder.verify((Object)this.viewMock)).enableUserOrGroupText(false);
        ((TaskAdminPresenter.TaskAdminView)inOrder.verify((Object)this.viewMock)).setUsersGroupsControlsPanelText(Collections.emptyList());
        ((TaskAdminPresenter.TaskAdminView)inOrder.verify((Object)this.viewMock)).clearUserOrGroupText();
        ((TaskAdminPresenter.TaskAdminView)inOrder.verify((Object)this.viewMock)).setActualOwnerText("");
        ((TaskAdminPresenter.TaskAdminView)inOrder.verify((Object)this.viewMock)).setUsersGroupsControlsPanelText(Collections.singletonList(Constants.INSTANCE.No_Potential_Owners()));
        ((TaskAdminPresenter.TaskAdminView)inOrder.verify((Object)this.viewMock)).enableForwardButton(false);
        ((TaskAdminPresenter.TaskAdminView)inOrder.verify((Object)this.viewMock)).enableUserOrGroupText(false);
        ((TaskAdminPresenter.TaskAdminView)inOrder.verify((Object)this.viewMock)).enableReminderButton(false);
        ((TaskAdminPresenter.TaskAdminView)inOrder.verify((Object)this.viewMock)).setActualOwnerText(Constants.INSTANCE.No_Actual_Owner());
    }
}

