/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskadmin;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.ht.client.editors.taskadmin.TaskAdminPresenter;
import org.jbpm.workbench.ht.model.TaskAssignmentSummary;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskAdminPresenterTest {
    private static final String CURRENT_USER = "Jan";
    private static final String OTHER_USER = "OTHER_USER";
    private static final String OTHER_USER2 = "OTHER_USER2";
    @Mock
    private TaskAdminPresenter.TaskAdminView viewMock;
    @Mock
    private TaskService taskService;
    private Caller<TaskService> remoteTaskServiceCaller;
    @Mock
    private EventSourceMock<TaskRefreshedEvent> taskRefreshedEvent;
    private TaskAdminPresenter presenter;

    @Before
    public void initMocks() {
        this.remoteTaskServiceCaller = new CallerMock((Object)this.taskService);
        ((EventSourceMock)Mockito.doNothing().when(this.taskRefreshedEvent)).fire(Mockito.any(TaskRefreshedEvent.class));
        this.presenter = new TaskAdminPresenter(this.viewMock, this.remoteTaskServiceCaller, this.taskRefreshedEvent);
    }

    @Test
    public void taskSelectionEventIsForLogTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        TaskAssignmentSummary ts = new TaskAssignmentSummary();
        ts.setPotOwnersString(Arrays.asList("owner1", "owner2"));
        Mockito.when((Object)this.taskService.getTaskAssignmentDetails((String)Mockito.eq((Object)serverTemplateId), (String)Mockito.eq((Object)containerId), (Long)Mockito.eq((Object)taskId))).thenReturn((Object)ts);
        boolean isForLog = true;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog));
        this.presenter.onTaskSelectionEvent(event);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskService});
    }

    @Test
    public void taskSelectionEventNotIsForLogTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        TaskAssignmentSummary ts = new TaskAssignmentSummary();
        ts.setPotOwnersString(Arrays.asList(OTHER_USER, OTHER_USER2));
        ts.setActualOwner(CURRENT_USER);
        Mockito.when((Object)this.taskService.getTaskAssignmentDetails((String)Mockito.eq((Object)serverTemplateId), (String)Mockito.eq((Object)containerId), (Long)Mockito.eq((Object)taskId))).thenReturn((Object)ts);
        boolean isForLog = false;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog));
        this.presenter.onTaskSelectionEvent(event);
        ((TaskService)Mockito.verify((Object)this.taskService)).getTaskAssignmentDetails(serverTemplateId, containerId, taskId);
        ((TaskAdminPresenter.TaskAdminView)Mockito.verify((Object)this.viewMock)).enableForwardButton(true);
        ((TaskAdminPresenter.TaskAdminView)Mockito.verify((Object)this.viewMock)).enableUserOrGroupText(true);
        ((TaskAdminPresenter.TaskAdminView)Mockito.verify((Object)this.viewMock)).enableReminderButton(true);
        ((TaskAdminPresenter.TaskAdminView)Mockito.verify((Object)this.viewMock)).setActualOwnerText(CURRENT_USER);
        ((TaskAdminPresenter.TaskAdminView)Mockito.verify((Object)this.viewMock)).setUsersGroupsControlsPanelText("[OTHER_USER, OTHER_USER2]");
    }

    @Test
    public void testForwardTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        String entity = "user";
        TaskSelectionEvent event = new TaskSelectionEvent("serverTemplateId", "containerId", taskId, "task", Boolean.valueOf(true), Boolean.valueOf(false));
        this.presenter.onTaskSelectionEvent(event);
        this.presenter.forwardTask("user");
        ((TaskService)Mockito.verify((Object)this.taskService)).forward("serverTemplateId", "containerId", taskId, "user");
    }
}

