/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskslist;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.List;
import org.jbpm.workbench.common.client.list.ExtendedPagedTable;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListView;
import org.jbpm.workbench.ht.client.editors.taskslist.AbstractTaskListViewTest;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskListPresenter;
import org.jbpm.workbench.ht.client.editors.taskslist.TaskListViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.widgets.common.client.tables.FilterPagedTable;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskListViewImplTest
extends AbstractTaskListViewTest {
    @InjectMocks
    @Spy
    private TaskListViewImpl view;
    @Mock
    private TaskListPresenter presenter;

    @Override
    public AbstractTaskListView getView() {
        return this.view;
    }

    @Override
    public AbstractTaskListPresenter getPresenter() {
        return this.presenter;
    }

    public List<String> getExpectedTabs() {
        return Arrays.asList("base", "DataSetTaskListGrid_3", "DataSetTaskListGrid_2", "DataSetTaskListGrid_1", "DataSetTaskListGrid_0");
    }

    @Before
    public void setupMocks() {
        super.setupMocks();
        Mockito.when((Object)this.presenter.createActiveTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createAllTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createGroupTabSettings()).thenReturn((Object)this.filterSettings);
        Mockito.when((Object)this.presenter.createPersonalTabSettings()).thenReturn((Object)this.filterSettings);
    }

    @Test
    public void testLoadPreferencesRemovingAdminTab() {
        MultiGridPreferencesStore pref = new MultiGridPreferencesStore();
        pref.getGridsId().add("DataSetTaskListGrid_3");
        pref.getGridsId().add("DataSetTaskListGrid_2");
        pref.getGridsId().add("DataSetTaskListGrid_1");
        pref.getGridsId().add("DataSetTaskListGrid_0");
        pref.getGridsId().add("DataSetTaskListGrid_4");
        this.view.loadTabsFromPreferences(pref, this.presenter);
        Assert.assertFalse((boolean)pref.getGridsId().contains("DataSetTaskListGrid_4"));
        this.assertTabAdded(new String[]{"base", "DataSetTaskListGrid_3", "DataSetTaskListGrid_2", "DataSetTaskListGrid_1", "DataSetTaskListGrid_0"});
        ((FilterPagedTable)Mockito.verify((Object)this.filterPagedTable, (VerificationMode)Mockito.never())).addTab((PagedTable)Mockito.any(ExtendedPagedTable.class), (String)Mockito.eq((Object)"DataSetTaskListGrid_4"), (Command)Mockito.any(Command.class), Mockito.eq((boolean)false));
    }
}

