/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.taskcomments;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.enterprise.event.Event;
import org.jboss.errai.security.shared.api.identity.User;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenterTest;
import org.jbpm.workbench.ht.client.editors.taskcomments.TaskCommentsPresenter;
import org.jbpm.workbench.ht.model.CommentSummary;
import org.jbpm.workbench.ht.model.events.TaskCompletedEvent;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskCommentsPresenterTest
extends AbstractTaskPresenterTest {
    @Mock
    private TaskCommentsPresenter.TaskCommentsView viewMock;
    @InjectMocks
    private TaskCommentsPresenter presenter;
    private static final Long TASK_ID = 1L;
    private static final Long COMMENT_ID = 1L;
    private static final String COMMENT_1_TEXT = "Comment1";
    private static final String COMMENT_2_TEXT = "Comment2";
    private static final String COMMENT_3_TEXT = "Comment3";
    protected CallerMock<TaskService> callerMock;
    @Mock
    protected TaskService commentsService;
    @Mock
    private User identity;
    @Spy
    Event<NotificationEvent> notificationEventMock = new EventSourceMock();

    public TaskCommentsPresenter getPresenter() {
        return this.presenter;
    }

    @Before
    public void setupMocks() {
        this.callerMock = new CallerMock((Object)this.commentsService);
        this.getPresenter().setNotification(this.notificationEventMock);
        this.getPresenter().setTaskService(this.callerMock);
        this.getPresenter().setIdentity(this.identity);
        long currentTime = new Date().getTime();
        CommentSummary commentSummary1 = new CommentSummary(Long.valueOf(1L), COMMENT_1_TEXT, "user1", new Date(currentTime + 200000L));
        CommentSummary commentSummary2 = new CommentSummary(Long.valueOf(2L), COMMENT_2_TEXT, "user1", new Date(currentTime + 400000L));
        CommentSummary commentSummary3 = new CommentSummary(Long.valueOf(3L), COMMENT_3_TEXT, "user1", new Date(currentTime + 600000L));
        Mockito.when((Object)this.commentsService.getTaskComments((String)Matchers.any(), (String)Matchers.any(), (Long)Matchers.any())).thenReturn(Arrays.asList(commentSummary1, commentSummary2, commentSummary3));
        ((Event)Mockito.doNothing().when(this.notificationEventMock)).fire(Matchers.any());
    }

    @Test
    public void loadCommentsOnTaskSelectedOrRefreshed() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        boolean isForLog = false;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, TASK_ID, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog), "description", new Date(), "Ready", "actualOwner", Integer.valueOf(2), Long.valueOf(1L), "processId");
        this.getPresenter().onTaskSelectionEvent(event);
        ((TaskService)Mockito.verify((Object)this.commentsService)).getTaskComments(serverTemplateId, containerId, TASK_ID);
        this.getPresenter().onTaskRefreshedEvent(new TaskRefreshedEvent(serverTemplateId, containerId, TASK_ID));
        ((TaskService)Mockito.verify((Object)this.commentsService, (VerificationMode)Mockito.times((int)2))).getTaskComments(serverTemplateId, containerId, TASK_ID);
    }

    @Test
    public void loadCommentsSortingASC() {
        this.getPresenter().sortComments(true);
        ArgumentCaptor comentsListASC = ArgumentCaptor.forClass(List.class);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).setCommentList((List)comentsListASC.capture());
        Assert.assertEquals((long)3L, (long)((List)comentsListASC.getValue()).size());
        Assert.assertEquals((Object)COMMENT_1_TEXT, (Object)((CommentSummary)((List)comentsListASC.getValue()).get(0)).getText());
        Assert.assertEquals((Object)COMMENT_2_TEXT, (Object)((CommentSummary)((List)comentsListASC.getValue()).get(1)).getText());
        Assert.assertEquals((Object)COMMENT_3_TEXT, (Object)((CommentSummary)((List)comentsListASC.getValue()).get(2)).getText());
    }

    @Test
    public void loadCommentsSortingDESC() {
        this.getPresenter().sortComments(false);
        ArgumentCaptor comentsListASC = ArgumentCaptor.forClass(List.class);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).setCommentList((List)comentsListASC.capture());
        Assert.assertEquals((long)3L, (long)((List)comentsListASC.getValue()).size());
        Assert.assertEquals((Object)COMMENT_3_TEXT, (Object)((CommentSummary)((List)comentsListASC.getValue()).get(0)).getText());
        Assert.assertEquals((Object)COMMENT_2_TEXT, (Object)((CommentSummary)((List)comentsListASC.getValue()).get(1)).getText());
        Assert.assertEquals((Object)COMMENT_1_TEXT, (Object)((CommentSummary)((List)comentsListASC.getValue()).get(2)).getText());
    }

    @Test
    public void refreshCommentsResetsCurrentPageTest() {
        this.getPresenter().setCurrentPage(3);
        this.getPresenter().refreshCommentsView();
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).clearCommentInputForm();
        ((TaskService)Mockito.verify((Object)this.commentsService)).getTaskComments((String)Matchers.any(), (String)Matchers.any(), (Long)Matchers.any());
        Assert.assertEquals((long)1L, (long)this.getPresenter().getCurrentPage());
    }

    @Test
    public void loadMoreCommentsIncreaseCurrentPageTest() {
        int currentPage = 2;
        this.getPresenter().setCurrentPage(currentPage);
        this.getPresenter().loadMoreTaskComments();
        ((TaskService)Mockito.verify((Object)this.commentsService)).getTaskComments((String)Matchers.any(), (String)Matchers.any(), (Long)Matchers.any());
        Assert.assertEquals((long)(currentPage + 1), (long)this.getPresenter().getCurrentPage());
    }

    @Test
    public void commentInputClearedAfterCommentAddedTest() {
        String comment = "Working on it, man.";
        this.getPresenter().addTaskComment(comment);
        ((TaskService)Mockito.verify((Object)this.commentsService)).addTaskComment((String)Matchers.any(), (String)Matchers.any(), (Long)Matchers.any(), (String)Matchers.eq((Object)comment), (Date)Matchers.any(Date.class));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).clearCommentInputForm();
    }

    @Test
    public void removeCommentAddedTest() {
        this.getPresenter().removeTaskComment(COMMENT_ID.longValue());
        ((TaskService)Mockito.verify((Object)this.commentsService)).deleteTaskComment((String)Matchers.any(), (String)Matchers.any(), (Long)Matchers.any(), (Long)Matchers.eq((Object)COMMENT_ID));
        ((TaskService)Mockito.verify((Object)this.commentsService)).getTaskComments((String)Matchers.any(), (String)Matchers.any(), (Long)Matchers.any());
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).clearCommentInputForm();
        Assert.assertEquals((long)1L, (long)this.getPresenter().getCurrentPage());
    }

    @Test
    public void taskSelectionEventIsForLogTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        boolean isForLog = true;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog));
        CommentSummary comment1 = new CommentSummary(Long.valueOf(1L), "commentText", "ByTest", new Date());
        Mockito.when((Object)this.commentsService.getTaskComments((String)Matchers.eq((Object)serverTemplateId), (String)Matchers.eq((Object)containerId), (Long)Matchers.eq((Object)taskId))).thenReturn(Arrays.asList(comment1));
        this.getPresenter().onTaskSelectionEvent(event);
        ((TaskService)Mockito.verify((Object)this.commentsService)).getTaskComments(serverTemplateId, containerId, taskId);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).disableNewComments();
    }

    @Test
    public void taskSelectionEventNotIsForLogTask() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        Long taskId = 1L;
        boolean isForLog = false;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, taskId, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog));
        CommentSummary comment1 = new CommentSummary(Long.valueOf(1L), "commentText", "ByTest", new Date());
        Mockito.when((Object)this.commentsService.getTaskComments((String)Matchers.eq((Object)serverTemplateId), (String)Matchers.eq((Object)containerId), (Long)Matchers.eq((Object)taskId))).thenReturn(Arrays.asList(comment1));
        this.getPresenter().onTaskSelectionEvent(event);
        ((TaskService)Mockito.verify((Object)this.commentsService)).getTaskComments(serverTemplateId, containerId, taskId);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView(), (VerificationMode)Mockito.never())).disableNewComments();
    }

    @Test
    public void testDeleteCommentConditionForLog() {
        TaskSelectionEvent event = new TaskSelectionEvent("serverTemplateId", "containerId", Long.valueOf(1L), "task", Boolean.valueOf(true), Boolean.valueOf(true));
        this.getPresenter().onTaskSelectionEvent(event);
        String addedBy = "user1";
        CommentSummary comment1 = new CommentSummary(Long.valueOf(1L), "commentText", "user1", new Date());
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user1");
        Assert.assertFalse((boolean)this.getPresenter().getDeleteCondition().test(comment1));
    }

    @Test
    public void testDeleteCommentConditionForAdmin() {
        TaskSelectionEvent event = new TaskSelectionEvent("serverTemplateId", "containerId", Long.valueOf(1L), "task", Boolean.valueOf(true), Boolean.valueOf(false));
        this.getPresenter().onTaskSelectionEvent(event);
        String addedBy = "user1";
        CommentSummary comment1 = new CommentSummary(Long.valueOf(1L), "commentText", "user1", new Date());
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user2");
        Assert.assertTrue((boolean)this.getPresenter().getDeleteCondition().test(comment1));
    }

    @Test
    public void testDeleteCommentConditionForUser() {
        TaskSelectionEvent event = new TaskSelectionEvent("serverTemplateId", "containerId", Long.valueOf(1L), "task", Boolean.valueOf(false), Boolean.valueOf(false));
        this.getPresenter().onTaskSelectionEvent(event);
        String addedBy = "user1";
        CommentSummary comment1 = new CommentSummary(Long.valueOf(1L), "commentText", "user1", new Date());
        Mockito.when((Object)this.identity.getIdentifier()).thenReturn((Object)"user1", (Object[])new String[]{"user2"});
        Assert.assertTrue((boolean)this.getPresenter().getDeleteCondition().test(comment1));
        Assert.assertFalse((boolean)this.getPresenter().getDeleteCondition().test(comment1));
    }

    @Test
    public void completeTaskHideAddCommentTest() {
        String serverTemplateId = "serverTemplateId";
        String containerId = "containerId";
        boolean isForLog = false;
        TaskSelectionEvent event = new TaskSelectionEvent(serverTemplateId, containerId, TASK_ID, "task", Boolean.valueOf(true), Boolean.valueOf(isForLog), "description", new Date(), "Ready", "actualOwner", Integer.valueOf(2), Long.valueOf(1L), "processId");
        this.getPresenter().onTaskSelectionEvent(event);
        ((TaskService)Mockito.verify((Object)this.commentsService)).getTaskComments(serverTemplateId, containerId, TASK_ID);
        this.getPresenter().onTaskCompletedEvent(new TaskCompletedEvent(serverTemplateId, containerId, TASK_ID));
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).disableNewComments();
    }

    protected void createTaskCommentsResults(int numberOfComments) {
        ArrayList<CommentSummary> comments = new ArrayList<CommentSummary>();
        long id = 1L;
        long currentTime = new Date().getTime();
        for (int i = 0; i < numberOfComments; ++i) {
            comments.add(new CommentSummary(Long.valueOf(id + (long)i), "comment" + i, "user", new Date(currentTime + (long)(i * 200000))));
        }
        Mockito.when((Object)this.commentsService.getTaskComments((String)Matchers.any(), (String)Matchers.any(), (Long)Matchers.any())).thenReturn(comments);
    }

    @Test
    public void showLoadMoreButtonTest() {
        this.createTaskCommentsResults(this.getPresenter().getPageSize() + 5);
        this.getPresenter().refreshCommentsView();
        ArgumentCaptor comentsListASC = ArgumentCaptor.forClass(List.class);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).setCommentList((List)comentsListASC.capture());
        Assert.assertEquals((long)this.getPresenter().getPageSize(), (long)((List)comentsListASC.getValue()).size());
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).showLoadButton();
    }

    @Test
    public void hideLoadMoreButtonTest() {
        this.createTaskCommentsResults(this.getPresenter().getPageSize());
        this.getPresenter().refreshCommentsView();
        ArgumentCaptor comentsListASC = ArgumentCaptor.forClass(List.class);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).setCommentList((List)comentsListASC.capture());
        Assert.assertEquals((long)this.getPresenter().getPageSize(), (long)((List)comentsListASC.getValue()).size());
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).hideLoadButton();
    }

    @Test
    public void hideLoadMoreButtonLessItemsThanPageSizeTest() {
        this.createTaskCommentsResults(this.getPresenter().getPageSize() - 2);
        this.getPresenter().refreshCommentsView();
        ArgumentCaptor comentsListASC = ArgumentCaptor.forClass(List.class);
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).setCommentList((List)comentsListASC.capture());
        Assert.assertEquals((long)(this.getPresenter().getPageSize() - 2), (long)((List)comentsListASC.getValue()).size());
        ((TaskCommentsPresenter.TaskCommentsView)Mockito.verify((Object)this.getPresenter().getTaskCommentView())).hideLoadButton();
    }
}

