/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.ht.client.editors.tasklogs;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jboss.errai.common.client.api.Caller;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenter;
import org.jbpm.workbench.ht.client.editors.AbstractTaskPresenterTest;
import org.jbpm.workbench.ht.client.editors.tasklogs.TaskLogsPresenter;
import org.jbpm.workbench.ht.model.TaskEventSummary;
import org.jbpm.workbench.ht.model.events.TaskRefreshedEvent;
import org.jbpm.workbench.ht.model.events.TaskSelectionEvent;
import org.jbpm.workbench.ht.service.TaskService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class TaskLogsPresenterTest
extends AbstractTaskPresenterTest {
    private static final Long TASK_ID = 1L;
    private static String serverTemplateId = "serverTemplateId";
    private static String containerId = "containerId";
    @Mock
    private TaskService taskService;
    private Caller<TaskService> remoteTaskServiceCaller;
    @Mock
    private TaskLogsPresenter.TaskLogsView taskLogsView;
    @InjectMocks
    private TaskLogsPresenter presenter;

    @Override
    public AbstractTaskPresenter getPresenter() {
        return this.presenter;
    }

    @Before
    public void setupMocks() {
        this.remoteTaskServiceCaller = new CallerMock((Object)this.taskService);
        this.presenter = new TaskLogsPresenter(this.taskLogsView, this.remoteTaskServiceCaller);
        Mockito.when((Object)this.taskService.getTaskEvents(serverTemplateId, containerId, TASK_ID, Integer.valueOf(0), Integer.valueOf(10))).thenReturn(this.createEventSummariesForTask(TASK_ID));
    }

    @Test
    public void logsUpdatedWhenTaskSelected() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(serverTemplateId, containerId, TASK_ID));
        ((TaskService)Mockito.verify((Object)this.taskService)).getTaskEvents(serverTemplateId, containerId, TASK_ID, Integer.valueOf(0), Integer.valueOf(10));
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView)).setLogs((List)argumentDESC.capture());
        Assert.assertEquals((long)3L, (long)((List)argumentDESC.getValue()).size());
    }

    @Test
    public void logsUpdatedWhenTaskRefreshed() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent("", "", TASK_ID));
        this.presenter.onTaskRefreshedEvent(new TaskRefreshedEvent("", "", TASK_ID));
        ((TaskService)Mockito.verify((Object)this.taskService, (VerificationMode)Mockito.times((int)2))).getTaskEvents(Mockito.anyString(), Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()));
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView, (VerificationMode)Mockito.times((int)2))).setLogs(Collections.emptyList());
    }

    @Test
    public void logsNotUpdatedWhenDifferentTaskRefreshed() {
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent("", "", TASK_ID));
        this.presenter.onTaskRefreshedEvent(new TaskRefreshedEvent("", "", Long.valueOf(TASK_ID + 1L)));
        ((TaskService)Mockito.verify((Object)this.taskService)).getTaskEvents(Mockito.anyString(), Mockito.anyString(), Long.valueOf(Mockito.anyLong()), Integer.valueOf(Mockito.anyInt()), Integer.valueOf(Mockito.anyInt()));
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView)).setLogs(Collections.emptyList());
    }

    @Test
    public void loadMoreLogs() {
        ArrayList<TaskEventSummary> allLogs = new ArrayList<TaskEventSummary>();
        int testAllLogsSize = 12;
        for (int i = 0; i < testAllLogsSize; ++i) {
            allLogs.add((TaskEventSummary)Mockito.mock(TaskEventSummary.class));
        }
        Mockito.when((Object)this.taskService.getTaskEvents(serverTemplateId, containerId, TASK_ID, Integer.valueOf(0), Integer.valueOf(10))).thenReturn(allLogs.subList(0, 10));
        Mockito.when((Object)this.taskService.getTaskEvents(serverTemplateId, containerId, TASK_ID, Integer.valueOf(1), Integer.valueOf(10))).thenReturn(allLogs.subList(10, 12));
        this.presenter.onTaskSelectionEvent(new TaskSelectionEvent(serverTemplateId, containerId, TASK_ID));
        ArgumentCaptor argumentDESC = ArgumentCaptor.forClass(List.class);
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView)).setLogs((List)argumentDESC.capture());
        Assert.assertEquals((long)this.presenter.getPageSize(), (long)((List)argumentDESC.getValue()).size());
        ((TaskService)Mockito.verify((Object)this.taskService)).getTaskEvents(serverTemplateId, containerId, TASK_ID, Integer.valueOf(0), Integer.valueOf(10));
        this.presenter.loadMoreProcessInstanceLogs();
        ((TaskService)Mockito.verify((Object)this.taskService)).getTaskEvents(serverTemplateId, containerId, TASK_ID, Integer.valueOf(1), Integer.valueOf(10));
        ((TaskLogsPresenter.TaskLogsView)Mockito.verify((Object)this.taskLogsView, (VerificationMode)Mockito.times((int)2))).setLogs((List)argumentDESC.capture());
        Assert.assertEquals((long)testAllLogsSize, (long)((List)argumentDESC.getValue()).size());
    }

    private List<TaskEventSummary> createEventSummariesForTask(Long taskId) {
        TaskEventSummary added = new TaskEventSummary(Long.valueOf(1L), taskId, "ADDED", "Jan", Long.valueOf(3L), this.createDate(2017, Month.DECEMBER, 15), "Jan created this task");
        TaskEventSummary updated = new TaskEventSummary(Long.valueOf(2L), taskId, "UPDATED", "Maria", Long.valueOf(3L), this.createDate(2018, Month.JANUARY, 1), "Maria updated this task");
        TaskEventSummary claimed = new TaskEventSummary(Long.valueOf(3L), taskId, "CLAIMED", "John", Long.valueOf(3L), this.createDate(2018, Month.JANUARY, 20), "John claimed this task");
        List<TaskEventSummary> summaryList = Arrays.asList(added, updated, claimed);
        return summaryList;
    }

    private Date createDate(int year, Month month, int day) {
        LocalDate localDate = LocalDate.of(year, month, day);
        return Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }
}

